/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.Import;
import oracle.bpm.project.catalog.parser.xsd.Include;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import org.jetbrains.annotations.NotNull;

public class LoaderUtils {
    public static Set<Dependency> findSchemaDependencies(@NotNull URI baseUri, @NotNull Schema schema) throws TypeParseException {
        URI uri;
        if (baseUri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/LoaderUtils.findSchemaDependencies must not be null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/LoaderUtils.findSchemaDependencies must not be null");
        }
        TreeSet<Dependency> uris = new TreeSet<Dependency>();
        List<Import> imports = schema.findChildrenByClass(Import.class);
        for (Import anImport : imports) {
            String location = anImport.getSchemaLocation();
            String namespace = anImport.getImportedNamespace();
            if (Str.isEmpty(location) || ExtendedNamespace.isBuiltin(namespace)) continue;
            uri = baseUri.resolve(location);
            uris.add(new Dependency(uri, ResourceType.XML_SCHEMA));
        }
        List<Include> includes = schema.findChildrenByClass(Include.class);
        for (Include include : includes) {
            String s = include.getSchemaLocation();
            if (Str.isEmpty(s)) continue;
            uri = baseUri.resolve(s);
            uris.add(new Dependency(uri, ResourceType.XML_SCHEMA));
        }
        return uris;
    }
}

