/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.workflow.metadata.config.model.MessageAttributeType;
import oracle.bpel.services.workflow.metadata.config.model.PayloadType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParticipantsType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlipType;
import oracle.bpel.services.workflow.metadata.taskdefinition.TaskDefinitionUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.HumanTaskParseException;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.TaskDefinitionParsedObject;
import oracle.bpm.project.catalog.parser.xsd.SFSNamespace;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.soa.humantask.Payload;
import oracle.bpm.type.Argument;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import oracle.xml.jaxb.JaxbContextImpl;
import oracle.xml.jaxb.JaxbNode;
import org.jetbrains.annotations.NotNull;

@TypeLoaderMetadata(resourceType=ResourceType.HUMAN_TASK, isStructural=false, rootModules={"HumanTasks"})
public class HumanTaskTypeLoader
extends AbstractTypeLoader<TaskDefinition> {
    private JAXBContext jaxbContext;
    public static final String EXEC_DATA_ARG_NAME = "execData";
    public static final String INVOKE = "invoke";
    private static final String WORKFLOW_TASK_XSD = "WorkflowTask.xsd";
    private static final String XSD = "xsd";
    private static final String COMPLEX_TYPE = "COMPLEX_TYPE";
    private static final String SIMPLE_TYPE = "SIMPLE_TYPE";

    public HumanTaskTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
        this.jaxbContext = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Argument createTaskArgument(@NotNull MethodTypeDescription invoke, @NotNull ComponentCatalog catalog) {
        if (invoke == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.createTaskArgument must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.createTaskArgument must not be null");
        }
        String name = Identifier.attribute(EXEC_DATA_ARG_NAME);
        String argName = HumanTaskTypeLoader.findValidName(invoke, name);
        String uniqueId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.ELEMENT, (String)"http://xmlns.oracle.com/bpel/workflow/task", (String)"task").getId();
        BpmObjectDynamicRef ref = new BpmObjectDynamicRef(uniqueId, name, catalog);
        Argument argument = new Argument(argName, (TypeRef)ref, 3L);
        if (argument == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.createTaskArgument must not return null");
        }
        return argument;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Argument createOutcomeArgument(MethodTypeDescription invoke) {
        String name = Identifier.attribute("outcome");
        String argName = HumanTaskTypeLoader.findValidName(invoke, name);
        Argument argument = new Argument(argName, (TypeRef)TypeFactory.getString(), 2L);
        if (argument == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.createOutcomeArgument must not return null");
        }
        return argument;
    }

    public static MethodTypeDescription createInvokeMethod(@NotNull List<Payload.Attribute> attributes, @NotNull ComponentCatalog catalog) {
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.createInvokeMethod must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.createInvokeMethod must not be null");
        }
        MethodTypeDescription invoke = HumanTaskTypeLoader.buildInvokeMethod();
        for (Payload.Attribute att : attributes) {
            ArgumentAdapter argumentAdapter = new ArgumentAdapter(att);
            Argument arg = HumanTaskTypeLoader.buildArgument(argumentAdapter, catalog);
            invoke.addArgument(arg, true);
        }
        HumanTaskTypeLoader.addFixedArguments(invoke, catalog);
        return invoke;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ParsedObject<TaskDefinition> parseUri(@NotNull URI uri) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.parseUri must not be null");
        }
        InputStream inputStream = null;
        TaskDefinitionParsedObject parsedObject = null;
        try {
            inputStream = URLHelper.openStream((URL)URLHelper.createURL((URI)uri));
            if (this.jaxbContext == null) {
                TaskDefinitionUtil instance = TaskDefinitionUtil.getInstance();
                this.jaxbContext = JaxbContextImpl.createContext((String)instance.getJaxbContextString(), (ClassLoader)this.getClass().getClassLoader());
            }
            Unmarshaller u = this.jaxbContext.createUnmarshaller();
            TaskDefinition definition = (TaskDefinition)u.unmarshal(inputStream);
            parsedObject = new TaskDefinitionParsedObject(uri, definition);
        }
        catch (JAXBException e) {
            try {
                throw new HumanTaskParseException(uri, e);
                catch (IOException e2) {
                    throw new HumanTaskParseException(uri, e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close(inputStream);
        TaskDefinitionParsedObject taskDefinitionParsedObject = parsedObject;
        if (taskDefinitionParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.parseUri must not return null");
        }
        return taskDefinitionParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<TaskDefinition> parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.loadTypes must not be null");
        }
        TaskDefinition definition = parsedObject.getParsedData();
        String nativeName = definition.getName();
        String taskName = Identifier.classname(nativeName);
        ObjectTypeDescription humanTask = new ObjectTypeDescription(taskName);
        this.initCommonProperties(humanTask, definition, parsedObject.getUri());
        MethodTypeDescription invoke = this.createInvokeMethod(definition);
        humanTask.addMember(invoke);
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
        result.put("HumanTasks." + humanTask.getName(), (TypeDescription)humanTask);
        HashMap<String, TypeDescription> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.loadTypes must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String findPattern(ParticipantsType participantsType) {
        List list;
        String pattern = HumanTaskType.COMPLEX.name();
        boolean adhocRoutingSupported = participantsType.isIsAdhocRoutingSupported();
        if (!adhocRoutingSupported && (list = participantsType.getParticipantOrSequentialParticipantOrAdhoc()) != null && !list.isEmpty()) {
            if (list.size() > 1) {
                pattern = HumanTaskType.COMPLEX.name();
            } else {
                ParticipantsType.Stage stage;
                List children;
                Object first = list.get(0);
                if (first instanceof ParticipantsType.Stage && (children = (stage = (ParticipantsType.Stage)first).getParticipantOrSequentialParticipantOrAdhoc()) != null && !children.isEmpty()) {
                    if (children.size() > 1) {
                        pattern = HumanTaskType.COMPLEX.name();
                    } else {
                        Object child = children.get(0);
                        if (child instanceof ParticipantsType.Participant) {
                            pattern = HumanTaskType.SIMPLE.name();
                        } else if (child instanceof ParticipantsType.Fyi) {
                            pattern = HumanTaskType.FYI.name();
                        } else if (child instanceof ParticipantsType.SequentialParticipant) {
                            pattern = HumanTaskType.MANAGEMENT.name();
                        } else if (child instanceof ParticipantsType.Parallel) {
                            pattern = HumanTaskType.GROUP.name();
                        }
                    }
                }
            }
        }
        String string = pattern;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.findPattern must not return null");
        }
        return string;
    }

    private static String findValidName(MethodTypeDescription invoke, String name) {
        String argName = name;
        Argument argument = invoke.findArgument(argName);
        int i = 2;
        while (argument != null) {
            argName = name + i;
            argument = invoke.findArgument(argName);
            ++i;
        }
        return argName;
    }

    private static MethodTypeDescription buildInvokeMethod() {
        return new MethodTypeDescription(INVOKE);
    }

    private static void addFixedArguments(MethodTypeDescription invoke, ComponentCatalog catalog) {
        invoke.addArgument(HumanTaskTypeLoader.createTaskArgument(invoke, catalog));
        invoke.addArgument(HumanTaskTypeLoader.createOutcomeArgument(invoke));
    }

    private static Argument buildArgument(ArgumentAdapter argumentAdapter, ComponentCatalog catalog) {
        TypeRef ref = HumanTaskTypeLoader.findArgumentType(argumentAdapter, catalog);
        String nativeName = argumentAdapter.getNativeName();
        String argName = argumentAdapter.getName();
        long modifiers = argumentAdapter.isEditable() ? 3L : 1L;
        Argument arg = new Argument(argName, ref, modifiers);
        arg.setProperty("nativeName", nativeName);
        return arg;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static TypeRef findArgumentType(@NotNull ArgumentAdapter arg, @NotNull ComponentCatalog catalog) {
        TypeRef ref;
        if (arg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.findArgumentType must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.findArgumentType must not be null");
        }
        String type = arg.getType();
        String attrNamespace = arg.getNamespace();
        String localname = XmlUtils.localname((String)type);
        String name = arg.getName();
        if (arg.isSimple()) {
            TypeDescription td = SFSNamespace.S2001_NAMESPACE.getAllDefinedTypesByName().get(localname);
            if (td != null) {
                ref = td.getRef();
            } else {
                String id = UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)"http://www.w3.org/2001/XMLSchema", (String)localname).getId();
                ref = new BpmObjectDynamicRef(id, name, catalog);
            }
        } else {
            XmlElementType elementType = arg.isComplex() ? XmlElementType.TYPE : XmlElementType.ELEMENT;
            String uniqueId = UUIDFactory.createXmlId((XmlElementType)elementType, (String)attrNamespace, (String)localname).getId();
            ref = new BpmObjectDynamicRef(uniqueId, name, catalog);
        }
        TypeRef typeRef = ref;
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.findArgumentType must not return null");
        }
        return typeRef;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private MethodTypeDescription createInvokeMethod(@NotNull TaskDefinition definition) throws TypeBuildException {
        if (definition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.createInvokeMethod must not be null");
        }
        MethodTypeDescription invoke = HumanTaskTypeLoader.buildInvokeMethod();
        WorkflowConfigurationType workflowConfiguration = definition.getWorkflowConfiguration();
        if (workflowConfiguration != null) {
            PayloadType payload = workflowConfiguration.getPayload();
            for (Object attributes : payload.getMessageAttribute()) {
                if (!(attributes instanceof MessageAttributeType)) continue;
                ArgumentAdapter argumentAdapter = new ArgumentAdapter((MessageAttributeType)attributes, workflowConfiguration);
                Argument arg = HumanTaskTypeLoader.buildArgument(argumentAdapter, this.getCatalog());
                invoke.addArgument(arg, true);
            }
            HumanTaskTypeLoader.addFixedArguments(invoke, this.getCatalog());
        }
        MethodTypeDescription methodTypeDescription = invoke;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.createInvokeMethod must not return null");
        }
        return methodTypeDescription;
    }

    private void initCommonProperties(@NotNull ObjectTypeDescription humanTask, @NotNull TaskDefinition definition, @NotNull URI uri) throws TypeBuildException {
        if (humanTask == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.initCommonProperties must not be null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.initCommonProperties must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.initCommonProperties must not be null");
        }
        String taskName = definition.getName();
        String targetNamespace = definition.getTargetNamespace();
        humanTask.setProperty("targetNamespace", targetNamespace);
        humanTask.setComponentType(ComponentType.HUMAN_TASK.getText());
        humanTask.setNativeName(taskName);
        String taskId = definition.getId();
        humanTask.setProperty("human.task.id", taskId);
        VFile vfile = this.uriToVFile(uri);
        VFile workflowTaskFile = this.getXsdTaskFile(vfile, taskName);
        humanTask.setTransientProperty("Workflowtask.file", (Object)workflowTaskFile);
        WorkflowConfigurationType workflowConfiguration = definition.getWorkflowConfiguration();
        if (workflowConfiguration != null) {
            String pattern;
            if (workflowConfiguration.isGlobalCreationTask()) {
                pattern = HumanTaskType.INITIATOR.name();
            } else {
                RoutingSlipType slip = definition.getRoutingSlip();
                ParticipantsType participantsType = slip != null ? slip.getParticipants() : null;
                pattern = participantsType == null ? HumanTaskType.COMPLEX.name() : HumanTaskTypeLoader.findPattern(participantsType);
            }
            humanTask.setProperty("human.task.pattern", pattern);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private VFile getXsdTaskFile(@NotNull VFile vfile, @NotNull String taskName) {
        if (vfile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.getXsdTaskFile must not be null");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.getXsdTaskFile must not be null");
        }
        VFileSystem fileSystem = vfile.getFileSystem();
        VFile parentFile = vfile.getParentFile();
        String fileName = "/xsd/" + taskName + WORKFLOW_TASK_XSD;
        VFile vFile = fileSystem.createFile(parentFile, fileName);
        if (vFile == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/HumanTaskTypeLoader.getXsdTaskFile must not return null");
        }
        return vFile;
    }

    static class ArgumentAdapter {
        final MessageAttributeType msg;
        final Payload.Attribute payload;
        final WorkflowConfigurationType workflowConfiguration;

        public ArgumentAdapter(Payload.Attribute payload) {
            this.payload = payload;
            this.msg = null;
            this.workflowConfiguration = null;
        }

        public ArgumentAdapter(MessageAttributeType msg, WorkflowConfigurationType workflowConfiguration) {
            this.msg = msg;
            this.workflowConfiguration = workflowConfiguration;
            this.payload = null;
        }

        public boolean isEditable() {
            boolean result = this.payload != null ? this.payload.isEditable() : this.msg.isUpdatable();
            return result;
        }

        public boolean isSimple() {
            boolean result;
            if (this.payload != null) {
                result = this.payload.getAttributeType().isSimple();
            } else {
                String attrType = this.msg.getAttributeType();
                result = HumanTaskTypeLoader.SIMPLE_TYPE.equals(attrType);
            }
            return result;
        }

        public boolean isComplex() {
            boolean result;
            if (this.payload != null) {
                result = this.payload.getAttributeType().isComplex();
            } else {
                String attrType = this.msg.getAttributeType();
                result = HumanTaskTypeLoader.COMPLEX_TYPE.equals(attrType);
            }
            return result;
        }

        public String getNativeName() {
            String result = this.payload != null ? this.payload.getName() : this.msg.getName();
            return result;
        }

        public String getName() {
            String result = this.payload != null ? Identifier.argument(this.payload.getName()) : Identifier.argument(this.msg.getName());
            return result;
        }

        public String getType() {
            String result = this.payload != null ? this.payload.getType() : this.msg.getType();
            return result;
        }

        public String getNamespace() {
            String result;
            if (this.payload != null) {
                result = this.payload.getQName().getNamespaceURI();
            } else if (this.workflowConfiguration instanceof JaxbNode) {
                JaxbNode jaxbNode = (JaxbNode)this.workflowConfiguration;
                String prefix = XmlUtils.prefix((String)this.msg.getType());
                result = (String)jaxbNode.getDOMNode().getAllNamespaceAttrs().get(prefix);
            } else {
                result = "";
            }
            return result;
        }
    }
}

