/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.bpel.services.rules.rpi.model.TRuleEngineRepository;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeImport;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.ScaWsdlInfo;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.SpringDependency;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.type.utils.NotificationServiceHelper;
import oracle.bpm.project.model.CompositeServiceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeParsedObject
extends ParsedObject<CompositeInfo> {
    private final Set<Dependency> dependencies;

    public CompositeParsedObject(@NotNull URI uri, @Nullable CompositeInfo parsedData) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.<init> must not be null");
        }
        super(uri, parsedData);
        this.dependencies = this.parseDepedencies();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        Set<Dependency> set = this.dependencies;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.getDependencies must not return null");
        }
        return set;
    }

    private static Iterable<CompositeInterface> filterInterfaces(@NotNull Iterable<CompositeInterface> compositeInterfaces, @NotNull CatalogInterfaceType interfaceType, @NotNull Iterable<CompositeComponent> components) {
        if (compositeInterfaces == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.filterInterfaces must not be null");
        }
        if (interfaceType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.filterInterfaces must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.filterInterfaces must not be null");
        }
        ArrayList<CompositeInterface> result = new ArrayList<CompositeInterface>();
        for (CompositeInterface compositeInterface : compositeInterfaces) {
            CompositeServiceType catalogServiceType = compositeInterface.getComponentType();
            if (!Utils.shouldPromoteService(compositeInterface, interfaceType, components)) continue;
            result.add(compositeInterface);
        }
        return result;
    }

    private static void addInterfaceDependencies(@NotNull Set<Dependency> result, @NotNull Iterable<CompositeInterface> compositeInterface) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addInterfaceDependencies must not be null");
        }
        if (compositeInterface == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addInterfaceDependencies must not be null");
        }
        CompositeParsedObject.addInterfaceDependencies(result, compositeInterface, false);
    }

    private static void addSpringDependencies(@NotNull Set<Dependency> result, @NotNull Iterable<CompositeInterface> compositeInterface) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addSpringDependencies must not be null");
        }
        if (compositeInterface == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addSpringDependencies must not be null");
        }
        CompositeParsedObject.addInterfaceDependencies(result, compositeInterface, true);
    }

    private static void addInterfaceDependencies(@NotNull Set<Dependency> result, @NotNull Iterable<CompositeInterface> compositeInterface, boolean isSpring) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addInterfaceDependencies must not be null");
        }
        if (compositeInterface == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addInterfaceDependencies must not be null");
        }
        for (CompositeInterface ref : compositeInterface) {
            URI uri = CompositeParsedObject.getFixedLocation(ref);
            if (isSpring) {
                result.add(new SpringDependency(uri, ResourceType.WSDL));
                continue;
            }
            result.add(new Dependency(uri, ResourceType.WSDL));
        }
    }

    private static URI getFixedLocation(CompositeInterface ref) {
        URI uri = ref.getLocation();
        String namespaceURI = ref.getService().getNamespaceURI();
        if (NotificationServiceHelper.NOTIFICATION_SERVICE_NAMESPACE.equals(namespaceURI) && !"oramds".equals(uri.getScheme())) {
            ScaWsdlInfo notificationScaWsdlInfo = NotificationServiceHelper.NOTIFICATION_SCA_WSDL_INFO;
            try {
                uri = new URI(notificationScaWsdlInfo.location);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static DecisionServices loadDecisionServices(@NotNull VFile decsFile) {
        DecisionServices services;
        block6: {
            if (decsFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.loadDecisionServices must not be null");
            }
            services = null;
            try {
                if (!decsFile.exists()) break block6;
                RuleEngineFactory factory = RuleEngineFactory.getInstance();
                Unmarshaller unmarshaller = factory.createUnmarshaller();
                BufferedInputStream is = new BufferedInputStream((InputStream)new VFileInputStream(decsFile));
                try {
                    services = (DecisionServices)unmarshaller.unmarshal((InputStream)is);
                    ((InputStream)is).close();
                }
                catch (Throwable throwable) {
                    StreamUtils.close(is);
                    throw throwable;
                }
                StreamUtils.close(is);
            }
            catch (IOException ignore) {
                services = null;
            }
            catch (JAXBException ignore) {
                services = null;
            }
        }
        return services;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Set<Dependency> parseDepedencies() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        CompositeInfo controller = (CompositeInfo)this.getParsedData();
        Iterable<CompositeComponent> components = controller.getComponents();
        for (CompositeComponent component : components) {
            CompositeServiceType type = component.getComponentType();
            if (CompositeServiceType.BUSINESS_RULE.equals(type)) {
                this.addRuleDependencies(this.getUri(), result, component);
                continue;
            }
            if (CompositeServiceType.HUMAN_TASK.equals(type)) {
                this.addHumanTaskDependencies(result, component);
                continue;
            }
            if (CompositeServiceType.SPRING.equals(type)) {
                CompositeParsedObject.addSpringDependencies(result, component.getServices());
                CompositeParsedObject.addSpringDependencies(result, component.getReferences());
                continue;
            }
            if (CompositeServiceType.BPMN.equals(type)) continue;
            CompositeParsedObject.addInterfaceDependencies(result, component.getServices());
            CompositeParsedObject.addInterfaceDependencies(result, component.getReferences());
        }
        CompositeParsedObject.addInterfaceDependencies(result, CompositeParsedObject.filterInterfaces(controller.getReferences(), CatalogInterfaceType.SERVICE, components));
        CompositeParsedObject.addInterfaceDependencies(result, CompositeParsedObject.filterInterfaces(controller.getServices(), CatalogInterfaceType.REFERENCE, components));
        this.addImportsDependencies(result, controller.getImports());
        HashSet<Dependency> hashSet = result;
        if (hashSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.parseDepedencies must not return null");
        }
        return hashSet;
    }

    private void addImportsDependencies(@NotNull Set<Dependency> result, @NotNull Iterable<CompositeImport> imports) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addImportsDependencies must not be null");
        }
        if (imports == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/CompositeParsedObject.addImportsDependencies must not be null");
        }
        for (CompositeImport compositeImport : imports) {
            if (compositeImport.getImportType() == ResourceType.WSDL) continue;
            URI location = this.getUri().resolve(compositeImport.getLocation());
            result.add(new Dependency(location, compositeImport.getImportType()));
        }
    }

    private void addHumanTaskDependencies(Set<Dependency> result, CompositeComponent component) {
        String location = component.getSrcLocation();
        if (location != null) {
            URI humanTaskUri = this.getUri().resolve(location);
            result.add(new Dependency(humanTaskUri, ResourceType.HUMAN_TASK));
        }
    }

    private void addRuleDependencies(URI uri, Set<Dependency> result, CompositeComponent component) {
        DecisionServices decisionServices;
        URI dec;
        VFile vfile;
        String location = component.getSrcLocation();
        if (location != null && (vfile = URLHelper.getFromURI((URI)(dec = this.getUri().resolve(location)))) != null && (decisionServices = CompositeParsedObject.loadDecisionServices(vfile)) != null) {
            List engineProviders = decisionServices.getRuleEngineProviders();
            for (TRuleEngineProvider engine : engineProviders) {
                TRuleEngineRepository ruleEngineRepository = engine.getRepository();
                String path = ruleEngineRepository.getPath();
                String relativePath = path.substring(path.indexOf("/") + 1, path.length());
                URI ruleUri = uri.resolve(relativePath);
                result.add(new Dependency(ruleUri, ResourceType.BUSINESS_RULE));
            }
        }
    }
}

