/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.PortTypeUUID;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.BpmObjectParsedObject;
import oracle.bpm.project.catalog.loaders.impl.ServiceDefinitionParsedObject;
import oracle.bpm.project.catalog.loaders.impl.WsdlTypeLoader;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Binding;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.PortDefinition;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xmlparser.ParserContext;
import oracle.bpm.project.catalog.parser.xsd.Annotation;
import oracle.bpm.project.catalog.parser.xsd.Documentation;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.type.ErrorTypeFactory;
import oracle.bpm.project.catalog.type.parser.BpmoBinding;
import oracle.bpm.project.catalog.type.parser.BpmoDelegate;
import oracle.bpm.project.catalog.type.parser.BpmoOperation;
import oracle.bpm.project.catalog.type.parser.BpmoProperties;
import oracle.bpm.project.catalog.type.parser.BpmoProperty;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.impl.TypeErrorImpl;
import oracle.bpm.type.utils.XmlUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TypeLoaderMetadata(resourceType=ResourceType.BPM_OBJECT, isStructural=false, rootModules={"Types", "References", "Errors"})
public final class BpmObjectTypeLoader
extends WsdlTypeLoader {
    private URI compositeUri;

    public BpmObjectTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
        this.compositeUri = this.buildCompositeUri(fileSystem);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<ServiceDefinition> parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.loadTypes must not be null");
        }
        Hashtable<String, TypeDescription> typesByName = new Hashtable<String, TypeDescription>();
        ServiceDefinition def = parsedObject.getParsedData();
        VFile vfile = this.uriToVFile(parsedObject.getUri());
        String typeName = Utils.getTypeName(vfile, "businessCatalog");
        TypeDescription typeDesc = this.loadType(typeName, def);
        ObjectTypeDescription otd = typeDesc.asObject();
        typesByName.put(typeName, typeDesc);
        if (otd.getInnerTypeCount() > 0) {
            ObjectTypeDescription callback = otd.getInnerType(0);
            typesByName.put(Utils.getTypeName(vfile, "businessCatalog") + "." + "Callback", (TypeDescription)callback);
        }
        Hashtable<String, TypeDescription> hashtable = typesByName;
        if (hashtable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.loadTypes must not return null");
        }
        return hashtable;
    }

    public TypeDescription loadType(@NotNull String typeName, @NotNull ServiceDefinition def) throws TypeBuildException {
        PortDefinition port;
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.loadType must not be null");
        }
        if (def == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.loadType must not be null");
        }
        String targetNamespace = def.getTargetNamespace();
        if (!Utils.isBpmObjectNamespace(targetNamespace)) {
            String name = TypeUtils.shortName((String)typeName);
            return this.createInvalidBpmObject(name, ProjectCatalogMsg.INVALID_BPMO_NAMESPACE(targetNamespace));
        }
        try {
            def.buildTypesFromPortTypes(new ParserContext());
        }
        catch (TypeBuildException e) {
            return this.createInvalidBpmObject(typeName, def, e);
        }
        List<Binding> bindings = def.getBindings();
        List<PortDefinition> ports = def.getPortDefinitions();
        if (bindings.isEmpty()) {
            String name = TypeUtils.shortName((String)typeName);
            return this.createInvalidBpmObject(name, ProjectCatalogMsg.MISSING_BPMO_BINDING(name));
        }
        if (ports.isEmpty()) {
            String name = TypeUtils.shortName((String)typeName);
            return this.createInvalidBpmObject(name, ProjectCatalogMsg.MISSING_BPMO_PORT(name));
        }
        Binding binding = bindings.get(0);
        TypeDescription bpmObject = this.createBpmObject(def, binding, port = ports.get(0), false);
        if (bpmObject.isObject()) {
            TypeDescription callbackType;
            if (bindings.size() > 1 && (callbackType = this.createBpmObject(def, binding = bindings.get(1), port = ports.get(1), true)).isObject()) {
                ObjectTypeDescription otd = bpmObject.asObject();
                otd.addInnerType(callbackType.getRef());
                ObjectTypeDescription callbackOtd = callbackType.asObject();
                String interfaceObject = callbackOtd.getProperty("interface.object");
                if (interfaceObject != null) {
                    otd.setProperty("interface.object", interfaceObject);
                    this.fixCustomizedService(callbackOtd);
                }
            }
            this.fixCustomizedService(bpmObject.asObject());
        }
        return bpmObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected ServiceDefinitionParsedObject buildParsedObject(@NotNull URI uri, @NotNull ServiceDefinition definition) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildParsedObject must not be null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildParsedObject must not be null");
        }
        BpmObjectParsedObject bpmObjectParsedObject = new BpmObjectParsedObject(uri, definition, this.compositeUri);
        if (bpmObjectParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildParsedObject must not return null");
        }
        return bpmObjectParsedObject;
    }

    private static String prefix(String qname) {
        return XmlUtils.prefix((String)qname);
    }

    private static String localname(String qname) {
        return XmlUtils.localname((String)qname);
    }

    private void fixCustomizedService(@NotNull ObjectTypeDescription bpmObject) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.fixCustomizedService must not be null");
        }
        if (TypeUtils.isService((TypeRef)bpmObject)) {
            for (MethodTypeDescription method : bpmObject.getMethods()) {
                if (!method.isDelegated()) continue;
                DelegatedMethodTypeDescription delegatedMethod = (DelegatedMethodTypeDescription)method;
                bpmObject.setTransientProperty("service.type.ref", (Object)delegatedMethod.getDelegatedServiceRef());
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private ObjectTypeDescription createInvalidBpmObject(@NotNull String name, @NotNull ErrorMsg errorMsg) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidBpmObject must not be null");
        }
        if (errorMsg == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidBpmObject must not be null");
        }
        XObjectTypeDescription xObjectTypeDescription = ErrorTypeFactory.createErrorBO(name, errorMsg, this.getCatalog(), null);
        if (xObjectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidBpmObject must not return null");
        }
        return xObjectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TypeDescription createInvalidBpmObject(@NotNull String typeName, @NotNull ServiceDefinition def, @NotNull TypeBuildException e) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidBpmObject must not be null");
        }
        if (def == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidBpmObject must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidBpmObject must not be null");
        }
        String name = TypeUtils.shortName((String)typeName);
        String module = TypeUtils.moduleName((String)typeName, (String)"");
        XObjectTypeDescription xotd = ErrorTypeFactory.createErrorBO(name, module, this.getCatalog(), e);
        List<BpmoProperty> properties = def.findRecursiveChildrenByClass(BpmoProperty.class);
        for (BpmoProperty prop : properties) {
            if (!"interface.object".equals(prop.getKey())) continue;
            xotd.setProperty("interface.object", prop.getValue());
            break;
        }
        XObjectTypeDescription xObjectTypeDescription = xotd;
        if (xObjectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidBpmObject must not return null");
        }
        return xObjectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TypeDescription createBpmObject(@NotNull ServiceDefinition def, @NotNull Binding binding, @NotNull PortDefinition port, boolean isCallback) throws TypeBuildException {
        ObjectTypeDescription objectTypeDescription;
        if (def == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createBpmObject must not be null");
        }
        if (binding == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createBpmObject must not be null");
        }
        if (port == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createBpmObject must not be null");
        }
        BpmoBinding bpmoBinding = (BpmoBinding)binding.getFirstElement();
        String bpmObjectName = isCallback ? "Callback" : def.getAttribute("name");
        String type = bpmoBinding.getAttribute("type");
        String element = bpmoBinding.getAttribute("element");
        String prefix = type == null ? BpmObjectTypeLoader.prefix(element) : BpmObjectTypeLoader.prefix(type);
        String localName = type == null ? BpmObjectTypeLoader.localname(element) : BpmObjectTypeLoader.localname(type);
        NamespaceContext context = def.getNSContext();
        ExtendedNamespace extendedNamespace = (ExtendedNamespace)context.findNamespace(prefix);
        if (extendedNamespace == null) {
            objectTypeDescription = this.createInvalidBpmObject(bpmObjectName, LibMsg.CANNOT_FIND_VALID_NAMESPACE_FOR_PREFIX((String)prefix));
            if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createBpmObject must not return null");
            return objectTypeDescription;
        }
        if (bpmoBinding.isBaseOnTypeOrElement()) {
            XmlUUID superTypeId;
            XmlUUID attId;
            String namespace = extendedNamespace.getUri();
            if (type != null) {
                superTypeId = attId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)namespace, (String)localName);
            } else if (Utils.isBpmObjectNamespace(namespace)) {
                attId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)namespace, (String)(localName + "Type"));
                superTypeId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.ELEMENT, (String)namespace, (String)localName);
            } else {
                superTypeId = attId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.ELEMENT, (String)namespace, (String)localName);
            }
            TypeRef attRef = this.getTypeFinder().findById(ComponentType.XML.getText(), attId.getId());
            TypeRef superTypeRef = attId.getId().equals(superTypeId.getId()) ? attRef : this.getTypeFinder().findById(ComponentType.XML.getText(), superTypeId.getId());
            TypeDescription typeDescription = null;
            if (attRef != null && superTypeRef != null) {
                typeDescription = attRef.get();
            }
            if (typeDescription != null && typeDescription.isXmlObject()) {
                XmlTypeDescription xmlOtd = (XmlTypeDescription)typeDescription;
                this.fixHolderAttributes(xmlOtd);
                XmlTypeDescription baseType = (XmlTypeDescription)superTypeRef.get();
                XObjectTypeDescription bpmObject = BpmObjectFactory.createXObjectTypeDescriptionWithExtAttr((String)bpmObjectName, (ComponentCatalog)this.getCatalog(), (XmlTypeDescription)baseType);
                long modifiers = bpmoBinding.getModifiers();
                bpmObject.setModifiers(modifiers);
                this.addProperties(bpmoBinding, bpmObject);
                this.addDocumentation((TypeDescription)bpmObject, def.findChildrenByClass(Annotation.class));
                this.removeConstructor(bpmObject);
                this.addOperations(binding, port.getOperations(), bpmObject, xmlOtd);
                this.checkInterfaceObjectProperty(bpmObject);
                bpmObject.setName(bpmObjectName);
                objectTypeDescription = bpmObject;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createBpmObject must not return null");
                return objectTypeDescription;
            }
            QName qName = new QName(extendedNamespace.getUri(), localName);
            ErrorMsg msg = ProjectCatalogMsg.MISSING_BPMO_SCHEMA(qName, bpmObjectName);
            objectTypeDescription = this.createInvalidBpmObject(bpmObjectName, msg);
            if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createBpmObject must not return null");
            return objectTypeDescription;
        }
        ErrorMsg msg = ProjectCatalogMsg.INVALID_BPMO_FORMAT(bpmObjectName);
        objectTypeDescription = this.createInvalidBpmObject(bpmObjectName, msg);
        if (objectTypeDescription != null) return objectTypeDescription;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createBpmObject must not return null");
    }

    private void removeConstructor(XObjectTypeDescription bpmObject) {
        MethodTypeDescription constructor = bpmObject.findMethod(bpmObject.getName());
        if (constructor != null) {
            bpmObject.removeMember(constructor);
        }
    }

    private void addOperations(@NotNull Binding binding, @NotNull List<Operation> operations, @NotNull XObjectTypeDescription bpmObject, @NotNull XmlTypeDescription xmlOtd) throws TypeBuildException {
        if (binding == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.addOperations must not be null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.addOperations must not be null");
        }
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.addOperations must not be null");
        }
        if (xmlOtd == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.addOperations must not be null");
        }
        for (Operation operation : operations) {
            Operation bindingOperation = binding.getOperation(operation.getName());
            MethodTypeDescription mtd = null;
            BpmoProperties methodProperties = null;
            if (bindingOperation == null) {
                bpmObject.addError((TypeError)TypeErrorImpl.create((ErrorMsg)ProjectCatalogMsg.MISSING_OPERATION(operation.getName())));
            } else {
                DefaultElement firstElement = bindingOperation.getFirstElement();
                if (firstElement instanceof BpmoProperties) {
                    methodProperties = (BpmoProperties)firstElement;
                    firstElement = methodProperties.getNextElement();
                }
                if (firstElement instanceof BpmoOperation) {
                    BpmoOperation bpmoOperation = (BpmoOperation)firstElement;
                    mtd = bpmoOperation.buildMethodTypeDescription(operation, bpmObject, xmlOtd);
                } else if (firstElement instanceof BpmoDelegate) {
                    BpmoDelegate bpmoDelegate = (BpmoDelegate)firstElement;
                    mtd = this.buildDelegatedMethod(bpmObject, operation, bindingOperation, bpmoDelegate);
                } else {
                    mtd = null;
                    bpmObject.addError((TypeError)TypeErrorImpl.create((ErrorMsg)ProjectCatalogMsg.INVALID_BPMO_FORMAT(bpmObject.getName())));
                }
            }
            if (mtd == null) continue;
            if (mtd.hasErrors()) {
                for (TypeError type : mtd.getErrors()) {
                    bpmObject.addError(type);
                }
            }
            if (mtd.isAttribute()) {
                if (xmlOtd.findAttribute(mtd.getName()) == null) {
                    xmlOtd.addMember(mtd);
                }
            } else {
                bpmObject.addMember(mtd);
            }
            this.addDocumentation((TypeDescription)mtd, operation.findChildrenByClass(Annotation.class));
            if (methodProperties != null) {
                mtd.setProperties(methodProperties.getProperties());
                continue;
            }
            mtd.setProperties(new TreeMap());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private MethodTypeDescription buildDelegatedMethod(@NotNull XObjectTypeDescription bpmObject, @NotNull Operation operation, @NotNull Operation bindingOperation, @NotNull BpmoDelegate bpmoDelegate) throws TypeBuildException {
        MethodTypeDescription mtd;
        MethodTypeDescription methodTypeDescription;
        block15: {
            String methodName;
            block13: {
                PortTypeUUID portTypeId;
                String signature;
                String delegatedNamespace;
                String delegatedPortType;
                block14: {
                    if (bpmObject == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedMethod must not be null");
                    }
                    if (operation == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedMethod must not be null");
                    }
                    if (bindingOperation == null) {
                        throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedMethod must not be null");
                    }
                    if (bpmoDelegate == null) {
                        throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedMethod must not be null");
                    }
                    methodName = bindingOperation.getName();
                    if (!this.validateDelegatedProperties(bpmObject, bpmoDelegate)) break block13;
                    delegatedPortType = bpmoDelegate.getDelegatedPortType();
                    delegatedNamespace = bpmoDelegate.getDelegatedNamespace();
                    signature = bpmoDelegate.getMethodSignature();
                    assert (delegatedNamespace != null && delegatedPortType != null);
                    portTypeId = UUIDFactory.createPortTypeId((String)delegatedNamespace, (String)delegatedPortType);
                    if (methodName == null) {
                        methodTypeDescription = this.createInvalidDelegatedMethod("", portTypeId, "", ProjectCatalogMsg.MISSING_DELEGATED_OPERATION_NAME(bpmObject.getName()));
                        if (methodTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedMethod must not return null");
                        return methodTypeDescription;
                    }
                    String serviceId = this.createServiceObjectId(bpmObject, portTypeId);
                    bpmObject.setProperty("service.object.id", serviceId);
                    String uniqueId = portTypeId.getId();
                    String portTypeComponentType = ComponentType.PORT_TYPE.getText();
                    TypeRef typeRef = this.getTypeFinder().findById(portTypeComponentType, uniqueId);
                    if (typeRef == null) break block14;
                    ObjectTypeDescription originalTd = typeRef.get().asObject();
                    MethodTypeDescription originalMtd = originalTd.getMemberBySignature(signature);
                    if (originalMtd != null) {
                        mtd = this.buildDelegatedOperation(operation, bpmoDelegate, methodName, uniqueId, signature);
                        boolean validArguments = this.checkArguments(mtd, originalMtd);
                        if (!validArguments) {
                            ErrorMsg msg = ProjectCatalogMsg.NONMATCHING_ARGS_DELEGATED_OPERATION(methodName, signature);
                            mtd = this.createInvalidDelegatedMethod(methodName, portTypeId, signature, msg);
                        }
                        break block15;
                    } else {
                        ErrorMsg msg = ProjectCatalogMsg.MISSING_DELEGATED_OPERATION(methodName, signature);
                        mtd = this.createInvalidDelegatedMethod(methodName, portTypeId, signature, msg);
                    }
                    break block15;
                }
                QName qName = new QName(delegatedNamespace, delegatedPortType);
                ErrorMsg msg = ProjectCatalogMsg.DELEGATED_SERVICE_NOT_FOUND(methodName, qName.toString());
                mtd = this.createInvalidDelegatedMethod(methodName, portTypeId, signature, msg);
                break block15;
            }
            mtd = this.createInvalidDelegatedMethod(methodName, bpmObject, bpmoDelegate);
        }
        if ((methodTypeDescription = mtd) != null) return methodTypeDescription;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedMethod must not return null");
    }

    private String createServiceObjectId(@NotNull XObjectTypeDescription bpmObject, @NotNull PortTypeUUID portTypeId) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createServiceObjectId must not be null");
        }
        if (portTypeId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createServiceObjectId must not be null");
        }
        String target = bpmObject.getProperty("target");
        String targetPort = bpmObject.getProperty("target.port");
        return UUIDFactory.createServiceId((String)portTypeId.getNamespace(), (String)portTypeId.getNativeName(), (String)target, (String)targetPort).getId();
    }

    private MethodTypeDescription createInvalidDelegatedMethod(@NotNull String methodName, @NotNull PortTypeUUID portTypeUUID, @NotNull String signature, @NotNull ErrorMsg msg, @Nullable Exception e) {
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        if (portTypeUUID == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        if (msg == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        DelegatedMethodTypeDescription mtd = new DelegatedMethodTypeDescription(methodName, portTypeUUID, signature, this.getCatalog());
        TypeErrorImpl error = e == null ? TypeErrorImpl.create((ErrorMsg)msg) : TypeErrorImpl.create((ErrorMsg)msg, (Exception)e);
        mtd.addError((TypeError)error);
        return mtd;
    }

    private MethodTypeDescription createInvalidDelegatedMethod(@NotNull String methodName, @NotNull PortTypeUUID portTypeUUID, @NotNull String signature, @NotNull ErrorMsg msg) {
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        if (portTypeUUID == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        if (msg == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        return this.createInvalidDelegatedMethod(methodName, portTypeUUID, signature, msg, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private MethodTypeDescription createInvalidDelegatedMethod(@NotNull String methodName, @NotNull XObjectTypeDescription bpmObject, @NotNull BpmoDelegate bpmoDelegate) {
        ErrorMsg msg;
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        if (bpmoDelegate == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not be null");
        }
        String target = bpmObject.getProperty("target");
        String delegatedPortType = bpmoDelegate.getDelegatedPortType();
        String delegatedNamespace = bpmoDelegate.getDelegatedNamespace();
        String signature = bpmoDelegate.getMethodSignature();
        ArrayList<TypeErrorImpl> errors = new ArrayList<TypeErrorImpl>();
        if (target == null) {
            msg = ProjectCatalogMsg.DELEGATED_SERVICE_WITHOUT_TARGET(bpmObject.getText());
            errors.add(TypeErrorImpl.create((ErrorMsg)msg));
        }
        if (delegatedPortType == null) {
            msg = ProjectCatalogMsg.DELEGATED_OPERATION_WITHOUT_PORT(methodName);
            errors.add(TypeErrorImpl.create((ErrorMsg)msg));
            delegatedPortType = "";
        }
        if (delegatedNamespace == null) {
            msg = ProjectCatalogMsg.DELEGATED_OPERATION_WITHOUT_NAMESPACE(methodName);
            errors.add(TypeErrorImpl.create((ErrorMsg)msg));
            delegatedNamespace = "";
        }
        if (Str.isEmpty(signature)) {
            msg = ProjectCatalogMsg.DELEGATED_OPERATION_WITHOUT_SIGNATURE(methodName);
            errors.add(TypeErrorImpl.create((ErrorMsg)msg));
            signature = "";
        }
        PortTypeUUID id = UUIDFactory.createPortTypeId((String)delegatedNamespace, (String)delegatedPortType);
        DelegatedMethodTypeDescription result = new DelegatedMethodTypeDescription(methodName, id, signature, this.getCatalog());
        for (TypeError typeError : errors) {
            result.addError(typeError);
        }
        result.setTransientProperty("invalid.bpmo.element", (Object)bpmoDelegate);
        DelegatedMethodTypeDescription delegatedMethodTypeDescription = result;
        if (delegatedMethodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.createInvalidDelegatedMethod must not return null");
        }
        return delegatedMethodTypeDescription;
    }

    private boolean validateDelegatedProperties(@NotNull XObjectTypeDescription bpmObject, @NotNull BpmoDelegate bpmoDelegate) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.validateDelegatedProperties must not be null");
        }
        if (bpmoDelegate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.validateDelegatedProperties must not be null");
        }
        boolean result = true;
        String target = bpmObject.getProperty("target");
        String delegatedPortType = bpmoDelegate.getDelegatedPortType();
        String delegatedNamespace = bpmoDelegate.getDelegatedNamespace();
        if (target == null || delegatedPortType == null || delegatedNamespace == null) {
            result = false;
        }
        return result;
    }

    private MethodTypeDescription buildDelegatedOperation(@NotNull Operation operation, @NotNull BpmoDelegate bpmoDelegate, @NotNull String methodName, @NotNull String uniqueId, @NotNull String signature) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedOperation must not be null");
        }
        if (bpmoDelegate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedOperation must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedOperation must not be null");
        }
        if (uniqueId == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedOperation must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildDelegatedOperation must not be null");
        }
        PortTypeUUID portTypeUUID = UUIDFactory.parsePortTypeId((String)uniqueId);
        DelegatedMethodTypeDescription mtd = new DelegatedMethodTypeDescription(methodName, portTypeUUID, signature, this.getCatalog());
        try {
            for (Argument arg : bpmoDelegate.buildArguments(operation)) {
                mtd.addArgument(arg);
            }
        }
        catch (TypeBuildException e) {
            mtd = this.createInvalidDelegatedMethod(methodName, portTypeUUID, signature, ProjectCatalogMsg.INVALID_BPMO_OPERATION(methodName), e);
        }
        return mtd;
    }

    private void addDocumentation(TypeDescription td, List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            List<Documentation> documentations = annotation.findChildrenByClass(Documentation.class);
            for (Documentation documentation : documentations) {
                documentation.buildBpmoDocumentation(td);
            }
        }
    }

    private void addProperties(@NotNull BpmoBinding bpmoBinding, @NotNull XObjectTypeDescription bpmObject) {
        if (bpmoBinding == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.addProperties must not be null");
        }
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.addProperties must not be null");
        }
        Map<String, String> properties = this.getProperties(bpmoBinding);
        bpmObject.getProperties().putAll(properties);
    }

    private boolean checkArguments(@NotNull MethodTypeDescription mtd, @NotNull MethodTypeDescription originalMtd) {
        Argument[] originalArguments;
        if (mtd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.checkArguments must not be null");
        }
        if (originalMtd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.checkArguments must not be null");
        }
        Argument[] arguments = mtd.getArguments();
        if (arguments.length != (originalArguments = originalMtd.getArguments()).length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            TypeRef originalTypeRef;
            Argument argument = arguments[i];
            Argument originalArgument = originalArguments[i];
            TypeRef typeRef = argument.getTypeRef();
            if (typeRef.equals(originalTypeRef = originalArgument.getTypeRef())) continue;
            if (typeRef.getKind() == 6 && originalTypeRef.getKind() == 6) {
                int scale = typeRef.get().getScale();
                int originalScale = originalTypeRef.get().getScale();
                if (originalScale != 3 && originalScale != 4 || scale != 2) continue;
                argument.setType(originalTypeRef);
                return true;
            }
            return false;
        }
        return true;
    }

    private Map<String, String> getProperties(@NotNull WsdlElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.getProperties must not be null");
        }
        Map<String, String> result = new HashMap<String, String>();
        DefaultElement first = element.getFirstElement();
        if (first instanceof BpmoProperties) {
            BpmoProperties properties = (BpmoProperties)first;
            result = properties.getProperties();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private URI buildCompositeUri(@NotNull VFileSystem fileSystem) {
        URI uRI;
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildCompositeUri must not be null");
        }
        VFile compositeVFile = fileSystem.createFile("/composite.xml");
        try {
            uRI = compositeVFile.toURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to build composite URI");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to build composite URI");
        }
        if (uRI == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.buildCompositeUri must not return null");
        }
        return uRI;
    }

    private void checkInterfaceObjectProperty(@NotNull XObjectTypeDescription bpmObject) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectTypeLoader.checkInterfaceObjectProperty must not be null");
        }
        if (bpmObject.getProperty("service.object.id") != null && bpmObject.getProperty("interface.object") == null) {
            bpmObject.setProperty("interface.object", "service.object");
        }
    }

    @Deprecated
    private void fixHolderAttributes(XmlTypeDescription type) {
        List attributes = type.getAttributes();
        for (MethodTypeDescription mtd : attributes) {
            TypeRef id;
            AttributeTypeDescription att = mtd.asAttribute();
            TypeRef attTypeRef = att.getTypeRef();
            if (!(attTypeRef instanceof DynamicRef)) continue;
            DynamicRef dynamic = (DynamicRef)attTypeRef;
            XmlUUID xmlUUID = UUIDFactory.parseXmlId((String)dynamic.getId());
            String typeName = xmlUUID.getNativeName();
            String namespace = xmlUUID.getNamespace();
            if (!Utils.isHolderType(namespace, typeName) || (id = this.getTypeFinder().findById(ComponentType.XML.getText(), dynamic.getId())) == null) continue;
            TypeDescription td = id.get();
            ObjectTypeDescription otd = td.asObject();
            List typeAttributes = otd.getAttributes();
            assert (typeAttributes.size() == 1);
            TypeRef ref = ((MethodTypeDescription)typeAttributes.get(0)).asAttribute().getTypeRef();
            att.setType(ref);
        }
    }
}

