/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.ServiceDefinitionParsedObject;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.type.parser.BpmoDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmObjectParsedObject
extends ServiceDefinitionParsedObject {
    private URI compositeUri;

    public BpmObjectParsedObject(@NotNull URI uri, @Nullable ServiceDefinition parsedData, @Nullable URI compositeUri) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/BpmObjectParsedObject.<init> must not be null");
        }
        super(uri, parsedData);
        this.compositeUri = compositeUri;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        TreeSet<Dependency> result = new TreeSet<Dependency>();
        result.addAll(super.getDependencies());
        ServiceDefinition serviceDefinition = (ServiceDefinition)this.getParsedData();
        List<BpmoDelegate> list = serviceDefinition.findRecursiveChildrenByClass(BpmoDelegate.class);
        if (!list.isEmpty()) {
            if (this.compositeUri == null) {
                throw new IllegalStateException("Missing composite URI required for Service Objects");
            }
            result.add(new Dependency(this.compositeUri, ResourceType.COMPOSITE));
        }
        TreeSet<Dependency> treeSet = result;
        if (treeSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/BpmObjectParsedObject.getDependencies must not return null");
        }
        return treeSet;
    }
}

