/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.WebFormData;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebFormParsedObject
extends ParsedObject<WebFormData> {
    private final Set<Dependency> dependencies;
    private final WebFormData parsedData;
    private final URI resource;
    private final VFileSystem vFileSystem;

    protected WebFormParsedObject(@NotNull URI uri, @NotNull VFileSystem fileSystem) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormParsedObject.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormParsedObject.<init> must not be null");
        }
        super(uri, new WebFormData());
        this.vFileSystem = fileSystem;
        this.parsedData = (WebFormData)this.getParsedData();
        this.resource = uri;
        this.dependencies = this.parseDependencies();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        Set<Dependency> set = this.dependencies;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormParsedObject.getDependencies must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Set<Dependency> parseDependencies() throws TypeParseException {
        Set<Dependency> result;
        String path = this.resource.getPath();
        int idx = path.lastIndexOf("/");
        String formName = path.substring(idx + 1, path.length() - ".form".length());
        this.parsedData.setName(formName);
        VFile xsdFormsDir = this.vFileSystem.createFile("/forms");
        VFile[] files = this.listFiles(formName, xsdFormsDir);
        try {
            result = this.resolveDependencies(files);
        }
        catch (URISyntaxException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        catch (IOException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        catch (XPathExpressionException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        catch (SAXException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        catch (ParserConfigurationException e) {
            throw new TypeParseException(this.getUri(), e);
        }
        Set<Dependency> set = result;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormParsedObject.parseDependencies must not return null");
        }
        return set;
    }

    @Nullable
    private VFile[] listFiles(final @NotNull String formName, @NotNull VFile xsdFormsDir) {
        if (formName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormParsedObject.listFiles must not be null");
        }
        if (xsdFormsDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormParsedObject.listFiles must not be null");
        }
        return xsdFormsDir.listFiles(new VFileFilter(){

            public boolean accept(@NotNull VFile pathname) {
                String canonicalPath = pathname.getName();
                return canonicalPath.equals(formName + ".xsd") || canonicalPath.equals(formName + "_external" + ".xsd");
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Set<Dependency> resolveDependencies(@Nullable VFile[] files) throws IOException, URISyntaxException, XPathExpressionException, SAXException, ParserConfigurationException {
        Set<Dependency> result = Collections.emptySet();
        if (files != null && files.length > 0) {
            if (files.length == 1) {
                result = this.resolve(files[0]);
            } else {
                VFile externalVFile = this.getExternalVFile(files);
                if (externalVFile != null) {
                    result = this.resolveFromExternal(externalVFile);
                }
            }
        }
        Set<Dependency> set = result;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormParsedObject.resolveDependencies must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Set<Dependency> resolveFromExternal(@NotNull VFile external) throws IOException, SAXException, URISyntaxException, XPathExpressionException, ParserConfigurationException {
        if (external == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormParsedObject.resolveFromExternal must not be null");
        }
        HashSet<Dependency> result = new HashSet<Dependency>();
        Document document = this.getDocument(external);
        this.parsedData.setDependencyDom(document);
        this.parsedData.setFromScratch(false);
        NodeList nodeList = document.getElementsByTagName("import");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String schemaLocation = element.getAttribute("schemaLocation");
            result.add(new Dependency(this.vFileSystem.createFile(schemaLocation).toURL().toURI(), ResourceType.BPM_OBJECT));
        }
        HashSet<Dependency> hashSet = result;
        if (hashSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormParsedObject.resolveFromExternal must not return null");
        }
        return hashSet;
    }

    private Document getDocument(@NotNull VFile external) throws ParserConfigurationException, IOException, SAXException {
        if (external == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormParsedObject.getDocument must not be null");
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse((InputStream)new VFileInputStream(external));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Set<Dependency> resolve(@NotNull VFile file) throws IOException, URISyntaxException, SAXException, ParserConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormParsedObject.resolve must not be null");
        }
        HashSet<Dependency> result = new HashSet<Dependency>();
        this.parsedData.setDependencyDom(this.getDocument(file));
        result.add(new Dependency(file.toURL().toURI(), ResourceType.XML_SCHEMA));
        HashSet<Dependency> hashSet = result;
        if (hashSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/WebFormParsedObject.resolve must not return null");
        }
        return hashSet;
    }

    @Nullable
    private VFile getExternalVFile(@NotNull VFile[] files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/WebFormParsedObject.getExternalVFile must not be null");
        }
        for (VFile file : files) {
            if (!file.getName().contains("_external")) continue;
            return file;
        }
        return null;
    }
}

