/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.log.Log;
import oracle.rules.sdk2.dictionary.AbstractDictionaryFinder;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.rules.sdk2.exception.SDKException;
import oracle.rules.sdk2.repository.DictionaryFQN;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFileSystemDictionaryFinder
extends AbstractDictionaryFinder {
    private final VFileSystem vFileSystem;
    private static final long serialVersionUID = -7455769574529354052L;

    public VFileSystemDictionaryFinder(@Nullable DictionaryFinder parentFinder, @NotNull VFileSystem vFileSystem) {
        if (vFileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/VFileSystemDictionaryFinder.<init> must not be null");
        }
        super(parentFinder);
        this.vFileSystem = vFileSystem;
    }

    public RuleDictionary findDictionaryWithThisFinder(@NotNull DictionaryFQN fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/VFileSystemDictionaryFinder.findDictionaryWithThisFinder must not be null");
        }
        String ruleFullPath = "oracle/rules/" + fqn.asPath();
        return this.searchRuleDictionary(ruleFullPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RuleDictionary searchRuleDictionary(@NotNull String ruleLocation) {
        InputStream is;
        RuleDictionary rd;
        block7: {
            if (ruleLocation == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/VFileSystemDictionaryFinder.searchRuleDictionary must not be null");
            }
            rd = null;
            is = null;
            VFile vFile = this.vFileSystem.createFile(ruleLocation);
            try {
                if (!vFile.exists()) break block7;
                is = vFile.openInputStream();
                rd = RuleDictionary.readDictionary((Reader)new InputStreamReader(is), (DictionaryFinder)this);
            }
            catch (IOException e) {
                Log.logDebug(e);
                StreamUtils.close(is);
            }
            catch (SDKException e2) {
                Log.logDebug(e2);
                {
                    catch (Throwable throwable) {
                        StreamUtils.close(is);
                        throw throwable;
                    }
                }
                StreamUtils.close(is);
            }
        }
        StreamUtils.close(is);
        return rd;
    }
}

