/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.net.URI;
import java.util.Set;
import oracle.bpm.project.catalog.loaders.Dependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParsedObject<T> {
    private boolean buildErrors;
    private final T parsedData;
    private final URI uri;

    protected ParsedObject(@NotNull URI uri, @Nullable T parsedData) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ParsedObject.<init> must not be null");
        }
        this.parsedData = parsedData;
        this.uri = uri;
    }

    @NotNull
    public abstract Set<Dependency> getDependencies();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public T getParsedData() {
        if (this.parsedData == null) {
            throw new IllegalStateException("ParsedData is null for '" + this.uri + "', this is probably an object with errors");
        }
        T t = this.parsedData;
        if (t == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/ParsedObject.getParsedData must not return null");
        }
        return t;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public URI getUri() {
        URI uRI = this.uri;
        if (uRI == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/ParsedObject.getUri must not return null");
        }
        return uRI;
    }

    public void setBuildErrors(boolean buildErrors) {
        this.buildErrors = buildErrors;
    }

    public boolean hasBuildErrors() {
        return this.buildErrors;
    }

    public boolean isValid() {
        return this.parsedData != null;
    }

    public boolean isDummy() {
        return false;
    }
}

