/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.correlation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.catalog.bundles.ParsedObjectListener;
import oracle.bpm.project.catalog.correlation.PropertiesManager;
import oracle.bpm.project.catalog.correlation.Property;
import oracle.bpm.project.catalog.correlation.PropertyAlias;
import oracle.bpm.project.catalog.correlation.PropertyAliasImpl;
import oracle.bpm.project.catalog.correlation.PropertyAliasSetId;
import oracle.bpm.project.catalog.correlation.PropertyImpl;
import oracle.bpm.project.catalog.correlation.ResourcePropertiesManager;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.parser.bpws.PropertyAliasElement;
import oracle.bpm.project.catalog.parser.bpws.PropertyElement;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.model.Project;
import oracle.bpm.type.utils.XmlUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorrelationLowLevelModel
implements ParsedObjectListener {
    final ResourcePropertiesManager immutableProperties;
    final PropertiesManager mutableProperties;
    Project project;
    private List<CorrelationPropertiesListener> listeners;
    private String namespace;

    public CorrelationLowLevelModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.<init> must not be null");
        }
        this.mutableProperties = new PropertiesManager();
        this.immutableProperties = new ResourcePropertiesManager();
        this.project = project;
        this.listeners = new ArrayList<CorrelationPropertiesListener>();
    }

    public void addListener(CorrelationPropertiesListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CorrelationPropertiesListener listener) {
        this.listeners.remove(listener);
    }

    public String getTargetNamespace() {
        if (this.namespace == null) {
            this.namespace = "http://xmlns.oracle.com/bpmn/bpmnProcess/" + this.project.getName();
        }
        return this.namespace;
    }

    @Override
    public void add(@NotNull ResourceType type, @NotNull ParsedObject parsedObject, @NotNull URI uri, boolean reload) {
        block13: {
            Set<PropertyAlias> propsAlias;
            Set<Property> props;
            block14: {
                if (type == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.add must not be null");
                }
                if (parsedObject == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.add must not be null");
                }
                if (uri == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.add must not be null");
                }
                if (!this.isValidType(type)) break block13;
                boolean readOnly = this.isReadOnly(type);
                if (!parsedObject.isValid()) break block13;
                ServiceDefinition service = (ServiceDefinition)parsedObject.getParsedData();
                if (!readOnly) {
                    this.setTargetNamespace(service.getTargetNamespace());
                }
                props = this.createProperties(service, readOnly, service.getTargetNamespace());
                propsAlias = this.createPropertiesAlias(service, readOnly);
                if (!readOnly) break block14;
                this.immutableProperties.setProperties(uri, props);
                this.immutableProperties.setPropertyAliases(uri, propsAlias);
                if (reload) break block13;
                if (props != null) {
                    for (CorrelationPropertiesListener listener : this.listeners) {
                        listener.propertiesAdded(props);
                    }
                }
                if (propsAlias != null) {
                    for (CorrelationPropertiesListener listener : this.listeners) {
                        listener.propertyAliasesAdded(propsAlias);
                    }
                }
                break block13;
            }
            Set<Property> oldProperties = this.mutableProperties.getProperties();
            Set<PropertyAlias> oldPropertyAlias = this.mutableProperties.getPropertyAliases();
            Set<Property> propRemoved = this.diffProperties(oldProperties, props);
            Set<Property> propAdded = this.diffProperties(props, oldProperties);
            Set<PropertyAlias> propAliasRemoved = this.diffPropertyAlias(propsAlias, oldPropertyAlias);
            Set<PropertyAlias> propAliasAdded = this.diffPropertyAlias(oldPropertyAlias, propsAlias);
            this.mutableProperties.clear();
            this.mutableProperties.setProperties(props);
            this.mutableProperties.setPropertyAliases(propsAlias);
            if (!reload) {
                if (!propRemoved.isEmpty()) {
                    for (CorrelationPropertiesListener listener : this.listeners) {
                        listener.propertiesRemoved(propRemoved);
                        listener.propertyAliasesRemoved(propAliasRemoved);
                    }
                }
                if (!propAdded.isEmpty()) {
                    for (CorrelationPropertiesListener listener : this.listeners) {
                        listener.propertiesAdded(propAdded);
                        listener.propertyAliasesAdded(propAliasAdded);
                    }
                }
            }
        }
    }

    @Override
    public void remove(@NotNull ResourceType type, @NotNull URI uri) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.remove must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.remove must not be null");
        }
        if (this.isValidType(type) && type == ResourceType.WSDL) {
            Collection<Property> properties = this.immutableProperties.getPropertiesByUri(uri);
            Collection<PropertyAlias> propertyAliases = this.immutableProperties.getPropertyAliasesByUri(uri);
            for (CorrelationPropertiesListener listener : this.listeners) {
                listener.propertiesRemoved(properties);
                listener.propertyAliasesRemoved(propertyAliases);
            }
            this.immutableProperties.remove(uri);
        }
    }

    @Override
    public void clear() {
        this.immutableProperties.clear();
        this.mutableProperties.clear();
        for (CorrelationPropertiesListener listener : this.listeners) {
            listener.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<Property> getAllProperties() {
        ArrayList<Property> result = new ArrayList<Property>();
        result.addAll(this.immutableProperties.getProperties());
        result.addAll(this.mutableProperties.getProperties());
        ArrayList<Property> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.getAllProperties must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<Property> getProperties() {
        ArrayList<Property> result = new ArrayList<Property>();
        result.addAll(this.mutableProperties.getProperties());
        ArrayList<Property> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.getProperties must not return null");
        }
        return arrayList;
    }

    @Nullable
    public Property findProperty(@NotNull QName name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.findProperty must not be null");
        }
        Property property = this.mutableProperties.findProperty(name);
        if (property == null) {
            property = this.immutableProperties.findProperty(name);
        }
        return property;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<PropertyAlias> getPropertyAliases() {
        ArrayList<PropertyAlias> result = new ArrayList<PropertyAlias>();
        result.addAll(this.mutableProperties.getPropertyAliases());
        ArrayList<PropertyAlias> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.getPropertyAliases must not return null");
        }
        return arrayList;
    }

    public void setProperty(Property property) {
        this.mutableProperties.addProperty(property);
        for (CorrelationPropertiesListener listener : this.listeners) {
            Sequence<Property> seq = CollectionUtils.singletonSequence(property);
            listener.propertiesAdded(CollectionUtils.toList(seq));
        }
    }

    public void setPropertyAlias(PropertyAlias propertyAlias) {
        this.mutableProperties.addPropertyAlias(propertyAlias);
    }

    public void removeProperty(String propertyId) {
        Property property = this.mutableProperties.removeProperty(propertyId);
        for (CorrelationPropertiesListener listener : this.listeners) {
            Sequence<Property> seq = CollectionUtils.singletonSequence(property);
            listener.propertiesRemoved(CollectionUtils.toList(seq));
        }
    }

    public List<PropertyAlias> findPropertyAliases(@NotNull QName property) {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.findPropertyAliases must not be null");
        }
        ArrayList<PropertyAlias> result = new ArrayList<PropertyAlias>();
        List<PropertyAlias> propertyAliases = this.immutableProperties.getPropertyAliases();
        propertyAliases.addAll(this.mutableProperties.getPropertyAliases());
        for (PropertyAlias propertyAlias : propertyAliases) {
            if (!property.equals(propertyAlias.getProperty())) continue;
            result.add(propertyAlias);
        }
        return result;
    }

    public PropertyAlias findPropertyAlias(@NotNull QName property, @NotNull PropertyAliasSetId id) {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.findPropertyAlias must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.findPropertyAlias must not be null");
        }
        PropertyAlias result = null;
        for (PropertyAlias pro : this.findPropertyAliases(property)) {
            QName propertyAliasQName;
            if (XmlElementType.ELEMENT == id.getElementType()) {
                propertyAliasQName = pro.getElement();
                if (propertyAliasQName == null || !propertyAliasQName.equals(id.getQname())) continue;
                result = pro;
                break;
            }
            if (XmlElementType.MESSAGE != id.getElementType()) continue;
            propertyAliasQName = pro.getMessageType();
            String partName = pro.getPart();
            if (propertyAliasQName == null || !propertyAliasQName.equals(id.getQname()) || !Any.equals(partName, id.getPart())) continue;
            result = pro;
            break;
        }
        return result;
    }

    public void removePropertyAlias(QName propertyName, PropertyAliasSetId id) {
        PropertyAlias oldPropertyAlias = this.findPropertyAlias(propertyName, id);
        this.mutableProperties.removePropertyAlias(oldPropertyAlias);
    }

    private void setTargetNamespace(String namespace) {
        if (this.namespace == null) {
            this.namespace = namespace;
        }
    }

    private Set<PropertyAlias> diffPropertyAlias(Set<PropertyAlias> propsAlias, Set<PropertyAlias> oldPropertyAlias) {
        HashSet<PropertyAlias> propAliasRemoved = new HashSet<PropertyAlias>();
        for (PropertyAlias prop : oldPropertyAlias) {
            if (propsAlias.contains(prop)) continue;
            propAliasRemoved.add(prop);
        }
        return propAliasRemoved;
    }

    private Set<Property> diffProperties(Set<Property> props, Set<Property> oldProperties) {
        HashSet<Property> propAdded = new HashSet<Property>();
        for (Property prop : props) {
            if (oldProperties.contains(prop)) continue;
            propAdded.add(prop);
        }
        return propAdded;
    }

    private Set<Property> createProperties(@NotNull ServiceDefinition service, boolean readOnly, String propertyNamespace) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.createProperties must not be null");
        }
        HashSet<Property> result = new HashSet<Property>();
        List<PropertyElement> properties = service.findChildrenByClass(PropertyElement.class);
        if (properties != null && !properties.isEmpty()) {
            for (PropertyElement prop : properties) {
                String name = prop.getPropertyName();
                String type = prop.getPropertyType();
                String typeNamespace = this.findNamespace(prop, type);
                if (name == null || type == null) continue;
                result.add(new PropertyImpl(readOnly, new QName(propertyNamespace, name), new QName(typeNamespace, XmlUtils.localname((String)type))));
            }
        }
        return result;
    }

    private Set<PropertyAlias> createPropertiesAlias(@NotNull ServiceDefinition service, boolean isReadOnly) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.createPropertiesAlias must not be null");
        }
        HashSet<PropertyAlias> result = new HashSet<PropertyAlias>();
        List<PropertyAliasElement> propertyAliasElements = service.findChildrenByClass(PropertyAliasElement.class);
        if (!propertyAliasElements.isEmpty()) {
            for (PropertyAliasElement elem : propertyAliasElements) {
                PropertyAliasImpl propertyAlias = null;
                String propertyName = elem.getPropertyName();
                if (Str.isEmpty(propertyName)) continue;
                String propertyNameNS = this.findNamespace(elem, propertyName);
                QName propertyQName = new QName(propertyNameNS, XmlUtils.localname((String)propertyName));
                String messageType = elem.getMessageType();
                if (!Str.isEmpty(messageType)) {
                    String messageTypeNS = this.findNamespace(elem, messageType);
                    QName msgQName = new QName(messageTypeNS, XmlUtils.localname((String)messageType));
                    String part = elem.getPart();
                    if (part != null) {
                        propertyAlias = new PropertyAliasImpl(isReadOnly, propertyQName, msgQName, part);
                    }
                } else {
                    String element = elem.getElement();
                    if (!Str.isEmpty(element)) {
                        String elementNS = this.findNamespace(elem, element);
                        QName elemQName = new QName(elementNS, XmlUtils.localname((String)element));
                        propertyAlias = new PropertyAliasImpl(isReadOnly, propertyQName, elemQName);
                    }
                }
                if (propertyAlias == null) continue;
                Map<String, URI> namespaces = this.findNamespaces(elem);
                propertyAlias.setExpression(elem.getQuery(), namespaces);
                result.add(propertyAlias);
            }
        }
        return result;
    }

    private Map<String, URI> findNamespaces(PropertyAliasElement elem) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(elem.getNSContext().getAllPrefixToUriMap());
        map.putAll(elem.getQueryNSContext());
        HashMap<String, URI> namespaces = new HashMap<String, URI>();
        for (Map.Entry entry : map.entrySet()) {
            try {
                namespaces.put((String)entry.getKey(), new URI((String)entry.getValue()));
            }
            catch (URISyntaxException ignore) {}
        }
        return namespaces;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String findNamespace(WsdlElement elem, String name) {
        Namespace namespace;
        String result = "";
        Context context = elem.getContext();
        if (context != null && (namespace = context.findNamespace(XmlUtils.prefix((String)name))) != null) {
            result = namespace.getUri();
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.findNamespace must not return null");
        }
        return string;
    }

    private boolean isReadOnly(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/correlation/CorrelationLowLevelModel.isReadOnly must not be null");
        }
        return type == ResourceType.WSDL;
    }

    private boolean isValidType(ResourceType type) {
        return type == ResourceType.WSDL || type == ResourceType.PROJECT_WSLD;
    }

    public static interface CorrelationPropertiesListener {
        public void propertiesRemoved(Collection<Property> var1);

        public void propertyAliasesRemoved(Collection<PropertyAlias> var1);

        public void propertiesAdded(Collection<Property> var1);

        public void propertyAliasesAdded(Collection<PropertyAlias> var1);

        public void clear();
    }
}

