/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite.jaxb;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bpm.lang.Str;
import oracle.bpm.xml.XmlWriter;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlWriterContentHandler
implements ContentHandler {
    private Map<String, String> prefixMappings;
    private XmlWriter writer;
    private boolean writeWellKnownNamespaces = true;
    static final Map<String, String> WELL_KNOWN_NAMESPACES;

    public XmlWriterContentHandler(XmlWriter writer) {
        this.writer = writer;
        this.prefixMappings = new HashMap<String, String>();
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.writer.startDocument();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if ("".equals(prefix)) {
            return;
        }
        String predefinedPrefix = WELL_KNOWN_NAMESPACES.get(uri);
        if (prefix != null && predefinedPrefix == null) {
            this.prefixMappings.put(uri, prefix);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String tagName = this.makePrefixName(uri, localName);
        try {
            this.writer.startElement(tagName);
            if (this.writeWellKnownNamespaces) {
                this.writeWellKnownNamespaces = false;
                this.prefixMappings.putAll(WELL_KNOWN_NAMESPACES);
            }
            this.writeNamespaces(this.prefixMappings);
            this.prefixMappings.clear();
            for (int i = 0; i < atts.getLength(); ++i) {
                this.writer.printAttribute(this.makePrefixName(atts.getURI(i), atts.getLocalName(i)), atts.getValue(i));
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.writer.endElement();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.printChars(String.valueOf(ch, start, length));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.printChars(String.valueOf(ch, start, length));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        throw new UnsupportedOperationException("processingInstruction while marshalling");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        throw new UnsupportedOperationException("skippedEntity while marshalling");
    }

    private void writeNamespaces(@NotNull Map<String, String> prefixMappings) throws IOException {
        if (prefixMappings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/jaxb/XmlWriterContentHandler.writeNamespaces must not be null");
        }
        for (Map.Entry<String, String> entry : prefixMappings.entrySet()) {
            String prefix = entry.getValue();
            this.writer.printAttribute(prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, entry.getKey());
        }
    }

    private String makePrefixName(String uri, String localName) throws SAXException {
        if (Str.isEmpty(uri)) {
            return localName;
        }
        String prefix = WELL_KNOWN_NAMESPACES.get(uri);
        if (prefix == null && (prefix = this.prefixMappings.get(uri)) == null) {
            throw new SAXException("Unexpected namespace: " + uri);
        }
        return prefix.length() == 0 ? localName : prefix + ":" + localName;
    }

    static {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("http://xmlns.oracle.com/sca/1.0", "");
        map.put("http://www.w3.org/2001/XMLSchema", "xs");
        map.put("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
        map.put("http://schemas.oracle.com/ws/2006/01/policy", "orawsp");
        map.put("http://xmlns.oracle.com/soa/designer/", "ui");
        WELL_KNOWN_NAMESPACES = Collections.unmodifiableMap(map);
    }
}

