/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.util.HashSet;
import java.util.Set;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class ScaControllerContext {
    private Set<Process> processesToKeep = new HashSet<Process>();
    private static ScaControllerContext instance = null;

    private ScaControllerContext() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ScaControllerContext getInstance() {
        if (instance == null) {
            instance = new ScaControllerContext();
        }
        ScaControllerContext scaControllerContext = instance;
        if (scaControllerContext == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/ScaControllerContext.getInstance must not return null");
        }
        return scaControllerContext;
    }

    public void addProcessToKeep(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaControllerContext.addProcessToKeep must not be null");
        }
        this.processesToKeep.add(process);
    }

    public void removeProcessToKeep(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaControllerContext.removeProcessToKeep must not be null");
        }
        this.processesToKeep.remove(process);
    }

    public boolean isDeleteAction(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ScaControllerContext.isDeleteAction must not be null");
        }
        return !this.processesToKeep.contains(process);
    }
}

