/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeImport;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.ElementContainer;
import oracle.bpm.project.catalog.composite.JaxbComponentTypeAccessor;
import oracle.bpm.project.catalog.composite.jaxb.Component;
import oracle.bpm.project.catalog.composite.jaxb.Composite;
import oracle.bpm.project.catalog.composite.jaxb.Import;
import oracle.bpm.project.catalog.composite.jaxb.Reference;
import oracle.bpm.project.catalog.composite.jaxb.Service;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import org.jetbrains.annotations.NotNull;

public abstract class JaxbAbstractCompositeAccessor
extends CompositeAccessor {
    @NotNull
    private final JaxbComponentTypeAccessor componentTypeAccessor;
    private Composite jaxbModel;
    private static final String EMPTY = "";

    public JaxbAbstractCompositeAccessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.<init> must not be null");
        }
        super(project);
        ProjectLoader loader = project.getLoader();
        assert (loader != null);
        this.componentTypeAccessor = new JaxbComponentTypeAccessor(loader.getProjectFileSystem().getDataFileSystem());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CompositeInfo parseComposite() throws CompositeAccessorException {
        this.loadComposite();
        Iterable<CompositeImport> compositeImports = this.getCompositeImports();
        CompositeInfo compositeInfo = new CompositeInfo(this.getCompositeReferences(compositeImports), this.getCompositeServices(compositeImports), this.loadCompositeComponents(compositeImports), compositeImports);
        if (compositeInfo == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.parseComposite must not return null");
        }
        return compositeInfo;
    }

    @Override
    public void reload() {
        this.componentTypeAccessor.clear();
    }

    protected abstract void loadComposite() throws CompositeAccessorException;

    protected void setJaxbModel(Composite jaxbModel) {
        this.jaxbModel = jaxbModel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeComponent> loadCompositeComponents(@NotNull Iterable<CompositeImport> compositeImports) throws CompositeAccessorException {
        List<Component> components;
        if (compositeImports == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.loadCompositeComponents must not be null");
        }
        ArrayList<CompositeComponent> result = new ArrayList<CompositeComponent>();
        if (this.jaxbModel != null && (components = this.jaxbModel.getComponent()) != null) {
            for (Component component : components) {
                result.add(this.createComponent(component, compositeImports));
            }
        }
        ArrayList<CompositeComponent> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.loadCompositeComponents must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeInterface> getCompositeReferences(final @NotNull Iterable<CompositeImport> compositeImports) {
        if (compositeImports == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.getCompositeReferences must not be null");
        }
        Iterable<CompositeInterface> result = this.jaxbModel != null ? this.nonNullIterable(this.jaxbModel.getReference(), new Function<Reference, CompositeInterface>(){

            @Override
            public CompositeInterface eval(Reference reference) {
                return CompositeAccessor.createInterface(new ElementContainer(JaxbAbstractCompositeAccessor.this.getVFileSystemProject(), reference, (Iterable<CompositeImport>)compositeImports), reference.getName(), null, CatalogInterfaceType.SERVICE, null);
            }
        }) : CollectionUtils.emptyIterable();
        Iterable<CompositeInterface> iterable = result;
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.getCompositeReferences must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeInterface> getCompositeServices(final @NotNull Iterable<CompositeImport> compositeImports) {
        if (compositeImports == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.getCompositeServices must not be null");
        }
        Iterable<CompositeInterface> result = this.jaxbModel != null ? this.nonNullIterable(this.jaxbModel.getService(), new Function<Service, CompositeInterface>(){

            @Override
            public CompositeInterface eval(Service service) {
                return CompositeAccessor.createInterface(new ElementContainer(JaxbAbstractCompositeAccessor.this.getVFileSystemProject(), service, (Iterable<CompositeImport>)compositeImports), service.getName(), null, CatalogInterfaceType.REFERENCE, null);
            }
        }) : CollectionUtils.emptyIterable();
        Iterable<CompositeInterface> iterable = result;
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.getCompositeServices must not return null");
        }
        return iterable;
    }

    private Iterable<CompositeImport> getCompositeImports() {
        Iterable<CompositeImport> result = this.jaxbModel != null ? this.nonNullIterable(this.jaxbModel.getImport(), new Function<Import, CompositeImport>(){

            @Override
            public CompositeImport eval(Import value) {
                String namespace = Str.null2empty(value.getNamespace());
                String location = Str.null2empty(value.getLocation());
                return new CompositeImport(namespace, location, value.getImportType());
            }
        }) : CollectionUtils.emptyIterable();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private CompositeComponent createComponent(@NotNull Component component, @NotNull Iterable<CompositeImport> compositeImports) throws CompositeAccessorException {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.createComponent must not be null");
        }
        if (compositeImports == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.createComponent must not be null");
        }
        CompositeComponent compositeComponent = this.componentTypeAccessor.getCompositeComponent(component, compositeImports);
        if (compositeComponent == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/JaxbAbstractCompositeAccessor.createComponent must not return null");
        }
        return compositeComponent;
    }
}

