/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.common.SpringComponentUtils;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeImport;
import oracle.bpm.project.catalog.composite.jaxb.Interface;
import oracle.bpm.project.catalog.composite.jaxb.JavaInterface;
import oracle.bpm.project.catalog.composite.jaxb.Reference;
import oracle.bpm.project.catalog.composite.jaxb.Service;
import oracle.bpm.project.catalog.composite.jaxb.WSDLInterface;
import oracle.bpm.project.model.CompositeServiceType;
import org.jetbrains.annotations.NotNull;

public class ElementContainer
implements CompositeAccessor.CompositeObjectContainer {
    private Iterable<CompositeImport> compositeImports;
    private Reference reference;
    private Service service;
    private VFileSystem vfileSystem;
    private static final String COMPOSITE_XML_PATH = "/composite.xml";
    private static final String WSDL_INTERFACE = "#wsdl.interface";
    private static final String HUMAN_TASK_INTERFACE_ID = "(TaskService)";
    private static final String BUSINESS_RULE_INTERFACE_ID = "(IDecisionService)";

    ElementContainer(@NotNull VFileSystem vfileSystem, @NotNull Reference reference, @NotNull Iterable<CompositeImport> compositeImports) {
        if (vfileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ElementContainer.<init> must not be null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/ElementContainer.<init> must not be null");
        }
        if (compositeImports == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/composite/ElementContainer.<init> must not be null");
        }
        this(vfileSystem, compositeImports);
        this.reference = reference;
    }

    ElementContainer(@NotNull VFileSystem vfileSystem, @NotNull Service service, @NotNull Iterable<CompositeImport> compositeImports) {
        if (vfileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ElementContainer.<init> must not be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/ElementContainer.<init> must not be null");
        }
        if (compositeImports == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/composite/ElementContainer.<init> must not be null");
        }
        this(vfileSystem, compositeImports);
        this.service = service;
    }

    private ElementContainer(@NotNull VFileSystem vfileSystem, @NotNull Iterable<CompositeImport> compositeImports) {
        if (vfileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/ElementContainer.<init> must not be null");
        }
        if (compositeImports == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/ElementContainer.<init> must not be null");
        }
        this.reference = null;
        this.service = null;
        this.vfileSystem = null;
        this.vfileSystem = vfileSystem;
        this.compositeImports = compositeImports;
    }

    @Override
    public VFileSystem getVFileSystem() {
        return this.vfileSystem;
    }

    @Override
    public String getName() {
        return this.service != null ? this.service.getName() : this.reference.getName();
    }

    @Override
    public QName getInterfaceQName() {
        QName result;
        JAXBElement<? extends Interface> interfaceElement = this.getInterface();
        Interface value = (Interface)interfaceElement.getValue();
        if (value instanceof WSDLInterface) {
            WSDLInterface wsdlInterface = (WSDLInterface)value;
            String wsdlInterfaceValue = wsdlInterface.getInterface();
            result = this.getInterfaceQname(wsdlInterfaceValue);
        } else if (value instanceof JavaInterface) {
            JavaInterface javaInterface = (JavaInterface)value;
            result = SpringComponentUtils.buildQName(javaInterface.getInterface());
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public QName getCallbankInterfaceQName() {
        JAXBElement<? extends Interface> interfaceElement = this.getInterface();
        Interface value = (Interface)interfaceElement.getValue();
        QName result = null;
        if (value instanceof WSDLInterface) {
            WSDLInterface wsdlInterface = (WSDLInterface)value;
            String wsdlInterfaceValue = wsdlInterface.getCallbackInterface();
            if (wsdlInterfaceValue != null) {
                result = this.getInterfaceQname(wsdlInterfaceValue);
            }
        } else if (value instanceof JavaInterface) {
            JavaInterface javaInterface = (JavaInterface)value;
            result = SpringComponentUtils.buildQName(javaInterface.getCallbackInterface());
        }
        return result;
    }

    @Override
    public List<URI> getWsdl() {
        List<String> locations = this.getLocation();
        ArrayList<URI> result = new ArrayList<URI>();
        for (String location : locations) {
            Interface value;
            if (location == null && (value = (Interface)this.getInterface().getValue()) instanceof JavaInterface) {
                JavaInterface javaInterface = (JavaInterface)value;
                location = SpringComponentUtils.buildWsdlFileName(javaInterface.getInterface());
            }
            if (location == null) continue;
            try {
                URI uri = new URI(location);
                if (!uri.isAbsolute()) {
                    result.add(this.vfileSystem.createFile(COMPOSITE_XML_PATH).toURL().toURI().resolve(location));
                    continue;
                }
                result.add(uri);
            }
            catch (URISyntaxException e) {
                result = null;
            }
            catch (IOException e) {
                result = null;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CompositeServiceType getInterfaceType() {
        WSDLInterface wsdlInterface;
        String value;
        CompositeServiceType result = CompositeServiceType.WEB_SERVICE;
        JAXBElement<? extends Interface> interfaceElement = this.getInterface();
        Interface scaInterface = (Interface)interfaceElement.getValue();
        if (scaInterface != null && scaInterface instanceof WSDLInterface && (value = (wsdlInterface = (WSDLInterface)scaInterface).getInterface()) != null) {
            if (value.contains(HUMAN_TASK_INTERFACE_ID)) {
                result = CompositeServiceType.HUMAN_TASK;
            } else if (value.contains(BUSINESS_RULE_INTERFACE_ID)) {
                result = CompositeServiceType.BUSINESS_RULE;
            }
        }
        CompositeServiceType compositeServiceType = result;
        if (compositeServiceType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/ElementContainer.getInterfaceType must not return null");
        }
        return compositeServiceType;
    }

    private List<String> getLocation() {
        ArrayList<String> ret = new ArrayList<String>();
        String namespace = this.getInterfaceQName().getNamespaceURI();
        for (CompositeImport anImport : this.compositeImports) {
            if (!anImport.getNamespace().equals(namespace)) continue;
            ret.add(anImport.getLocation());
        }
        return ret;
    }

    private JAXBElement<? extends Interface> getInterface() {
        return this.service != null ? this.service.getInterface() : this.reference.getInterface();
    }

    private QName getInterfaceQname(String wsdlInterfaceValue) {
        int index = wsdlInterfaceValue.indexOf(WSDL_INTERFACE);
        String namespace = wsdlInterfaceValue.substring(0, index);
        String portName = wsdlInterfaceValue.substring(index + WSDL_INTERFACE.length() + 1, wsdlInterfaceValue.length() - 1);
        return new QName(namespace, portName);
    }
}

