/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.protocol.VFileURLConnection;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.common.Resource;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.interfaces.ConversationHelper;
import oracle.bpm.project.model.CompositeServiceType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.type.MutableTypeIndex;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final String DOT_HOLDER = ".Holder";

    private Utils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getTypeName(@NotNull VFile vfile, @NotNull String startPath) {
        if (vfile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.getTypeName must not be null");
        }
        if (startPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.getTypeName must not be null");
        }
        String canonicalPath = vfile.getCanonicalPath();
        String string = Utils.getTypeName(canonicalPath, startPath);
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/Utils.getTypeName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getTypeName(@NotNull String cannonicalPath, @NotNull String startPath) {
        if (cannonicalPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.getTypeName must not be null");
        }
        if (startPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.getTypeName must not be null");
        }
        String[] paths = Str.split(Utils.excludeExtension(cannonicalPath), '/', false);
        String typeName = null;
        for (int i = 1; i < paths.length; ++i) {
            String path = paths[i];
            if (i == 1 && path.equals(startPath)) continue;
            String name = Identifier.classname(path);
            typeName = typeName == null ? name : typeName + "." + name;
        }
        assert (typeName != null);
        String string = typeName;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/Utils.getTypeName must not return null");
        }
        return string;
    }

    public static boolean isBpmObjectNamespace(@NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isBpmObjectNamespace must not be null");
        }
        return namespace.startsWith("http://xmlns.oracle.com/bpm/bpmobject/");
    }

    public static List<Resource> tsort(@NotNull Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.tsort must not be null");
        }
        ArrayList<Resource> sortedList = new ArrayList<Resource>();
        IdentitySet<Resource> visited = new IdentitySet<Resource>();
        Utils.sortDependencies(resource, sortedList, visited);
        if (!visited.contains(resource)) {
            sortedList.add(resource);
        }
        return sortedList;
    }

    public static boolean isHolderType(@NotNull String namespace, @NotNull String typeName) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isHolderType must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isHolderType must not be null");
        }
        return Utils.isBpmObjectNamespace(namespace) && typeName.endsWith(DOT_HOLDER);
    }

    public static String excludeExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.excludeExtension must not be null");
        }
        int index = fileName.indexOf(".");
        String result = fileName;
        if (index > 0) {
            result = fileName.substring(0, index);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VFile vFileUrlToVFile(@NotNull URL location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.vFileUrlToVFile must not be null");
        }
        VFile result = VFileURLConnection.get((URL)location);
        assert (result != null) : "Could not load result resource:" + location;
        VFile vFile = result;
        if (vFile == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/common/Utils.vFileUrlToVFile must not return null");
        }
        return vFile;
    }

    public static boolean deepCompareXmlTypes(@NotNull XmlTypeDescription source, @NotNull XmlTypeDescription target, boolean ignoreConstructors) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.deepCompareXmlTypes must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.deepCompareXmlTypes must not be null");
        }
        return source.equals((Object)target) && TypeUtils.compareObjectMembers((ObjectTypeDescription)source, (ObjectTypeDescription)target, (boolean)ignoreConstructors);
    }

    public static String buildFreeName(@NotNull Set<String> existingNames, @NotNull String typeName) {
        if (existingNames == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.buildFreeName must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.buildFreeName must not be null");
        }
        String result = typeName;
        int i = 1;
        while (existingNames.contains(result)) {
            result = typeName + i;
            ++i;
        }
        return result;
    }

    public static String buildFreeName(@NotNull MutableTypeIndex typeIndex, @NotNull String typeName) {
        if (typeIndex == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.buildFreeName must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.buildFreeName must not be null");
        }
        String result = typeName;
        int i = 1;
        while (typeIndex.findExact(result) != null) {
            result = typeName + i;
            ++i;
        }
        return result;
    }

    public static void fixResourceLocation(@NotNull URL location, String relativePath, @NotNull TypeDescription type) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.fixResourceLocation must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.fixResourceLocation must not be null");
        }
        if (type instanceof ObjectTypeDescription) {
            ObjectTypeDescription otd = (ObjectTypeDescription)type;
            if ("vfile".equals(location.getProtocol())) {
                VFile vFile = Utils.vFileUrlToVFile(location);
                otd.setTransientProperty("resource_location", (Object)relativePath);
                otd.setTransientProperty("files", (Object)new VFile[]{vFile});
            } else {
                otd.setTransientProperty("resource_location", (Object)location.toString());
            }
            for (TypeRef typeRef : otd.getInnerTypeRefs()) {
                Utils.fixResourceLocation(location, relativePath, typeRef.get());
            }
        }
    }

    public static boolean hasServiceInterfaceDefined(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.hasServiceInterfaceDefined must not be null");
        }
        Sequence<Conversation> select = ConversationHelper.getAllConversationsFrom(process).select(new Predicate<Conversation>(){

            @Override
            public boolean check(@Nullable Conversation conversation) {
                return conversation != null && conversation.getConversationType() == ConversationType.DEFINE_INTERFACE;
            }
        });
        return !select.isEmpty();
    }

    public static boolean shouldPromoteService(CompositeInterface compositeInterface, CatalogInterfaceType interfaceType, Iterable<CompositeComponent> components) {
        CompositeServiceType componentType = compositeInterface.getComponentType();
        if (CompositeServiceType.WEB_SERVICE.equals(componentType)) {
            return true;
        }
        boolean promote = true;
        if (CompositeServiceType.BUSINESS_RULE.equals(componentType)) {
            if (interfaceType.equals((Object)CatalogInterfaceType.REFERENCE)) {
                for (CompositeComponent component : components) {
                    if (!Utils.containsInterfaceService(component, compositeInterface.getService())) continue;
                    promote = false;
                    break;
                }
            }
        } else {
            promote = false;
        }
        return promote;
    }

    public static boolean isValidNCName(@Nullable String name) {
        boolean result = false;
        if (name != null && name.length() > 0 && ':' != name.charAt(0) && Utils.isNameStartChar(Character.valueOf(name.charAt(0)))) {
            int index;
            int length = name.length();
            for (index = 1; index < length && ':' != name.charAt(index) && Utils.isNameChar(Character.valueOf(name.charAt(index))); ++index) {
            }
            result = length == index;
        }
        return result;
    }

    private static boolean isNameChar(@NotNull Character c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isNameChar must not be null");
        }
        return Utils.isNameStartChar(c) || Character.isDigit(c.charValue()) || '-' == c.charValue() || '.' == c.charValue() || '\u00b7' == c.charValue() || c.charValue() >= '\u0300' && c.charValue() <= '\u036f' || c.charValue() >= '\u203f' && c.charValue() <= '\u2040';
    }

    private static boolean isNameStartChar(@NotNull Character c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Utils.isNameStartChar must not be null");
        }
        return Character.isLetter(c.charValue()) || '_' == c.charValue() || ':' == c.charValue() || c.charValue() >= '\u00c0' && c.charValue() <= '\u00d6' || c.charValue() >= '\u00d8' && c.charValue() <= '\u00f6' || c.charValue() >= '\u00f8' && c.charValue() <= '\u02ff' || c.charValue() >= '\u0370' && c.charValue() <= '\u037d' || c.charValue() >= '\u037f' && c.charValue() <= '\u1fff' || c.charValue() >= '\u200c' && c.charValue() <= '\u200d' || c.charValue() >= '\u2070' && c.charValue() <= '\u218f' || c.charValue() >= '\u2c00' && c.charValue() <= '\u2fef' || c.charValue() >= '\u3001' && c.charValue() <= '\ud7ff' || c.charValue() >= '\uf900' && c.charValue() <= '\ufdcf' || c.charValue() >= '\ufdf0' && c.charValue() <= '\ufffd' || c.charValue() >= '\u10000' && c.charValue() <= '\ueffff';
    }

    private static boolean containsInterfaceService(CompositeComponent component, QName compositeInterfaceService) {
        boolean exists = false;
        for (CompositeInterface service : component.getServices()) {
            if (!service.getService().equals(compositeInterfaceService)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private static void sortDependencies(Resource resource, List<Resource> sortedList, IdentitySet<Resource> visited) {
        Set<Resource> dependencies = resource.getDependencies();
        for (Resource dependency : dependencies) {
            if (visited.contains(dependency)) continue;
            visited.add(dependency);
            Utils.sortDependencies(dependency, sortedList, visited);
            sortedList.add(dependency);
        }
    }

    static class IdentitySet<T> {
        IdentityHashMap<T, T> map = new IdentityHashMap();

        IdentitySet() {
        }

        public boolean contains(T target) {
            return this.map.containsKey(target);
        }

        public void add(T target) {
            this.map.put(target, target);
        }
    }
}

