/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.common;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.project.catalog.common.AssociatedType;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import org.jetbrains.annotations.NotNull;

public class Resource {
    private Set<AssociatedType> associatedTypes;
    private boolean deleted;
    private Set<Resource> dependants;
    private Set<Resource> dependencies;
    private boolean external;
    private final boolean isStructuralDependant;
    private Date lastLoadTime;
    private boolean parsed;
    private final URI resourceLocation;
    private final ResourceType resourceType;
    private boolean typeBuilt;

    public Resource(@NotNull ResourceType resourceType, @NotNull URI resourceLocation, boolean isStructuralDependant) {
        if (resourceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.<init> must not be null");
        }
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.<init> must not be null");
        }
        this(resourceType, resourceLocation, isStructuralDependant, false);
    }

    public Resource(@NotNull ResourceType resourceType, @NotNull URI resourceLocation, boolean isStructuralDependant, boolean external) {
        if (resourceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.<init> must not be null");
        }
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.<init> must not be null");
        }
        this.resourceType = resourceType;
        this.resourceLocation = resourceLocation;
        this.dependencies = new HashSet<Resource>();
        this.dependants = new HashSet<Resource>();
        this.associatedTypes = new HashSet<AssociatedType>();
        this.external = external;
        this.deleted = false;
        this.isStructuralDependant = isStructuralDependant;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
        this.lastLoadTime = new Date();
    }

    public boolean isTypeBuilt() {
        return this.typeBuilt;
    }

    public void addAssociatedType(@NotNull AssociatedType associatedType) {
        if (associatedType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.addAssociatedType must not be null");
        }
        if (!this.associatedTypes.contains(associatedType)) {
            this.associatedTypes.add(associatedType);
            associatedType.addAssociatedResource(this);
        }
    }

    public void removeAssociatedType(@NotNull AssociatedType associatedType) {
        if (associatedType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.removeAssociatedType must not be null");
        }
        if (this.associatedTypes.contains(associatedType)) {
            this.associatedTypes.remove(associatedType);
            associatedType.removeAssociatedResource(this);
        }
    }

    public void setTypeBuilt(boolean typeBuilt) {
        this.typeBuilt = typeBuilt;
    }

    public URI getResourceLocation() {
        return this.resourceLocation;
    }

    public Set<Resource> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public Set<Resource> getDependants() {
        return Collections.unmodifiableSet(this.dependants);
    }

    public Set<AssociatedType> getAssociatedTypes() {
        return this.associatedTypes;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public Date getLastLoadTime() {
        return this.lastLoadTime;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
        if (deleted) {
            this.associatedTypes.clear();
            this.typeBuilt = false;
            this.parsed = false;
        }
    }

    public void clearAssociatedTypes() {
        this.associatedTypes.clear();
    }

    public void addDependency(@NotNull Resource dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.addDependency must not be null");
        }
        if (!this.getDependencies().contains(dependency)) {
            this.dependencies.add(dependency);
            dependency.addDependant(this);
        }
    }

    public void addDependant(@NotNull Resource dependant) {
        if (dependant == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.addDependant must not be null");
        }
        if (!this.getDependants().contains(dependant)) {
            this.dependants.add(dependant);
            dependant.addDependency(this);
        }
    }

    public void removeDependency(@NotNull Resource dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.removeDependency must not be null");
        }
        if (this.getDependencies().contains(dependency)) {
            this.dependencies.remove(dependency);
            dependency.removeDependant(this);
        }
    }

    public void removeDependant(@NotNull Resource dependant) {
        if (dependant == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/common/Resource.removeDependant must not be null");
        }
        if (this.getDependants().contains(dependant)) {
            this.dependants.remove(dependant);
            dependant.removeDependency(this);
        }
    }

    public boolean isStructuralDependant() {
        return this.isStructuralDependant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        if (!this.resourceLocation.equals(resource.resourceLocation)) {
            return false;
        }
        return this.resourceType == resource.resourceType;
    }

    public int hashCode() {
        int result = this.resourceLocation.hashCode();
        result = 31 * result + this.resourceType.hashCode();
        return result;
    }

    public void clearDependencies() {
        Collection<Resource> dependenciesCopy = CollectionUtils.createCopy(this.getDependencies());
        for (Resource dependency : dependenciesCopy) {
            dependency.removeDependant(this);
        }
        this.dependencies.clear();
    }

    public String toString() {
        return this.resourceLocation.toString() + " (" + this.resourceType.toString() + ")";
    }
}

