/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.bundles;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.bundles.ComponentBundleTypeIndex;
import oracle.bpm.project.catalog.bundles.NoCatalogTypeIndex;
import oracle.bpm.project.catalog.bundles.ParsedObjectListener;
import oracle.bpm.project.catalog.bundles.ServiceReferenceManager;
import oracle.bpm.project.catalog.bundles.SynthesizedReferenceManager;
import oracle.bpm.project.catalog.bundles.XmlSchemaReferenceManager;
import oracle.bpm.project.catalog.common.AssociatedType;
import oracle.bpm.project.catalog.common.Resource;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.catalog.config.ProjectCatalogConfig;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeLoader;
import oracle.bpm.project.catalog.loaders.TypeLoaderRegistry;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.recognizer.ResourceListener;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.recognizer.VFileSystemBundleContext;
import oracle.bpm.project.catalog.type.BpmObjectWriter;
import oracle.bpm.project.catalog.type.ErrorTypeFactory;
import oracle.bpm.project.catalog.type.ResourceListenerException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.AbstractComponentBundle;
import oracle.bpm.type.catalog.MutableComponentBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCatalogComponentBundle
extends AbstractComponentBundle
implements MutableComponentBundle {
    private Map<String, AssociatedType> associatedTypes;
    private final ComponentCatalog catalog;
    private final CompositeAccessor controller;
    private final VFileSystemBundleContext fileSystemContext;
    private final TypeLoaderRegistry loadersRegistry;
    private List<ParsedObjectListener> parsedObjectListeners;
    private Project project;
    private List<SynthesizedReferenceManager> referenceManagers;
    private Map<URI, Resource> resourceGraph;
    private BusinessCatalogResourceListener resourceListener;
    private ServiceReferenceManager serviceManager;
    private final ComponentBundleTypeIndex typeIndex;
    private static final Set<String> ignoredIds = new LinkedHashSet<String>();
    private static final Set<ResourceType> firstLevelResources = new LinkedHashSet<ResourceType>();
    private static final String BUNDLE_ID = "project.catalog.component.bundle.id";

    public ProjectCatalogComponentBundle(@NotNull Project project, @NotNull MutableComponentCatalog catalog, @NotNull VFileSystem fileSystem) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.<init> must not be null");
        }
        this.fileSystemContext = new VFileSystemBundleContext(fileSystem);
        this.project = project;
        this.controller = CompositeAccessorFactory.createCompositeAccessor(project);
        this.catalog = catalog;
        this.resourceGraph = new Hashtable<URI, Resource>();
        this.associatedTypes = new Hashtable<String, AssociatedType>();
        this.typeIndex = new ComponentBundleTypeIndex((ComponentCatalog)catalog);
        this.loadersRegistry = TypeLoaderRegistry.create((TypeIndex)this.typeIndex, this.fileSystemContext.getFileSystem(), this.catalog, this.controller);
        this.registerVFileChangesListener(this.fileSystemContext);
        this.setUniqueId(BUNDLE_ID);
        this.parsedObjectListeners = new ArrayList<ParsedObjectListener>();
    }

    public void clear() {
    }

    public boolean hasChangedFrom(long date) {
        return true;
    }

    public void addParsedObjectListener(@NotNull ParsedObjectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.addParsedObjectListener must not be null");
        }
        this.parsedObjectListeners.add(listener);
    }

    public List<String> loadTypeNames() throws TypeCatalogException {
        this.resetBundle();
        Collection<Resource> resourceList = CollectionUtils.createCopy(this.resourceGraph.values());
        HashMap parsedObjects = new HashMap();
        for (Resource resource : resourceList) {
            parsedObjects.putAll(this.parseResource(resource, true));
        }
        NoCatalogTypeIndex noCatalogTypeIndex = new NoCatalogTypeIndex(this.typeIndex);
        Map<String, TypeDescription> defaultModules = this.loadersRegistry.defaultModules();
        for (TypeDescription typeDescription : defaultModules.values()) {
            noCatalogTypeIndex.add(typeDescription.asObject(), "");
        }
        resourceList = this.resourceGraph.values();
        for (Resource resource : resourceList) {
            if (resource.isTypeBuilt()) continue;
            this.buildTypeTree(resource, true, parsedObjects);
        }
        for (Map.Entry entry : this.typeIndex.getTypesByName().entrySet()) {
            String typeName = (String)entry.getKey();
            TypeDescription type = (TypeDescription)entry.getValue();
            for (SynthesizedReferenceManager referenceManager : this.referenceManagers) {
                referenceManager.addObject(noCatalogTypeIndex, typeName, type.asObject());
            }
        }
        this.serviceManager.buildAllSynthesizedServices(noCatalogTypeIndex);
        return this.typeIndex.getTypeNames();
    }

    public TypeDescription loadType(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        return this.typeIndex.findLocal(TypeUtils.buildFullName((String)typeName, (String)parentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(@NotNull ObjectTypeDescription type) throws TypeCatalogException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.store must not be null");
        }
        try {
            this.resourceListener.pauseEventProcessing();
            Map<VFile, ResourceType> files = BpmObjectWriter.write(type, this.fileSystemContext.getBusinessCatalogFolder());
            String typeName = type.getText();
            this.typeIndex.indexTypeAdded(typeName, (TypeDescription)type);
            for (SynthesizedReferenceManager referenceManager : this.referenceManagers) {
                referenceManager.typeAddedOrUpdated(this.typeIndex, typeName, type);
            }
            if (!type.isModule()) {
                this.addOrUpdateResourcesOnStore(files, type);
            }
        }
        finally {
            this.resourceListener.resumeEventProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(@NotNull String typeName) throws TypeCatalogException {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.remove must not be null");
        }
        TypeDescription type = this.typeIndex.findLocal(typeName);
        if (type == null) return;
        try {
            this.resourceListener.pauseEventProcessing();
            VFile businessCatalogFolder = this.fileSystemContext.getBusinessCatalogFolder();
            List<Object> list = Collections.emptyList();
            if (!type.isSynthesized()) {
                if (type.isBpmObject()) {
                    list = BpmObjectWriter.deleteBpmObject(typeName, businessCatalogFolder);
                } else if (type.isModule()) {
                    list = BpmObjectWriter.deleteModule(typeName, businessCatalogFolder);
                }
            }
            this.typeIndex.indexTypeRemoved(typeName);
            for (SynthesizedReferenceManager synthesizedReferenceManager : this.referenceManagers) {
                synthesizedReferenceManager.typeRemoved(this.typeIndex, typeName);
            }
            for (VFile vFile : list) {
                try {
                    URI uri = vFile.toURL().toURI();
                    Resource resource = this.resourceGraph.get(uri);
                    if (resource == null) continue;
                    this.removeAssociatedTypes(resource, false);
                    this.removeResource(uri, list);
                }
                catch (URISyntaxException e) {
                    throw new TypeCatalogException((Exception)e);
                }
                catch (IOException e) {
                    throw new TypeCatalogException((Exception)e);
                    return;
                }
            }
        }
        finally {
            this.resourceListener.resumeEventProcessing();
        }
    }

    public boolean isReadOnly(@NotNull TypeRef type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.isReadOnly must not be null");
        }
        if (type.getComponentType().equals(ComponentType.XOBJECT.getText())) {
            VFile businessCatalogFolder = this.fileSystemContext.getBusinessCatalogFolder();
            VFile file = BpmObjectWriter.getWsdlFile(type.getText(), businessCatalogFolder);
            return !file.canWrite();
        }
        return true;
    }

    public void reloadType(@NotNull TypeRef ref) throws TypeCatalogException {
        VFile[] files;
        SuperType superType;
        ObjectTypeDescription schemaType;
        VFile[] schemaFiles;
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.reloadType must not be null");
        }
        TypeDescription type = ref.get();
        ObjectTypeDescription otd = type.asObject();
        ArrayList<VFile> vfiles = new ArrayList<VFile>();
        if (otd.isBpmObject() && (schemaFiles = (VFile[])(schemaType = (superType = otd.getSuperType(0)).getObjectType()).getTransientProperty("files")) != null) {
            vfiles.addAll(Arrays.asList(schemaFiles));
        }
        if ((files = (VFile[])otd.getTransientProperty("files")) != null) {
            vfiles.addAll(Arrays.asList(files));
            for (VFile file : vfiles) {
                try {
                    URI uri = file.toURL().toURI();
                    Resource resource = this.resourceGraph.get(uri);
                    this.reloadResource(resource, false, false);
                }
                catch (URISyntaxException e) {
                    throw new TypeCatalogException(this.catalog, type.getText(), (Exception)e);
                }
                catch (IOException e) {
                    throw new TypeCatalogException(this.catalog, type.getText(), (Exception)e);
                }
            }
        }
    }

    private static boolean containsLocation(@NotNull Collection<VFile> vFiles, @NotNull URI resourceLocation) {
        if (vFiles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.containsLocation must not be null");
        }
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.containsLocation must not be null");
        }
        for (VFile vFile : vFiles) {
            if (!vFile.equals((Object)URLHelper.getFromURI((URI)resourceLocation))) continue;
            return true;
        }
        return false;
    }

    private void addParsedObject(Resource resource, @NotNull ParsedObject parsedObject, boolean reload) {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.addParsedObject must not be null");
        }
        URI uri = resource.getResourceLocation();
        ResourceType type = resource.getResourceType();
        for (ParsedObjectListener parsedObjectListener : this.parsedObjectListeners) {
            parsedObjectListener.add(type, parsedObject, uri, reload);
        }
    }

    private void removeParsedObject(Resource resource) {
        URI uri = resource.getResourceLocation();
        ResourceType type = resource.getResourceType();
        for (ParsedObjectListener parsedObjectListener : this.parsedObjectListeners) {
            parsedObjectListener.remove(type, uri);
        }
    }

    private void clearParsedObject() {
        for (ParsedObjectListener parsedObjectListener : this.parsedObjectListeners) {
            parsedObjectListener.clear();
        }
    }

    private void resetBundle() throws TypeCatalogException {
        this.typeIndex.clear();
        try {
            this.fileSystemContext.reload();
        }
        catch (IOException e) {
            throw new TypeCatalogException((Exception)e);
        }
        this.initResourceGraph();
        this.clearParsedObject();
        this.initReferenceManagers(this.catalog);
        for (SynthesizedReferenceManager referenceManager : this.referenceManagers) {
            referenceManager.clear();
        }
        this.controller.reload();
    }

    private void addOrUpdateResourcesOnStore(@NotNull Map<VFile, ResourceType> files, @NotNull ObjectTypeDescription otd) throws TypeCatalogException {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.addOrUpdateResourcesOnStore must not be null");
        }
        if (otd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.addOrUpdateResourcesOnStore must not be null");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Map.Entry<VFile, ResourceType> entry : files.entrySet()) {
            VFile file = entry.getKey();
            ResourceType type = entry.getValue();
            if (!this.loadersRegistry.isTypeSupported(type)) continue;
            try {
                URI uri = file.toURL().toURI();
                Resource resource = this.resourceGraph.get(uri);
                TypeLoader typeLoader = this.loadersRegistry.get(type);
                if (resource == null) {
                    resource = new Resource(type, uri, typeLoader.isStructuralDependant());
                    this.resourceGraph.put(uri, resource);
                }
                resources.add(resource);
                if (type != ResourceType.BPM_OBJECT) continue;
                resource.addAssociatedType(new AssociatedType(otd.getText()));
            }
            catch (IOException e) {
                throw new TypeCatalogException((Exception)e);
            }
            catch (URISyntaxException e) {
                throw new TypeCatalogException((Exception)e);
            }
        }
        HashMap parsedObjects = new HashMap();
        for (Resource resource : resources) {
            this.removeParsedObject(resource);
            resource.setParsed(false);
            resource.setTypeBuilt(false);
            parsedObjects.putAll(this.parseResource(resource, false));
            Map<String, TypeDescription> builtTypesByName = this.buildTypeTree(resource, false, parsedObjects);
            assert (otd.isBpmObject());
            String schemaId = otd.getProperty("attributes.schema.id");
            for (Map.Entry<String, TypeDescription> entry : builtTypesByName.entrySet()) {
                String typeName = entry.getKey();
                TypeDescription td = entry.getValue();
                if (this.catalog.find(typeName) != null) continue;
                if (td.getId() != null && td.getId().equals(schemaId)) {
                    otd.getSuperType(0).setType(td.getRef());
                }
                this.addTypeToCatalog(typeName, td);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private AssociatedType findOrCreateAssociatedType(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.findOrCreateAssociatedType must not be null");
        }
        AssociatedType result = this.associatedTypes.get(typeName);
        if (result == null) {
            result = new AssociatedType(typeName);
            this.associatedTypes.put(typeName, result);
        }
        AssociatedType associatedType = result;
        if (associatedType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.findOrCreateAssociatedType must not return null");
        }
        return associatedType;
    }

    private void initReferenceManagers(@NotNull ComponentCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.initReferenceManagers must not be null");
        }
        this.referenceManagers = new ArrayList<SynthesizedReferenceManager>();
        XmlSchemaReferenceManager xmlManager = new XmlSchemaReferenceManager(catalog);
        this.referenceManagers.add(xmlManager);
        this.serviceManager = new ServiceReferenceManager(this.controller, catalog, xmlManager);
        this.referenceManagers.add(this.serviceManager);
    }

    private void registerVFileChangesListener(VFileSystemBundleContext context) {
        this.resourceListener = new BusinessCatalogResourceListener();
        context.addListener(this.resourceListener);
    }

    private void removeResource(@NotNull URI uri, @NotNull List<VFile> reloadExcludes) throws TypeCatalogException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.removeResource must not be null");
        }
        if (reloadExcludes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.removeResource must not be null");
        }
        Resource resource = this.resourceGraph.remove(uri);
        assert (resource != null) : "Missing resource for URI '" + uri + "'";
        this.removeParsedObject(resource);
        resource.setDeleted(true);
        Collection<Resource> dependencies = CollectionUtils.createCopy(resource.getDependencies());
        for (Resource dependency : dependencies) {
            dependency.removeDependant(resource);
        }
        this.cleanOrphans(dependencies);
        Collection<Resource> dependants = CollectionUtils.createCopy(resource.getDependants());
        if (!dependants.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("WARNING: Removed resource '");
            builder.append(uri);
            builder.append("' was being referenced from the following resources: \n");
            boolean warnings = false;
            for (Resource dependant : dependants) {
                if (ProjectCatalogComponentBundle.containsLocation(reloadExcludes, dependant.getResourceLocation())) continue;
                if (dependant.isStructuralDependant()) {
                    this.reloadResource(dependant, false, false);
                }
                builder.append("\t* ");
                builder.append(dependant);
                builder.append("\n");
                warnings = true;
            }
            if (warnings && Log.isDebugging()) {
                Log.logDebug(builder.toString());
            }
        }
    }

    private void removeType(@NotNull String typeName) throws TypeCatalogException {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.removeType must not be null");
        }
        TypeRef typeRef = this.catalog.find(typeName);
        if (typeRef != null) {
            TypeDescription parent;
            TypeDescription td = typeRef.get();
            TypeRef parentRef = td.getParentRef();
            if (parentRef != null && (parent = parentRef.get()).isObject()) {
                parent.asObject().removeInnerType(typeRef);
            }
            this.typeIndex.remove(typeName);
        }
        this.typeIndex.indexTypeRemoved(typeName);
    }

    private void addTypeToCatalog(@NotNull String typeName, @NotNull TypeDescription td) throws TypeCatalogException {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.addTypeToCatalog must not be null");
        }
        if (td == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.addTypeToCatalog must not be null");
        }
        if (!this.ignoreType(td.getId())) {
            assert (td.isObject() || td.isEnum());
            this.typeIndex.add(td.asObject(), TypeUtils.moduleName((String)typeName, (String)""));
        }
    }

    private void initResourceGraph() throws TypeCatalogException {
        this.resourceGraph.clear();
        for (ResourceType resourceType : firstLevelResources) {
            this.addResourceByType(resourceType);
        }
    }

    private void addResourceByType(@NotNull ResourceType type) throws TypeCatalogException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.addResourceByType must not be null");
        }
        try {
            Iterable<VFile> vFileIterable = this.fileSystemContext.getResourcesByType(type);
            if (vFileIterable != null) {
                for (VFile vfile : vFileIterable) {
                    URI uri = vfile.toURL().toURI();
                    TypeLoader typeLoader = this.loadersRegistry.get(type);
                    Resource resource = new Resource(type, uri, typeLoader.isStructuralDependant());
                    this.resourceGraph.put(uri, resource);
                }
            }
        }
        catch (IOException e) {
            throw new TypeCatalogException((Exception)e);
        }
        catch (URISyntaxException e) {
            throw new TypeCatalogException((Exception)e);
        }
    }

    private Map<String, TypeDescription> buildTypeTree(@NotNull Resource resource, boolean checkDuplicates, @NotNull Map<Resource, ParsedObject<?>> parsedObjects) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.buildTypeTree must not be null");
        }
        if (parsedObjects == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.buildTypeTree must not be null");
        }
        TreeMap<String, TypeDescription> builtTypesByName = new TreeMap<String, TypeDescription>();
        List<Resource> sortedResources = Utils.tsort(resource);
        LinkedList<Map<String, TypeDescription>> preBuiltTypesList = new LinkedList<Map<String, TypeDescription>>();
        for (Resource sortedResource : sortedResources) {
            Map<String, TypeDescription> builtTypes = this.preBuildType(sortedResource, parsedObjects);
            preBuiltTypesList.add(builtTypes);
        }
        for (int i = 0; i < sortedResources.size(); ++i) {
            Resource sortedResource;
            sortedResource = sortedResources.get(i);
            Map preBuiltTypes = (Map)preBuiltTypesList.get(i);
            Map<String, TypeDescription> builtTypes = this.buildTypes(sortedResource, preBuiltTypes, checkDuplicates, parsedObjects);
            builtTypesByName.putAll(builtTypes);
        }
        return builtTypesByName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private <T> Map<String, TypeDescription> preBuildType(@NotNull Resource resource, @NotNull Map<Resource, ParsedObject<?>> parsedObjects) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.preBuildType must not be null");
        }
        if (parsedObjects == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.preBuildType must not be null");
        }
        TreeMap<String, TypeDescription> result = new TreeMap<String, TypeDescription>();
        if (!resource.isTypeBuilt()) {
            TypeLoader typeLoader = (TypeLoader)Cast.force(this.loadersRegistry.get(resource.getResourceType()));
            assert (typeLoader != null) : "FATAL: Missing TypeLoader";
            ParsedObject<?> parsedObject = parsedObjects.get(resource);
            ParsedObject tParsedObject = (ParsedObject)Cast.force(parsedObject);
            if (tParsedObject != null) {
                Map<String, TypeDescription> builtTypes = typeLoader.preBuildTypes(tParsedObject);
                this.checkDuplicatedTypes(resource, result, builtTypes);
                for (Map.Entry entry : result.entrySet()) {
                    TypeDescription type = (TypeDescription)entry.getValue();
                    if (this.ignoreType(type.getId())) continue;
                    String typeName = (String)entry.getKey();
                    resource.addAssociatedType(this.findOrCreateAssociatedType((String)entry.getKey()));
                    this.typeIndex.indexTypeAdded(typeName, type);
                }
            }
        }
        TreeMap<String, TypeDescription> treeMap = result;
        if (treeMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.preBuildType must not return null");
        }
        return treeMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private <T> Map<String, TypeDescription> buildTypes(@NotNull Resource resource, @NotNull Map<String, TypeDescription> preBuiltTypes, boolean checkDuplicates, @NotNull Map<Resource, ParsedObject<?>> parsedObjects) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.buildTypes must not be null");
        }
        if (preBuiltTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.buildTypes must not be null");
        }
        if (parsedObjects == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.buildTypes must not be null");
        }
        Map<String, TypeDescription> result = new TreeMap<String, TypeDescription>();
        if (!resource.isTypeBuilt()) {
            TypeLoader typeLoader = (TypeLoader)Cast.force(this.loadersRegistry.get(resource.getResourceType()));
            assert (typeLoader != null) : "FATAL: Missing TypeLoader";
            ParsedObject<?> parsedObject = parsedObjects.get(resource);
            ParsedObject tParsedObject = (ParsedObject)Cast.force(parsedObject);
            if (tParsedObject != null) {
                if (!tParsedObject.hasBuildErrors()) {
                    resource.clearAssociatedTypes();
                    for (String typeName : preBuiltTypes.keySet()) {
                        this.typeIndex.indexTypeRemoved(typeName);
                    }
                    Map<String, TypeDescription> builtTypes = typeLoader.buildTypes(tParsedObject);
                    if (checkDuplicates) {
                        this.checkDuplicatedTypes(resource, result, builtTypes);
                    } else {
                        result = builtTypes;
                    }
                    for (Map.Entry<String, TypeDescription> entry : result.entrySet()) {
                        TypeDescription type = entry.getValue();
                        if (this.ignoreType(type.getId())) continue;
                        String typeName = entry.getKey();
                        resource.addAssociatedType(this.findOrCreateAssociatedType(entry.getKey()));
                        this.typeIndex.indexTypeAdded(typeName, type);
                    }
                } else {
                    result = preBuiltTypes;
                }
                resource.setTypeBuilt(true);
            }
        }
        TreeMap<String, TypeDescription> treeMap = result;
        if (treeMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.buildTypes must not return null");
        }
        return treeMap;
    }

    private void checkDuplicatedTypes(@NotNull Resource sortedResource, @NotNull Map<String, TypeDescription> result, @NotNull Map<String, TypeDescription> builtTypes) {
        if (sortedResource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.checkDuplicatedTypes must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.checkDuplicatedTypes must not be null");
        }
        if (builtTypes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.checkDuplicatedTypes must not be null");
        }
        URI uri = sortedResource.getResourceLocation();
        for (Map.Entry<String, TypeDescription> entry : builtTypes.entrySet()) {
            TypeRef byTypeName;
            String typeName = entry.getKey();
            TypeDescription type = entry.getValue();
            String id = type.getId();
            if (this.ignoreType(id)) continue;
            boolean add = true;
            boolean error = false;
            TypeRef byId = null;
            if (id != null) {
                byId = this.typeIndex.findById(type.getComponentType(), id);
            }
            if (byId != null && (sortedResource.getResourceType() == ResourceType.WSDL || sortedResource.getResourceType() == ResourceType.XML_SCHEMA)) {
                if (type.isXmlObject()) {
                    XmlTypeDescription originOtd = (XmlTypeDescription)type;
                    boolean same = Utils.deepCompareXmlTypes(originOtd, (XmlTypeDescription)byId.get(), true);
                    if (same) {
                        add = false;
                        AssociatedType associatedType = this.associatedTypes.get(typeName);
                        if (associatedType != null) {
                            associatedType.addAssociatedResource(sortedResource);
                        }
                    } else {
                        error = true;
                        SchemaObject originSchemaObject = originOtd.asSchemaObject();
                        QName qName = new QName(originSchemaObject.getNamespace(), originSchemaObject.getName());
                        String failedResourceUrl = URLHelper.getResourceLocation((URI)sortedResource.getResourceLocation());
                        Set<Resource> dependants = sortedResource.getDependants();
                        ArrayList<String> dependantsPaths = new ArrayList<String>();
                        for (Resource dependant : dependants) {
                            URI depUri = dependant.getResourceLocation();
                            String resourcePath = URLHelper.getResourceLocation((URI)depUri);
                            dependantsPaths.add(resourcePath);
                        }
                        TypeDescription typeDescription = byId.get();
                        ErrorMsg msg = ProjectCatalogMsg.NONMATCHING_DUPLICATED_SCHEMA(failedResourceUrl, ((Object)dependantsPaths).toString(), qName, typeDescription.asSchemaObject().getLocation());
                        type = ErrorTypeFactory.createErrorResourceType(uri, msg);
                        typeName = type.getName();
                    }
                } else {
                    WsdlTypeDescription wsdlType = (WsdlTypeDescription)type;
                    error = true;
                    QName qName = new QName(wsdlType.getNamespace(), wsdlType.getName());
                    String path = uri.getPath();
                    ErrorMsg msg = ProjectCatalogMsg.DUPLICATED_PORTTYPE(path, qName, wsdlType.getLocation());
                    type = ErrorTypeFactory.createErrorResourceType(uri, msg);
                    typeName = type.getName();
                }
            }
            if (!error && add && (byTypeName = this.typeIndex.findExact(typeName)) != null) {
                TypeDescription td = byTypeName.get();
                String existingId = td.getId();
                if (existingId != null && id != null && !existingId.equals(id)) {
                    typeName = Utils.buildFreeName(this.typeIndex, typeName);
                } else {
                    String existingLocation = td.isObject() ? td.asObject().getProperty("resource_location") : "";
                    String path = uri.getPath();
                    ErrorMsg msg = ProjectCatalogMsg.DUPLICATED_TYPENAME(path, typeName, existingLocation);
                    type = ErrorTypeFactory.createErrorResourceType(uri, msg);
                    typeName = type.getName();
                }
            }
            if (!add) continue;
            TypeDescription td = result.get(typeName);
            if (error && td != null) {
                for (TypeError exception : type.getErrors()) {
                    td.addError(exception);
                }
            }
            type.asObject().setName(TypeUtils.shortName((String)typeName));
            result.put(typeName, type);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Map<Resource, ParsedObject<?>> parseResource(@NotNull Resource resource, boolean reload) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.parseResource must not be null");
        }
        HashMap parsedObjects = new HashMap();
        if (!resource.isParsed()) {
            TypeLoader typeLoader = this.loadersRegistry.get(resource.getResourceType());
            URI location = resource.getResourceLocation();
            Set<Resource> dependants = resource.getDependants();
            Resource dependant = CollectionUtils.first(dependants);
            URI dependantUri = dependant != null ? dependant.getResourceLocation() : null;
            ParsedObject parsedObject = typeLoader.parse(location, dependantUri);
            this.addParsedObject(resource, parsedObject, reload);
            parsedObjects.put(resource, parsedObject);
            resource.setParsed(true);
            resource.setTypeBuilt(false);
            Set<Dependency> dependencies = parsedObject.getDependencies();
            for (Dependency dep : dependencies) {
                if (this.ignoreUri(dep.getUri())) continue;
                Resource dependency = this.findOrCreateResource(dep);
                resource.addDependency(dependency);
                if (!dep.isParseable()) continue;
                parsedObjects.putAll(this.parseResource(dependency, reload));
            }
        }
        HashMap hashMap = parsedObjects;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.parseResource must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Resource findOrCreateResource(@NotNull Dependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.findOrCreateResource must not be null");
        }
        URI uri = dependency.getUri();
        Resource resource = this.resourceGraph.get(uri);
        if (resource == null) {
            ResourceType resourceType = dependency.getResourceType();
            TypeLoader loader = this.loadersRegistry.get(resourceType);
            resource = new Resource(resourceType, uri, loader.isStructuralDependant(), true);
            this.resourceGraph.put(uri, resource);
        }
        Resource resource2 = resource;
        if (resource2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.findOrCreateResource must not return null");
        }
        return resource2;
    }

    private void reloadResource(@NotNull Resource resource, boolean reloadDependants, boolean reloadTree) throws TypeCatalogException {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.reloadResource must not be null");
        }
        this.removeParsedObject(resource);
        resource.setParsed(false);
        resource.setTypeBuilt(false);
        Collection<Resource> oldDependencies = CollectionUtils.createCopy(resource.getDependencies());
        resource.clearDependencies();
        Set<String> removedTypes = this.removeAssociatedTypes(resource, false);
        Map<Resource, ParsedObject<?>> parsedObjects = this.parseResource(resource, false);
        Map<String, TypeDescription> builtTypesByName = reloadTree ? this.buildTypeTree(resource, true, parsedObjects) : this.buildTypes(resource, Collections.<String, TypeDescription>emptyMap(), true, parsedObjects);
        for (Map.Entry<String, TypeDescription> entry : builtTypesByName.entrySet()) {
            TypeDescription typeDescription = entry.getValue();
            if (typeDescription.hasErrors()) continue;
            removedTypes.remove(entry.getKey());
        }
        for (Map.Entry<String, TypeDescription> entry : builtTypesByName.entrySet()) {
            String string = entry.getKey();
            TypeDescription value = entry.getValue();
            TypeDescription parent = value.getParent();
            if (parent != null && builtTypesByName.containsKey(parent.getText())) continue;
            this.addTypeToCatalog(string, value);
        }
        for (String string : removedTypes) {
            for (SynthesizedReferenceManager referenceManager : this.referenceManagers) {
                referenceManager.typeRemoved(this.typeIndex, string);
            }
        }
        for (Map.Entry entry : builtTypesByName.entrySet()) {
            TypeDescription typeDescription = (TypeDescription)entry.getValue();
            if (!typeDescription.isObject()) continue;
            for (SynthesizedReferenceManager referenceManager : this.referenceManagers) {
                referenceManager.typeAddedOrUpdated(this.typeIndex, (String)entry.getKey(), typeDescription.asObject());
            }
        }
        if (reloadDependants) {
            for (Resource resource2 : CollectionUtils.createCopy(resource.getDependants())) {
                if (!resource2.isStructuralDependant()) continue;
                this.reloadResource(resource2, false, false);
            }
        }
        List<Object> customizedTypesToReload = ResourceType.COMPOSITE.equals((Object)resource.getResourceType()) ? this.serviceManager.refresh(this.typeIndex) : new ArrayList();
        oldDependencies.removeAll(resource.getDependencies());
        this.cleanOrphans(oldDependencies);
        for (String string : customizedTypesToReload) {
            TypeRef typeRef = this.catalog.find(string);
            if (typeRef == null) continue;
            this.reloadType(typeRef);
        }
    }

    private void cleanOrphans(Collection<Resource> tentativeOrphans) throws TypeCatalogException {
        for (Resource orphan : tentativeOrphans) {
            if (!this.isOrphan(orphan) || firstLevelResources.contains((Object)orphan.getResourceType()) && !orphan.isExternal()) continue;
            this.removeAssociatedTypes(orphan, true);
            this.removeResource(orphan.getResourceLocation(), Collections.<VFile>emptyList());
        }
    }

    private boolean isOrphan(@NotNull Resource orphan) {
        if (orphan == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.isOrphan must not be null");
        }
        boolean result = true;
        if (!orphan.isDeleted()) {
            if (!orphan.getDependants().isEmpty()) {
                for (Resource dependant : orphan.getDependants()) {
                    if (ResourceType.BPM_OBJECT == dependant.getResourceType()) continue;
                    result = false;
                    break;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Set<String> removeAssociatedTypes(@NotNull Resource resource, boolean notifyManagers) throws TypeCatalogException {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.removeAssociatedTypes must not be null");
        }
        HashSet<String> removedTypes = new HashSet<String>();
        for (AssociatedType type : CollectionUtils.createCopy(resource.getAssociatedTypes())) {
            String typeName = type.getTypeName();
            resource.removeAssociatedType(type);
            if (type.getAssociatedResources().isEmpty()) {
                this.removeType(typeName);
                removedTypes.add(typeName);
                if (!notifyManagers) continue;
                for (SynthesizedReferenceManager manager : this.referenceManagers) {
                    manager.typeRemoved(this.typeIndex, typeName);
                }
                continue;
            }
            try {
                TypeDescription td;
                TypeRef ref = this.typeIndex.findExact(typeName);
                if (ref == null || !(td = ref.get()).isObject()) continue;
                ObjectTypeDescription otd = td.asObject();
                URI location = type.getAssociatedResources().iterator().next().getResourceLocation();
                AbstractTypeLoader.updateResourceLocationData(location, otd);
            }
            catch (TypeBuildException e) {
                throw new TypeCatalogException((Exception)e);
            }
        }
        HashSet<String> hashSet = removedTypes;
        if (hashSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.removeAssociatedTypes must not return null");
        }
        return hashSet;
    }

    private boolean ignoreUri(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle.ignoreUri must not be null");
        }
        return ProjectCatalogConfig.getInstance().getUrisToLoad().contains(uri);
    }

    private boolean ignoreType(@Nullable String typeId) {
        return typeId != null && ignoredIds.contains(typeId);
    }

    static {
        firstLevelResources.add(ResourceType.XML_SCHEMA);
        firstLevelResources.add(ResourceType.BPM_OBJECT);
        firstLevelResources.add(ResourceType.COMPOSITE);
        firstLevelResources.add(ResourceType.MUTABLE_MODULE);
        firstLevelResources.add(ResourceType.EVENT);
        firstLevelResources.add(ResourceType.PROJECT_WSLD);
        firstLevelResources.add(ResourceType.WEB_FORM);
        ignoredIds.add(UUIDFactory.createXmlId((XmlElementType)XmlElementType.ELEMENT, (String)"http://xmlns.oracle.com/bpel/workflow/task", (String)"task").getId());
    }

    private class BusinessCatalogResourceListener
    implements ResourceListener {
        private final Set<Thread> suspended = Collections.synchronizedSet(new HashSet());

        private BusinessCatalogResourceListener() {
        }

        @Override
        public boolean resourceDeleted(@NotNull VFile file) throws ResourceListenerException {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle$BusinessCatalogResourceListener.resourceDeleted must not be null");
            }
            if (!this.suspended()) {
                try {
                    URI uri = file.toURL().toURI();
                    Resource resource = (Resource)ProjectCatalogComponentBundle.this.resourceGraph.get(uri);
                    if (resource != null) {
                        ProjectCatalogComponentBundle.this.removeAssociatedTypes(resource, true);
                        ProjectCatalogComponentBundle.this.removeResource(uri, Collections.emptyList());
                        return true;
                    }
                }
                catch (URISyntaxException e) {
                    throw new ResourceListenerException(ProjectCatalogMsg.MALFORMED_URI(file.toString()), (Throwable)e);
                }
                catch (IOException e) {
                    throw new ResourceListenerException(ProjectCatalogMsg.UNEXPECTED_IO_ERROR(file.toString()), (Throwable)e);
                }
                catch (TypeCatalogException e) {
                    throw new ResourceListenerException(e.getKey(), e.getCause());
                }
            }
            return false;
        }

        @Override
        public boolean resourceAdded(@NotNull ResourceType type, @NotNull VFile file) throws ResourceListenerException {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle$BusinessCatalogResourceListener.resourceAdded must not be null");
            }
            if (file == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle$BusinessCatalogResourceListener.resourceAdded must not be null");
            }
            if (!this.suspended() && firstLevelResources.contains((Object)type)) {
                try {
                    URI uri = file.toURL().toURI();
                    Resource resource = (Resource)ProjectCatalogComponentBundle.this.resourceGraph.get(uri);
                    if (resource == null) {
                        TypeLoader typeLoader = ProjectCatalogComponentBundle.this.loadersRegistry.get(type);
                        Resource newResource = new Resource(type, uri, typeLoader.isStructuralDependant());
                        Map parsedObjects = ProjectCatalogComponentBundle.this.parseResource(newResource, false);
                        Map builtTypesByName = ProjectCatalogComponentBundle.this.buildTypeTree(newResource, true, parsedObjects);
                        for (Map.Entry builtType : builtTypesByName.entrySet()) {
                            String typeName = (String)builtType.getKey();
                            if (ProjectCatalogComponentBundle.this.catalog.find(typeName) != null) continue;
                            TypeDescription td = (TypeDescription)builtType.getValue();
                            ProjectCatalogComponentBundle.this.addTypeToCatalog(typeName, td);
                        }
                        for (Map.Entry entry : builtTypesByName.entrySet()) {
                            TypeDescription td = (TypeDescription)entry.getValue();
                            if (!td.isObject()) continue;
                            for (SynthesizedReferenceManager referenceManager : ProjectCatalogComponentBundle.this.referenceManagers) {
                                referenceManager.typeAddedOrUpdated(ProjectCatalogComponentBundle.this.typeIndex, (String)entry.getKey(), td.asObject());
                            }
                        }
                        ProjectCatalogComponentBundle.this.resourceGraph.put(uri, newResource);
                        return true;
                    }
                    resource.setExternal(false);
                }
                catch (URISyntaxException e) {
                    throw new ResourceListenerException(ProjectCatalogMsg.MALFORMED_URI(file.toString()), (Throwable)e);
                }
                catch (IOException e) {
                    throw new ResourceListenerException(ProjectCatalogMsg.UNEXPECTED_IO_ERROR(file.toString()), (Throwable)e);
                }
                catch (TypeCatalogException e) {
                    throw new ResourceListenerException(e.getKey(), e.getCause());
                }
            }
            return false;
        }

        @Override
        public boolean resourceUpdated(@NotNull VFile file) throws ResourceListenerException {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/ProjectCatalogComponentBundle$BusinessCatalogResourceListener.resourceUpdated must not be null");
            }
            if (!this.suspended()) {
                try {
                    ResourceType resourceType;
                    URI uri = file.toURL().toURI();
                    final Resource resource = (Resource)ProjectCatalogComponentBundle.this.resourceGraph.get(uri);
                    if (resource != null) {
                        CatalogModule catalog = ProjectCatalogComponentBundle.this.project.getCatalogRoot();
                        Callable<Void> reloadResource = new Callable<Void>(){

                            @Override
                            public Void call() throws TypeCatalogException {
                                ProjectCatalogComponentBundle.this.reloadResource(resource, true, true);
                                return null;
                            }
                        };
                        try {
                            Transactable transactable = (Transactable)((Object)catalog);
                            transactable.run(reloadResource);
                        }
                        catch (TypeCatalogException e) {
                            throw e;
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return true;
                    }
                    if (!file.isDirectory() && (resourceType = ProjectCatalogComponentBundle.this.fileSystemContext.processResourceType(file)) != null) {
                        this.resourceAdded(resourceType, file);
                    }
                }
                catch (URISyntaxException e) {
                    throw new ResourceListenerException(ProjectCatalogMsg.MALFORMED_URI(file.toString()), (Throwable)e);
                }
                catch (IOException e) {
                    throw new ResourceListenerException(ProjectCatalogMsg.UNEXPECTED_IO_ERROR(file.toString()), (Throwable)e);
                }
                catch (TypeCatalogException e) {
                    Throwable cause = e.getCause();
                    throw new ResourceListenerException(e.getKey(), cause == null ? e : cause);
                }
            }
            return false;
        }

        void pauseEventProcessing() {
            if (!this.suspended.add(Thread.currentThread())) {
                throw new IllegalStateException("reentering from the same thread");
            }
        }

        void resumeEventProcessing() {
            if (!this.suspended.remove(Thread.currentThread())) {
                throw new IllegalStateException("resuming without pausing");
            }
        }

        private boolean suspended() {
            return this.suspended.contains(Thread.currentThread());
        }
    }
}

