/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class BufferOutputStream
extends OutputStream {
    private byte[] buffer;
    private int size;

    public BufferOutputStream() {
        this(512);
    }

    public BufferOutputStream(int initial) {
        this.buffer = new byte[initial];
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public void reset() {
        this.size = 0;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.size];
        System.arraycopy(this.buffer, 0, data, 0, this.size);
        return data;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensure(len);
        System.arraycopy(b, off, this.buffer, this.size, len);
        this.size += len;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensure(1);
        this.buffer[this.size++] = (byte)b;
    }

    public void writeAt(int at, int b) {
        assert (at >= 0 && at < this.size) : "out of bounds: at = " + at;
        this.buffer[at] = (byte)b;
    }

    public void writeInt(int i) throws IOException {
        this.ensure(4);
        this.buffer[this.size++] = (byte)(0xFF & i >> 24);
        this.buffer[this.size++] = (byte)(0xFF & i >> 16);
        this.buffer[this.size++] = (byte)(0xFF & i >> 8);
        this.buffer[this.size++] = (byte)(0xFF & i);
    }

    public void writeIntAt(int at, int value) {
        assert (at >= 0 && at < this.size) : "out of bounds: at = " + at;
        this.buffer[at++] = (byte)(0xFF & value >> 24);
        this.buffer[at++] = (byte)(0xFF & value >> 16);
        this.buffer[at++] = (byte)(0xFF & value >> 8);
        this.buffer[at++] = (byte)(0xFF & value);
    }

    public void writeShort(short s) {
        this.ensure(2);
        this.buffer[this.size++] = (byte)(0xFF & s >> 8);
        this.buffer[this.size++] = (byte)(0xFF & s);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.buffer, 0, this.size);
    }

    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensure(utflen + 2);
        int count = this.size;
        byte[] bytearr = this.buffer;
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.size = count;
    }

    private void ensure(int size) {
        assert (size >= 0) : "negative size requested";
        int oldSize = this.size;
        int required = size + oldSize;
        if (this.buffer.length < required) {
            int newSize = required + oldSize;
            byte[] newBuf = new byte[newSize];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
    }
}

