/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Time;

public class Compiler {
    private Class class_d;
    private String className_d;
    private String package_d;
    private IndentedPrintWriter pw_d;

    public Compiler() {
    }

    public Compiler(Class clazz) {
        this(null, null, clazz);
    }

    public Compiler(String pkg, String className, Class clazz) {
        this.setClass(clazz);
        this.setPackage(pkg);
        this.setClassName(className);
    }

    public static void main(String[] args) throws Exception {
        String packageName = null;
        String targetDir = null;
        ArrayList<String> interfaces = new ArrayList<String>();
        block8: for (int i = 0; i < args.length; ++i) {
            switch (args[i].charAt(0)) {
                case '-': 
                case '/': {
                    if (i + 1 > args.length || args[i].length() != 2) {
                        Compiler.printUsage();
                        return;
                    }
                    switch (args[i++].charAt(1)) {
                        case 'P': 
                        case 'p': {
                            packageName = args[i];
                            continue block8;
                        }
                        case 'D': 
                        case 'd': {
                            targetDir = args[i];
                            continue block8;
                        }
                    }
                    Compiler.printUsage();
                    return;
                }
                case '@': {
                    String line;
                    FileReader fr = new FileReader(args[i].substring(1));
                    BufferedReader br = new BufferedReader(fr);
                    while ((line = br.readLine()) != null) {
                        interfaces.add(line);
                    }
                    br.close();
                    fr.close();
                    continue block8;
                }
                default: {
                    interfaces.add(args[i]);
                }
            }
        }
        Compiler compiler = new Compiler();
        for (String iface : interfaces) {
            Class<?> target = Class.forName(iface);
            if (!target.isInterface()) {
                System.out.println("Skipping " + iface + ", it's not an interface.");
                continue;
            }
            compiler.setClass(target);
            compiler.setPackage(packageName);
            compiler.setClassName(null);
            System.out.println("Generating proxy for " + target.getName());
            File targetFile = new File(targetDir, compiler.getClassName() + ".java");
            FileWriter fw = new FileWriter(targetFile);
            compiler.generate(fw);
            fw.close();
        }
    }

    public void setClass(Class clazz) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Class should be an interface: " + clazz.getName());
        }
        this.class_d = clazz;
    }

    public void setClassName(String className) {
        if (className == null) {
            className = this.class_d.getName();
            className = className.substring(className.lastIndexOf(46) + 1) + "Proxy";
        }
        this.className_d = className;
    }

    public String getClassName() {
        return this.className_d;
    }

    public void setPackage(String pkg) {
        if (pkg == null) {
            pkg = this.class_d.getName();
            pkg = pkg.substring(0, pkg.lastIndexOf(46));
        }
        this.package_d = pkg;
    }

    public void generate(Writer w) throws IOException {
        Method[] mtds;
        this.pw_d = w instanceof IndentedPrintWriter ? (IndentedPrintWriter)w : new IndentedPrintWriter(w);
        this.generateFileHeader();
        this.generateClassHeader();
        this.generateFields();
        this.generateConstructors();
        for (Method mtd : mtds = this.class_d.getMethods()) {
            this.generateMethod(mtd);
        }
        this.generateSupportMethods();
        this.generateClassFooter();
    }

    private static void printUsage() {
        System.err.println("ftrmic [-p packageName] [-d outputDir] interface ... ");
    }

    private void generateClassFooter() {
        this.pw_d.dedent();
        this.pw_d.println("} // end " + this.className_d);
    }

    private void generateClassHeader() {
        this.pw_d.println("public class " + this.className_d);
        this.pw_d.indent();
        this.pw_d.println("implements Remote, " + this.class_d.getName());
        this.pw_d.dedent();
        this.pw_d.println("{");
        this.pw_d.indent();
    }

    private void generateConstructors() {
        this.pw_d.println("//Constructors");
        this.pw_d.println("public " + this.className_d + "(RemoteProxy res)");
        this.pw_d.println("{");
        this.pw_d.indent();
        this.pw_d.println("proxy = res;");
        this.pw_d.println("executor = new ExecutorClient(proxy);");
        this.pw_d.dedent();
        this.pw_d.println("}");
        this.pw_d.println();
        this.pw_d.println("public " + this.className_d + "(NetURL url, String objectID) throws RMIException");
        this.pw_d.println("{");
        this.pw_d.indent();
        this.pw_d.println("proxy = new RemoteProxy(url, objectID);");
        this.pw_d.println("executor = new ExecutorClient(proxy);");
        this.pw_d.dedent();
        this.pw_d.println("}");
        this.pw_d.println();
        this.pw_d.println("public " + this.className_d + "(Remote remote, String objectId)  throws RMIException");
        this.pw_d.println("{");
        this.pw_d.indent();
        this.pw_d.println("proxy = new RemoteProxy(remote.getRemoteProxy(), objectId);");
        this.pw_d.println("executor = new ExecutorClient(proxy);");
        this.pw_d.dedent();
        this.pw_d.println("}");
        this.pw_d.println();
    }

    private void generateFields() {
        this.pw_d.println("//Fields");
        this.pw_d.println("private RemoteProxy proxy;");
        this.pw_d.println("private ExecutorClient executor;");
        this.pw_d.println();
    }

    private void generateFileHeader() {
        this.pw_d.println("// DO NOT EDIT, this class was autogenerated " + new Time());
        this.pw_d.println("package " + this.package_d + ";");
        this.pw_d.println("");
        this.pw_d.println("import fuego.rmi.RemoteProxy;");
        this.pw_d.println("import fuego.rmi.RMIException;");
        this.pw_d.println("import fuego.rmi.Remote;");
        this.pw_d.println("import fuego.rmi.RMIRuntimeException;");
        this.pw_d.println("import oracle.bpm.component.ExecutorClient;");
        this.pw_d.println("import oracle.bpm.component.Proxy;");
        this.pw_d.println("import oracle.bpm.lang.RuntimeExceptionShell;");
        this.pw_d.println("import oracle.bpm.util.NetURL;");
        this.pw_d.println("");
    }

    /*
     * WARNING - void declaration
     */
    private void generateMethod(Method m) {
        void var9_13;
        int i;
        this.pw_d.print("public");
        this.pw_d.print(' ');
        this.pw_d.print(this.typeFor(m.getReturnType()));
        this.pw_d.print(' ');
        this.pw_d.print(m.getName());
        this.pw_d.print('(');
        Class<?>[] args = m.getParameterTypes();
        for (int i2 = 0; i2 < args.length; ++i2) {
            this.pw_d.print(this.typeFor(args[i2]));
            this.pw_d.print(" arg" + i2);
            if (i2 + 1 >= args.length) continue;
            this.pw_d.print(", ");
        }
        this.pw_d.println(')');
        this.pw_d.indent();
        Class<?>[] exc = m.getExceptionTypes();
        boolean throwsRMIException = false;
        for (i = 0; i < exc.length; ++i) {
            if (i == 0) {
                this.pw_d.print("throws ");
            }
            this.pw_d.print(exc[i].getName());
            if (i + 1 < exc.length) {
                this.pw_d.print(", ");
            }
            if (!exc[i].getName().equals("fuego.rmi.RMIException")) continue;
            throwsRMIException = true;
        }
        if (exc.length > 0) {
            this.pw_d.println();
        }
        this.pw_d.dedent();
        this.pw_d.println("{");
        this.pw_d.indent();
        this.pw_d.println("Object result = null;");
        this.pw_d.println("try {");
        this.pw_d.indent();
        this.pw_d.print("result = executor.invoke(\"" + JavaClass.getSignature((Method)m) + "\", ");
        this.pw_d.print("new Object[] {");
        for (i = 0; i < args.length; ++i) {
            if (args[i].isPrimitive()) {
                this.pw_d.print("new " + this.mapPrimitive(args[i]).getName() + "(arg" + i + "),");
                continue;
            }
            this.pw_d.print(" arg" + i + ",");
        }
        this.pw_d.println("});");
        this.pw_d.dedent();
        boolean useDefaultExceptionHandler = true;
        if (throwsRMIException) {
            this.pw_d.println("} catch(RMIRuntimeException re) {");
            this.pw_d.indent();
            this.pw_d.println("throw (RMIException)re.getCause();");
            this.pw_d.dedent();
        }
        this.pw_d.println("} catch(RuntimeException re) {");
        this.pw_d.indent();
        this.pw_d.println("throw re;");
        this.pw_d.dedent();
        HashSet exceptions = new HashSet(Arrays.asList(exc));
        Class<?>[] arr$ = exc;
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_13 < len$) {
            Class<?> aExc = arr$[var9_13];
            for (Class<?> tmp = aExc.getSuperclass(); tmp != null; tmp = tmp.getSuperclass()) {
                if (!exceptions.contains(tmp)) continue;
                exceptions.remove(aExc);
                break;
            }
            ++var9_13;
        }
        int excIndex = 0;
        for (Class clazz : exceptions) {
            if (RuntimeException.class.isAssignableFrom(clazz)) continue;
            if (Exception.class.equals((Object)clazz)) {
                useDefaultExceptionHandler = false;
            }
            this.pw_d.println("} catch(" + clazz.getName() + " ex" + excIndex + ") {");
            this.pw_d.indent();
            this.pw_d.println("throw ex" + excIndex + ";");
            this.pw_d.dedent();
            ++excIndex;
        }
        if (useDefaultExceptionHandler) {
            this.pw_d.println("} catch(Exception ex) {");
            this.pw_d.indent();
            this.pw_d.println("throw new RuntimeExceptionShell(ex);");
            this.pw_d.dedent();
        }
        this.pw_d.println("}");
        Class<?> retType = m.getReturnType();
        if (retType != Void.TYPE) {
            if (retType.isPrimitive()) {
                this.pw_d.println("return ((" + this.mapPrimitive(retType).getName() + ") result)." + retType.getName() + "Value();");
            } else {
                this.pw_d.println("return (" + this.typeFor(retType) + ") result;");
            }
        }
        this.pw_d.dedent();
        this.pw_d.println("}");
        this.pw_d.println();
    }

    private void generateSupportMethods() {
        this.pw_d.println("//Support methods");
        this.pw_d.println("public RemoteProxy getRemoteProxy()");
        this.pw_d.println("{");
        this.pw_d.indent();
        this.pw_d.println("return proxy;");
        this.pw_d.dedent();
        this.pw_d.println("}");
        this.pw_d.println();
        this.pw_d.println("public ExecutorClient getExecutorClient()");
        this.pw_d.println("{");
        this.pw_d.indent();
        this.pw_d.println("return executor;");
        this.pw_d.dedent();
        this.pw_d.println("}");
        this.pw_d.println();
    }

    private Class mapPrimitive(Class p) {
        if (p == Boolean.TYPE) {
            return Boolean.class;
        }
        if (p == Short.TYPE) {
            return Short.class;
        }
        if (p == Integer.TYPE) {
            return Integer.class;
        }
        if (p == Float.TYPE) {
            return Float.class;
        }
        if (p == Double.TYPE) {
            return Double.class;
        }
        if (p == Character.TYPE) {
            return Character.class;
        }
        if (p == Long.TYPE) {
            return Long.class;
        }
        if (p == Byte.TYPE) {
            return Byte.class;
        }
        return p;
    }

    private String typeFor(Class c) {
        if (c.isArray()) {
            return this.typeFor(c.getComponentType()) + "[]";
        }
        return c.getName();
    }
}

