/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.spi;

import fuego.rmi.Packet;
import fuego.rmi.StreamFactory;
import fuego.rmi.spi.ConnectException;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.PacketHandler;
import fuego.rmi.spi.SendException;
import fuego.rmi.spi.SerializationException;
import fuego.rmi.spi.TransportException;
import fuego.rmi.util.BufferOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.util.LinkedList;
import oracle.bpm.log.Log;

public abstract class BaseConnection
implements Connection {
    protected InputStream is;
    protected OutputStream os;
    private final BufferOutputStream buffer = new BufferOutputStream(1024);
    private DataInputStream dis;
    private volatile boolean dismissed;
    private final Object dismissLock = new Object();
    private volatile StreamFactory factory;
    private volatile PacketHandler handler;
    private final LinkedList<byte[]> outQ = new LinkedList();
    private Receiver receiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPacketHandler(PacketHandler handler) throws TransportException {
        Object object = this.dismissLock;
        synchronized (object) {
            if (this.dismissed) {
                throw new IllegalStateException("Connection already dismissed");
            }
            if (handler == null) {
                throw new NullPointerException("PacketHandler cannot be set to null");
            }
            this.handler = handler;
            if (this.receiver == null) {
                String address;
                block8: {
                    address = "<address not available>";
                    try {
                        address = this.getPeerID();
                    }
                    catch (TransportException e) {
                        if (!Log.isDebugging()) break block8;
                        Log.logDebug((Throwable)((Object)e));
                    }
                }
                this.receiver = new Receiver(address);
                this.receiver.start();
            }
        }
    }

    @Override
    public void setStreamFactory(StreamFactory factory) {
        this.factory = factory;
    }

    @Override
    public void dismiss() {
        this.shutdown(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Packet message) throws TransportException {
        byte[] data;
        Object object = this.buffer;
        synchronized (object) {
            this.buffer.reset();
            try {
                message.write(this.buffer, this.factory);
            }
            catch (NotSerializableException e) {
                throw new SerializationException(e);
            }
            catch (IOException e) {
                throw new SendException(e);
            }
            catch (InternalError e) {
                throw new SerializationException(e);
            }
            data = this.buffer.toByteArray();
        }
        object = this.outQ;
        synchronized (object) {
            this.outQ.addLast(data);
            this.outQ.notify();
        }
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    protected abstract void close() throws IOException;

    protected void init() throws TransportException {
        try {
            this.is = this.getInputStream();
            this.os = this.getOutputStream();
            this.dis = new DataInputStream(this.is);
        }
        catch (IOException e) {
            throw new ConnectException(this.getPeerID(), e);
        }
        new Sender(this.getPeerID()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(Throwable e) {
        Object object = this.dismissLock;
        synchronized (object) {
            if (this.dismissed) {
                return;
            }
            this.dismissed = true;
            LinkedList<byte[]> linkedList = this.outQ;
            synchronized (linkedList) {
                this.outQ.notify();
            }
        }
        if (this.handler != null && e != null) {
            this.handler.exception(e);
        }
        try {
            this.close();
        }
        catch (IOException ioex) {
            Log.logWarning((Throwable)ioex);
        }
    }

    private class Sender
    extends Thread {
        public Sender(String address) {
            super("Socket Sender[" + address + "]");
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                byte[] data;
                LinkedList linkedList = BaseConnection.this.outQ;
                synchronized (linkedList) {
                    while (BaseConnection.this.outQ.isEmpty() && !BaseConnection.this.dismissed) {
                        try {
                            BaseConnection.this.outQ.wait();
                        }
                        catch (InterruptedException e) {
                            Log.logSevere((Throwable)e);
                        }
                    }
                    if (BaseConnection.this.dismissed) {
                        return;
                    }
                    data = (byte[])BaseConnection.this.outQ.removeFirst();
                }
                try {
                    BaseConnection.this.os.write(data);
                    continue;
                }
                catch (IOException e) {
                    BaseConnection.this.shutdown(e);
                    continue;
                }
                break;
            }
        }
    }

    private class Receiver
    extends Thread {
        public Receiver(String address) {
            super("Socket Receiver[" + address + "]");
            this.setDaemon(true);
            this.setPriority(10);
        }

        @Override
        public void run() {
            try {
                while (!BaseConnection.this.dismissed) {
                    Packet packet = Packet.read(BaseConnection.this.dis, BaseConnection.this.factory);
                    BaseConnection.this.handler.received(packet);
                }
            }
            catch (Throwable e) {
                BaseConnection.this.shutdown(e);
            }
        }
    }
}

