/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.nio;

import fuego.rmi.nio.FrameCorruptedException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

class FrameHeader {
    private int length;
    static final int MAGIC = 619493733;
    static final int SIZE = 8;

    FrameHeader() {
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    void get(ByteBuffer buf) throws FrameCorruptedException {
        if (buf.remaining() < 8) {
            throw new BufferUnderflowException();
        }
        int pos = buf.position();
        if (buf.getInt() != 619493733) {
            buf.position(pos);
            throw new FrameCorruptedException("Illegal magic number");
        }
        this.length = buf.getInt();
    }

    void get(byte[] buf, int off) throws FrameCorruptedException {
        int remaining = buf.length - off;
        if (remaining < 8) {
            throw new BufferUnderflowException();
        }
        if (this.getInt(buf, off) != 619493733) {
            throw new FrameCorruptedException("Illegal magic number");
        }
        this.length = this.getInt(buf, off + 4);
    }

    void put(ByteBuffer buf) {
        if (buf.remaining() < 8) {
            throw new BufferUnderflowException();
        }
        buf.putInt(619493733);
        buf.putInt(this.length);
    }

    private int getInt(byte[] buf, int off) {
        if (off < 0 || off + 4 > buf.length) {
            throw new IndexOutOfBoundsException("off = " + off + ", size = " + buf.length);
        }
        return ((buf[off] & 0xFF) << 24) + ((buf[off + 1] & 0xFF) << 16) + ((buf[off + 2] & 0xFF) << 8) + ((buf[off + 3] & 0xFF) << 0);
    }
}

