/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.nio;

import fuego.rmi.nio.Environment;
import fuego.rmi.nio.SocketHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.bpm.log.Log;
import oracle.bpm.util.LifecycleLock;
import oracle.bpm.util.Rendezvous;

public class Acceptor {
    private Selector acceptSelector;
    private LifecycleLock control = new LifecycleLock();
    private Environment env;
    private SocketHandler handler;
    private final LinkedList<ServerSocketChannel> registrationQueue;
    private Rendezvous shutdown = null;
    private Worker worker;

    public Acceptor(Environment environment) {
        this.env = environment;
        this.registrationQueue = new LinkedList();
    }

    public static void main(String[] args) throws IOException {
        String line;
        Environment env = new Environment();
        Acceptor server = new Acceptor(env);
        server.start();
        server.listen(new InetSocketAddress(6060));
        server.listen(new InetSocketAddress(6061));
        server.listen(new InetSocketAddress(6062));
        new Socket("localhost", 6060);
        new Socket("localhost", 6061);
        new Socket("localhost", 6062);
        System.out.println("ConfigType 'shutdown' and hit [ENTER] to begin the shutdown sequence");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((line = reader.readLine()) == null || !line.trim().equalsIgnoreCase("shutdown")) {
        }
        System.out.println("Shutting down all services...");
        server.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void listen(InetSocketAddress addr) throws IOException {
        this.control.beginWork();
        try {
            ServerSocketChannel ssch = ServerSocketChannel.open();
            ssch.configureBlocking(false);
            ssch.socket().setReceiveBufferSize(this.env.getReceiveBufferSize());
            ssch.socket().bind(addr);
            LinkedList<ServerSocketChannel> linkedList = this.registrationQueue;
            synchronized (linkedList) {
                this.registrationQueue.add(ssch);
            }
            this.acceptSelector.wakeup();
        }
        finally {
            this.control.endWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.control.beginShutdown();
        try {
            block13: {
                this.acceptSelector.wakeup();
                try {
                    this.shutdown.meet(this.env.getShutdownTimeout());
                }
                catch (InterruptedException e) {
                    Log.logWarning((Throwable)e);
                }
                for (SelectionKey key : this.acceptSelector.keys()) {
                    SelectableChannel ch = key.channel();
                    if (!ch.isOpen()) continue;
                    try {
                        ch.close();
                    }
                    catch (IOException e) {
                        if (!Log.isDebugging()) continue;
                        Log.logDebug((Throwable)e);
                    }
                }
                try {
                    this.acceptSelector.close();
                }
                catch (IOException e) {
                    if (!Log.isDebugging()) break block13;
                    Log.logDebug((Throwable)e);
                }
            }
            this.handler.shutdown();
            Iterator it = this.registrationQueue.iterator();
            while (it.hasNext()) {
                block14: {
                    ServerSocketChannel channel = (ServerSocketChannel)it.next();
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        if (!Log.isDebugging()) break block14;
                        Log.logDebug((Throwable)e);
                    }
                }
                it.remove();
            }
            this.acceptSelector = null;
            this.handler = null;
            this.worker = null;
            this.registrationQueue.clear();
        }
        finally {
            this.control.endShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws IOException {
        this.control.beginStartup();
        try {
            this.shutdown = new Rendezvous(2);
            this.registrationQueue.clear();
            this.acceptSelector = Selector.open();
            this.handler = new SocketHandler(this.env);
            this.handler.start();
            this.worker = new Worker();
            this.worker.start();
        }
        finally {
            this.control.endStartup();
        }
    }

    private SocketHandler chooseHandler() {
        return this.handler;
    }

    static /* synthetic */ LifecycleLock access$000(Acceptor x0) {
        return x0.control;
    }

    static /* synthetic */ LinkedList access$100(Acceptor x0) {
        return x0.registrationQueue;
    }

    static /* synthetic */ Selector access$200(Acceptor x0) {
        return x0.acceptSelector;
    }

    static /* synthetic */ SocketHandler access$300(Acceptor x0) {
        return x0.chooseHandler();
    }

    static /* synthetic */ Environment access$400(Acceptor x0) {
        return x0.env;
    }

    static /* synthetic */ Rendezvous access$500(Acceptor x0) {
        return x0.shutdown;
    }

    public class Worker
    extends Thread {
        public Worker() {
            super("RMI Acceptor Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block19: while (true) {
                    if (Acceptor.access$000(Acceptor.this).isShuttingDown() != false) return;
                    var1_1 = Acceptor.access$100(Acceptor.this);
                    synchronized (var1_1) {
                        while (!Acceptor.access$100(Acceptor.this).isEmpty()) {
                            ssch = (ServerSocketChannel)Acceptor.access$100(Acceptor.this).removeFirst();
                            try {
                                ssch.register(Acceptor.access$200(Acceptor.this), 16, Acceptor.access$300(Acceptor.this));
                                Thread.sleep(1000L);
                                sock = ssch.accept();
                                System.out.println("First one is: " + sock);
                                sock.close();
                            }
                            catch (ClosedChannelException e) {
                                Log.logWarning((Throwable)e);
                            }
                        }
                        if (Acceptor.access$200(Acceptor.this).select() == 0) continue;
                    }
                    ready = Acceptor.access$200(Acceptor.this).selectedKeys();
                    it = ready.iterator();
                    while (true) {
                        if (it.hasNext()) ** break;
                        continue block19;
                        key = it.next();
                        ch = (ServerSocketChannel)key.channel();
                        handler = (SocketHandler)key.attachment();
                        try {
                            accepted = ch.accept();
                            try {
                                handler.add(accepted);
                            }
                            catch (IOException e) {
                                Log.logWarning((Throwable)e);
                                accepted.close();
                            }
                        }
                        catch (IOException e) {
                            Log.logWarning((Throwable)e);
                            key.cancel();
                            ch.close();
                        }
                        it.remove();
                    }
                    break;
                }
            }
            catch (Exception e) {
                Log.logSevere((Throwable)e);
                return;
            }
            finally {
                block22: {
                    try {
                        Acceptor.access$500(Acceptor.this).meet(Acceptor.access$400(Acceptor.this).getShutdownTimeout());
                    }
                    catch (InterruptedException e) {
                        if (!Log.isDebugging()) break block22;
                        Log.logDebug((Throwable)e);
                    }
                }
            }
        }
    }
}

