/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.mmp;

import fuego.rmi.spi.BaseConnection;
import fuego.rmi.spi.TransportException;
import fuego.rmi.util.SocketInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import oracle.bpm.log.Log;

public class SocketConnection
extends BaseConnection {
    private String peerId;
    private Socket sock;

    public SocketConnection(Socket sock) throws TransportException {
        this.sock = sock;
        try {
            this.sock.setTcpNoDelay(true);
            this.sock.setKeepAlive(true);
        }
        catch (SocketException e) {
            Log.logWarning((Throwable)e);
        }
        this.init();
        this.peerId = String.valueOf(sock.getRemoteSocketAddress());
    }

    @Override
    public String getPeerID() throws TransportException {
        return this.peerId;
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return new SocketInputStream(this.sock.getInputStream());
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this.sock.getOutputStream();
    }

    @Override
    protected void close() throws IOException {
        try {
            this.os.flush();
            try {
                this.sock.shutdownOutput();
                this.consumeInput();
                this.sock.shutdownInput();
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            this.sock.close();
            this.sock = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void consumeInput() {
        try {
            this.sock.setSoTimeout(50);
            byte[] buf = new byte[512];
            while (this.is.read(buf) > 0) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

