/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.mmp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import oracle.bpm.log.Log;
import oracle.bpm.util.FuegoDirectories;

class SSLProperties {
    private List<Change> changes = new ArrayList<Change>(5);
    private String[] enabledCipherSuites;
    private String keyManagerFactory;
    private String keyManagerProvider;
    private String keystoreFile;
    private String keystoreType;
    private boolean needsClientAuthentication;
    private char[] passphrase;
    private String sslProtocol;
    private String sslProvider;
    private String trustManagerFactory;
    private String trustManagerProvider;
    private boolean wantsClientAuthentication;
    private static final String KEYSTORE_PASSWORD = "keystore.password";
    private static final String KEYSTORE_TYPE = "keystore.type";
    private static final String KEYSTORE_FILE = "keystore.file";
    private static final String KEY_MANAGER_PROVIDER = "keyManager.provider";
    private static final String KEY_MANAGER_FACTORY = "keyManager.factory";
    private static final String TRUST_MANAGER_PROVIDER = "trustManager.provider";
    private static final String TRUST_MANAGER_FACTORY = "trustManager.factory";
    private static final String SSL_PROTOCOL = "ssl.protocol";
    private static final String SSL_PROVIDER = "ssl.provider";
    private static final String ENABLED_CIPHER_SUITES = "enabledCipherSuites";
    private static final String WANTS_CLIENT_AUTH = "wantsClientAuthentication";
    private static final String NEEDS_CLIENT_AUTH = "needsClientAuthentication";
    private static final String SCRAMBLE_PREFIX = "<scrambled>";
    private static final String REMOVED_PREFIX = "<removed>";

    private SSLProperties() {
        this.load();
    }

    public static void main(String[] args) throws Throwable {
        SSLProperties sslProperties = SSLProperties.create();
        System.out.println("------------------ keystore");
        System.out.println("keystore.file " + sslProperties.getKeystoreFile());
        System.out.println("keystore.type " + sslProperties.getKeystoreType());
        System.out.println("keystore.password '" + String.valueOf(sslProperties.getKeystorePassword()) + "'");
        System.out.println("------------------ key manager");
        System.out.println("keyManager.factory " + sslProperties.getKeyManagerFactory());
        System.out.println("keyManager.provider " + sslProperties.getKeyManagerProvider());
        System.out.println("------------------ trust manager");
        System.out.println("trustManager.factory " + sslProperties.getTrustManagerFactory());
        System.out.println("trustManager.provider " + sslProperties.getTrustManagerProvider());
        System.out.println("------------------ ssl");
        System.out.println("ssl.protocol " + sslProperties.getSslProtocol());
        System.out.println("ssl.provider " + sslProperties.getSslProvider());
        System.out.println("------------------ misc");
        System.out.println("wantsClientAuthentication " + sslProperties.wantsClientAuthentication());
        System.out.println("needsClientAuthentication " + sslProperties.needsClientAuthentication());
        System.out.println("enabled " + Arrays.asList(sslProperties.getEnabledCipherSuites()));
    }

    static synchronized SSLProperties create() {
        return new SSLProperties();
    }

    String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    String getKeyManagerFactory() {
        return this.keyManagerFactory == null ? KeyManagerFactory.getDefaultAlgorithm() : this.keyManagerFactory;
    }

    String getKeyManagerProvider() {
        return this.keyManagerProvider;
    }

    String getKeystoreFile() {
        return this.keystoreFile;
    }

    char[] getKeystorePassword() {
        return this.passphrase;
    }

    String getKeystoreType() {
        return this.keystoreType == null ? KeyStore.getDefaultType() : this.keystoreType;
    }

    String getSslProtocol() {
        return this.sslProtocol == null ? "ssl" : this.sslProtocol;
    }

    String getSslProvider() {
        return this.sslProvider;
    }

    String getTrustManagerFactory() {
        return this.trustManagerFactory == null ? TrustManagerFactory.getDefaultAlgorithm() : this.trustManagerFactory;
    }

    String getTrustManagerProvider() {
        return this.trustManagerProvider;
    }

    void clear() {
        this.wipe(this.passphrase);
    }

    boolean needsClientAuthentication() {
        return this.needsClientAuthentication;
    }

    boolean wantsClientAuthentication() {
        return this.wantsClientAuthentication;
    }

    private File canonicalize(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            if (Log.isDebugging()) {
                Log.logDebug((Throwable)e);
            }
            file = null;
        }
        return file;
    }

    private void descramble(char[] source, int valueStart, int valueEnd) {
        int len = valueEnd - valueStart;
        if ((len & 3) == 0) {
            int low;
            int high;
            int i;
            byte[] buffer = new byte[len / 2];
            for (i = 0; i < buffer.length; ++i) {
                high = Character.digit(source[valueStart + 2 * i], 16);
                low = Character.digit(source[valueStart + 2 * i + 1], 16);
                buffer[i] = (byte)(high << 4 | low);
            }
            this.passphrase = new char[len / 4];
            for (i = 0; i < this.passphrase.length; ++i) {
                high = buffer[2 * i] & 0xFF;
                low = buffer[2 * i + 1] & 0xFF;
                this.passphrase[i] = (char)(high << 8 | low);
                buffer[2 * i] = 0;
                buffer[2 * i + 1] = 0;
            }
        } else if (Log.isDebugging()) {
            Log.logDebug((String)"ssl.properties is corrupt. Unable to de-scramble password.");
        }
    }

    private void load() {
        String propertyFile = System.getProperty("fuego.rmi.ssl.properties");
        File file = null;
        if (propertyFile != null) {
            file = this.canonicalize(new File(propertyFile));
        }
        if (file == null || !file.exists() || !file.isFile()) {
            file = this.canonicalize(new File(FuegoDirectories.configDir(), "ssl.properties"));
        }
        if (file != null && file.exists() && file.isFile()) {
            this.load(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file) {
        FileReader fr;
        if (Log.isDebugging()) {
            Log.logDebug((String)("Loading SSL properties from: " + file));
        }
        int length = (int)file.length();
        char[] source = new char[length + 1];
        try {
            fr = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            if (Log.isDebugging()) {
                Log.logDebug((String)("File: " + file + " not found."));
            }
            return;
        }
        try {
            int read;
            for (int count = 0; (read = fr.read(source, count, source.length - count)) != -1 && count < length; count += read) {
            }
            if (read != -1) {
                if (Log.isDebugging()) {
                    Log.logDebug((String)("Unexpected error reading: " + file));
                }
                return;
            }
        }
        catch (IOException e) {
            if (Log.isDebugging()) {
                Log.logDebug((String)("Failure reading: " + file));
            }
            if (Log.isDebugging()) {
                Log.logDebug((Throwable)e);
            }
            return;
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException ignore) {}
        }
        try {
            this.parse(source);
            this.scramble(source, file);
        }
        finally {
            this.wipe(source);
        }
    }

    private void parse(char[] source) {
        int len = source.length;
        int i = 0;
        while (i < len && source[i] != '\u0000') {
            while (i < len && source[i] != '\u0000' && Character.isWhitespace(source[i])) {
                ++i;
            }
            if (source[i] == '#') {
                while (i < len && source[i] != '\u0000' && source[i] != '\n') {
                    ++i;
                }
                ++i;
                continue;
            }
            int keyStart = i;
            while (i < len && source[i] != '\u0000' && source[i] != '\n' && source[i] != '=') {
                ++i;
            }
            int keyEnd = i;
            if (source[i] != '=') continue;
            int valueStart = ++i;
            while (i < len && source[i] != '\u0000' && source[i] != '\n') {
                ++i;
            }
            while (i > 0 && Character.isWhitespace(source[i])) {
                --i;
            }
            int valueEnd = i + 1;
            this.process(String.valueOf(source, keyStart, keyEnd - keyStart), source, valueStart, valueEnd);
        }
    }

    private void process(String key, char[] source, int valueStart, int valueEnd) {
        if (KEYSTORE_PASSWORD.equals(key)) {
            if (this.passphrase != null) {
                if (!this.startsWith(REMOVED_PREFIX, source, valueStart, valueEnd)) {
                    this.changes.add(new Change(valueStart, valueEnd, true));
                }
                if (Log.isDebugging()) {
                    Log.logDebug((String)("Warning: duplicate key: " + key));
                }
            } else if (this.startsWith(SCRAMBLE_PREFIX, source, valueStart, valueEnd)) {
                this.descramble(source, valueStart + SCRAMBLE_PREFIX.length(), valueEnd);
            } else {
                this.passphrase = new char[valueEnd - valueStart];
                System.arraycopy(source, valueStart, this.passphrase, 0, valueEnd - valueStart);
                this.changes.add(new Change(valueStart, valueEnd, false));
            }
        } else {
            String value = String.valueOf(source, valueStart, valueEnd - valueStart);
            if (KEYSTORE_TYPE.equals(key)) {
                this.keystoreType = value;
            } else if (KEYSTORE_FILE.equals(key)) {
                this.keystoreFile = value;
            } else if (WANTS_CLIENT_AUTH.equals(key)) {
                this.wantsClientAuthentication = "true".equals(value);
            } else if (NEEDS_CLIENT_AUTH.equals(key)) {
                this.needsClientAuthentication = "true".equals(value);
            } else if (KEY_MANAGER_PROVIDER.equals(key)) {
                this.keyManagerProvider = value;
            } else if (KEY_MANAGER_FACTORY.equals(key)) {
                this.keyManagerFactory = value;
            } else if (TRUST_MANAGER_PROVIDER.equals(key)) {
                this.trustManagerProvider = value;
            } else if (TRUST_MANAGER_FACTORY.equals(key)) {
                this.trustManagerFactory = value;
            } else if (SSL_PROTOCOL.equals(key)) {
                this.sslProtocol = value;
            } else if (SSL_PROVIDER.equals(key)) {
                this.sslProvider = value;
            } else if (ENABLED_CIPHER_SUITES.equals(key)) {
                this.enabledCipherSuites = value.split(",");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scramble(char[] source, File file) {
        if (!this.changes.isEmpty()) {
            FileWriter fw;
            try {
                fw = new FileWriter(file);
            }
            catch (IOException e) {
                if (Log.isDebugging()) {
                    Log.logDebug((String)("Unable to scramble ssl.properties. Check file permissions on: " + file));
                }
                if (Log.isDebugging()) {
                    Log.logDebug((Throwable)e);
                }
                return;
            }
            try {
                Change lastChange = null;
                for (Change change : this.changes) {
                    if (lastChange == null) {
                        fw.write(source, 0, change.startOffset);
                    } else {
                        fw.write(source, lastChange.endOffset, change.startOffset - lastChange.endOffset);
                    }
                    change.write(source, fw);
                    lastChange = change;
                }
                if (lastChange == null) {
                    lastChange = new Change(-1, -1, false);
                }
                int i = lastChange.endOffset;
                while (source[i] != '\u0000') {
                    ++i;
                }
                fw.write(source, lastChange.endOffset, i - lastChange.endOffset);
            }
            catch (IOException e) {
                if (Log.isDebugging()) {
                    Log.logDebug((String)("Failure scrambling ssl.properties : " + file));
                }
                if (Log.isDebugging()) {
                    Log.logDebug((Throwable)e);
                }
            }
            finally {
                try {
                    fw.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private boolean startsWith(String text, char[] source, int valueStart, int valueEnd) {
        int i;
        for (i = 0; i < text.length() && i + valueStart < valueEnd && source[i + valueStart] == text.charAt(i); ++i) {
        }
        return i == text.length();
    }

    private void wipe(char[] chars) {
        if (chars != null) {
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = '\u0000';
            }
        }
    }

    private static class Change {
        private int endOffset;
        private boolean remove;
        private int startOffset;

        Change(int startOffset, int endOffset, boolean remove) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.remove = remove;
        }

        void write(char[] source, Writer out) throws IOException {
            if (this.remove) {
                out.write("<removed> -- this field is duplicated. It's value has been removed.");
            } else {
                int i;
                int len = this.endOffset - this.startOffset;
                byte[] databuf = new byte[2 * len];
                for (i = 0; i < len; ++i) {
                    char c = source[this.startOffset + i];
                    databuf[2 * i] = (byte)(c >>> 8);
                    databuf[2 * i + 1] = (byte)(c & 0xFF);
                }
                out.write(SSLProperties.SCRAMBLE_PREFIX);
                for (i = 0; i < databuf.length; ++i) {
                    byte b = databuf[i];
                    int high = (b & 0xF0) >>> 4;
                    int low = b & 0xF;
                    out.write(Character.forDigit(high, 16));
                    out.write(Character.forDigit(low, 16));
                    databuf[i] = 0;
                }
            }
        }
    }
}

