/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.Channel;
import fuego.rmi.SessionListener;
import fuego.rmi.StreamFactory;
import fuego.rmi.util.ObjectRegistry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.component.Principal;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;
import oracle.bpm.util.ObjectWatch;

public final class Session {
    private final Map<String, Channel> exportedChannels;
    private final Integer id;
    private SessionListener listener;
    private Map<String, List<Object>> piggyback;
    private final Object piggybackLock = new Object();
    private final Map<String, Object> properties;
    private int refCount = 0;
    private final Object refLock = new Object();
    private final ObjectRegistry registeredObjects;
    private StreamFactory streamFactory;
    public static final Integer NEW = -1;
    public static final String SESSION_ID_KEY = "fuego.rmi.sessionId";
    private static final Map<Integer, Session> sessionMap = new HashMap<Integer, Session>();
    private static final Object sessionIdLock;
    private static volatile int nextSessionID;

    private Session(Integer id, StreamFactory factory) {
        this.id = id;
        this.streamFactory = factory;
        this.registeredObjects = new ObjectRegistry();
        this.exportedChannels = new TreeMap<String, Channel>();
        this.piggyback = new TreeMap<String, List<Object>>();
        this.properties = new TreeMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session create(StreamFactory factory) {
        Session session = new Session(Session.nextSessionID(), factory);
        session.addRef();
        Map<Integer, Session> map = sessionMap;
        synchronized (map) {
            sessionMap.put(session.getId(), session);
        }
        return session;
    }

    public static Session current() {
        return Session.find(Session.currentSessionId());
    }

    public static Integer currentSessionId() {
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        if (ctx == null) {
            return null;
        }
        return (Integer)ctx.getProperty(SESSION_ID_KEY);
    }

    public static Session find(Integer id) {
        return Session.find(id, false);
    }

    public StreamFactory getStreamFactory() {
        return this.streamFactory;
    }

    public Integer getId() {
        return this.id;
    }

    public void setListener(SessionListener listener) {
        if (listener != null && this.listener != null) {
            throw new IllegalArgumentException("Session listener already set");
        }
        this.listener = listener;
    }

    public SessionListener getListener() {
        return this.listener;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Object>> clearNotifications() {
        Object object = this.piggybackLock;
        synchronized (object) {
            Map<String, List<Object>> removed = this.piggyback;
            this.piggyback = new TreeMap<String, List<Object>>();
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal deregisterObject(String name) {
        ObjectRegistry objectRegistry = this.registeredObjects;
        synchronized (objectRegistry) {
            return (Principal)this.registeredObjects.deregister(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportChannel(String name, Channel obj) {
        Map<String, Channel> map = this.exportedChannels;
        synchronized (map) {
            this.exportedChannels.put(name, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel findChannel(String name) {
        Map<String, Channel> map = this.exportedChannels;
        synchronized (map) {
            return this.exportedChannels.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal findObject(String name) {
        ObjectRegistry objectRegistry = this.registeredObjects;
        synchronized (objectRegistry) {
            return (Principal)this.registeredObjects.find(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void piggyBackNotification(String channelName, Object message) {
        Object object = this.piggybackLock;
        synchronized (object) {
            List<Object> notifications = this.piggyback.get(channelName);
            if (notifications == null) {
                notifications = new LinkedList<Object>();
                this.piggyback.put(channelName, notifications);
            }
            notifications.add(message);
        }
    }

    public void putProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(String name, Principal obj) {
        ObjectRegistry objectRegistry = this.registeredObjects;
        synchronized (objectRegistry) {
            this.registeredObjects.register(name, obj);
        }
    }

    public String toString() {
        return "Session[id=" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel unexportChannel(String name) {
        Map<String, Channel> map = this.exportedChannels;
        synchronized (map) {
            return this.exportedChannels.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Session find(Integer id, boolean lock) {
        Map<Integer, Session> map = sessionMap;
        synchronized (map) {
            Session s = sessionMap.get(id);
            if (lock && s != null) {
                s.addRef();
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRef() {
        Object object = this.refLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        boolean notify = false;
        Map<Integer, Session> map = sessionMap;
        synchronized (map) {
            Object object = this.refLock;
            synchronized (object) {
                assert (this.refCount > 0);
                if (--this.refCount == 0) {
                    sessionMap.remove(this.id);
                    notify = true;
                }
            }
        }
        if (notify && this.listener != null) {
            this.listener.sessionExpired(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Principal findObject(int index) {
        ObjectRegistry objectRegistry = this.registeredObjects;
        synchronized (objectRegistry) {
            return (Principal)this.registeredObjects.find(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int resolveObject(String name) {
        ObjectRegistry objectRegistry = this.registeredObjects;
        synchronized (objectRegistry) {
            return this.registeredObjects.indexOf(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer nextSessionID() {
        Object object = sessionIdLock;
        synchronized (object) {
            return ++nextSessionID;
        }
    }

    static {
        nextSessionID = (int)(System.currentTimeMillis() & 0x3FFFFC00L);
        sessionIdLock = new Object();
        ObjectWatch.register((String)"Fuego RMI", (String)"rmiSessions", (String)"RMI Sessions", sessionMap);
    }
}

