/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.Channel;
import fuego.rmi.ConnectionLimitException;
import fuego.rmi.ObjectNotFoundException;
import fuego.rmi.Packet;
import fuego.rmi.RMIException;
import fuego.rmi.RemoteChannelListener;
import fuego.rmi.Server;
import fuego.rmi.ServerBusyException;
import fuego.rmi.Session;
import fuego.rmi.SessionNotFoundException;
import fuego.rmi.StreamFactory;
import fuego.rmi.WrappedRuntimeException;
import fuego.rmi.msg.RmiMsg;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.PacketHandler;
import fuego.rmi.spi.ReceiveException;
import fuego.rmi.spi.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import oracle.bpm.component.Batch;
import oracle.bpm.component.ExecutionThread;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.FullQueueException;
import oracle.bpm.component.Principal;
import oracle.bpm.component.Request;
import oracle.bpm.component.Response;
import oracle.bpm.io.ReferenceInputStream;
import oracle.bpm.io.ReferenceManager;
import oracle.bpm.io.ReferenceOutputStream;
import oracle.bpm.io.ValueOutputStream;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.ExecutionContextAccessor;

class ServerCluster
implements PacketHandler,
StreamFactory {
    private final LinkedList<Connection> connections;
    private int count;
    private final Object countLock = new Object();
    private RMIException exception;
    private Integer id;
    private final Map<Integer, RemoteChannelListener> listeners;
    private ReferenceManager manager;
    private boolean released;
    private Server server;
    private final Map<Integer, Integer> sessions;
    private static int nextId;
    private static final Object idLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerCluster(Server server) {
        this.server = server;
        this.sessions = new HashMap<Integer, Integer>();
        this.listeners = new HashMap<Integer, RemoteChannelListener>();
        this.connections = new LinkedList();
        Object object = idLock;
        synchronized (object) {
            this.id = ++nextId;
        }
        this.manager = new ReferenceHandler();
    }

    @Override
    public ObjectInputStream createInputStream(InputStream in) throws IOException {
        return new ReferenceInputStream(in, this.manager);
    }

    @Override
    public ObjectOutputStream createOutputStream(OutputStream out) throws IOException {
        boolean byValue = false;
        ExecutionThreadContext executionThreadContext = ExecutionThreadContext.current();
        if (executionThreadContext != null) {
            byValue = executionThreadContext.inRelay();
        }
        Object stream = byValue ? new ValueOutputStream(out, this.manager) : new ReferenceOutputStream(out, this.manager);
        return stream;
    }

    @Override
    public void exception(Throwable t) {
        this.release(new ReceiveException(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(Packet packet) {
        if (packet.isProxyDismissed()) {
            this.dismissProxy(packet);
        } else {
            Session session;
            Integer sessionId = packet.getSessionId();
            if (sessionId.equals(Session.NEW)) {
                session = Session.create(this);
                packet.setSessionId(session.getId());
            } else {
                session = Session.find(sessionId, true);
                if (session == null) {
                    this.sendException(packet, (Throwable)((Object)new SessionNotFoundException(sessionId)));
                    return;
                }
            }
            this.update(packet, session);
            try {
                if (packet.isProcessBatch()) {
                    this.processBatch(session, packet);
                } else if (packet.isRegisterProxy()) {
                    this.registerProxy(session, packet);
                } else if (packet.isRegisterChannel()) {
                    this.registerChannel(session, packet);
                }
            }
            finally {
                session.release();
            }
        }
    }

    Integer getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void join(Connection connection) throws ConnectionLimitException {
        this.allocateConnection();
        connection.setStreamFactory(this);
        LinkedList<Connection> linkedList = this.connections;
        synchronized (linkedList) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(RMIException ex) {
        Map<Integer, Integer> map = this;
        synchronized (map) {
            if (this.released) {
                return;
            }
            this.released = true;
        }
        map = this.connections;
        synchronized (map) {
            this.server.removeCluster(this.id);
            Iterator it = this.connections.iterator();
            while (it.hasNext()) {
                Connection connection = (Connection)it.next();
                this.deallocateConnection(connection);
                it.remove();
            }
            this.exception = ex;
            this.connections.notifyAll();
        }
        map = this.sessions;
        synchronized (map) {
            for (Integer sessionId : this.sessions.values()) {
                Session.find(sessionId).release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Packet p) throws RMIException {
        Connection connection = this.aquireConnection();
        try {
            connection.send(p);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    private Server getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateConnection() throws ConnectionLimitException {
        Object object = this.countLock;
        synchronized (object) {
            if (this.count >= this.server.getMaxConnectionsPerCluster()) {
                throw ConnectionLimitException.createPerClusterLimit(this.server.getMaxConnectionsPerCluster());
            }
            this.server.allocateConnection();
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection aquireConnection() throws RMIException {
        LinkedList<Connection> linkedList = this.connections;
        synchronized (linkedList) {
            assert (this.connections != null) : "connection list shouldn't be null";
            if (this.exception != null) {
                throw this.exception;
            }
            while (this.connections.isEmpty()) {
                try {
                    this.connections.wait();
                }
                catch (InterruptedException e) {
                    Log.logSevere((Throwable)e);
                }
                if (this.exception == null) continue;
                throw this.exception;
            }
            return this.connections.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocateConnection(Connection connection) {
        connection.dismiss();
        Object object = this.countLock;
        synchronized (object) {
            --this.count;
            this.server.deallocateConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dismissProxy(Packet packet) {
        RemoteChannelListener listener;
        Integer sessionId;
        Map<Integer, Integer> map = this.sessions;
        synchronized (map) {
            sessionId = this.sessions.remove(packet.getProxyId());
        }
        if (sessionId == null) {
            Log.logWarning((Msg)RmiMsg.RMI_0105(packet));
            return;
        }
        Session session = Session.find(sessionId, false);
        if (session == null) {
            Log.logSevere((Msg)RmiMsg.RMI_0106(sessionId, packet));
            return;
        }
        session.release();
        Map<Integer, RemoteChannelListener> map2 = this.listeners;
        synchronized (map2) {
            listener = this.listeners.remove(packet.getProxyId());
        }
        if (listener != null) {
            listener.release();
        }
    }

    private void processBatch(Session session, Packet packet) {
        int objectId = packet.getObjectId();
        Principal target = objectId == -1 ? this.getServer().getDefaultPrincipal() : (objectId >= 0 ? session.findObject(objectId) : this.getServer().findObject(-objectId - 2));
        if (target == null) {
            this.sendException(packet, (Throwable)((Object)new ObjectNotFoundException(objectId)));
        } else {
            try {
                ExecutionThread.enqueue((Request)new ClientRequest(session, target, packet));
            }
            catch (FullQueueException e) {
                this.sendException(packet, (Throwable)((Object)new ServerBusyException(e.getSize())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannel(Session session, Packet packet) {
        String channelName = (String)packet.getValue();
        Channel target = session.findChannel(channelName);
        if (target == null) {
            target = this.getServer().findChannel(channelName);
        }
        if (target == null) {
            this.sendException(packet, (Throwable)((Object)new ObjectNotFoundException(channelName)));
        } else {
            RemoteChannelListener listener = new RemoteChannelListener(packet.getProxyId(), this, target);
            Map<Integer, RemoteChannelListener> map = this.listeners;
            synchronized (map) {
                this.listeners.put(packet.getProxyId(), listener);
            }
            target.register(listener);
            this.sendResult(session, packet, null);
        }
    }

    private void registerProxy(Session session, Packet packet) {
        int objectId = 0;
        Principal target = null;
        String objectName = (String)packet.getValue();
        if (objectName == null || objectName.equals("")) {
            objectId = -1;
            target = this.getServer().getDefaultPrincipal();
        }
        if (target == null && (objectId = session.resolveObject(objectName)) != -1) {
            target = session.findObject(objectId);
        }
        if (target == null && (objectId = this.getServer().resolveObject(objectName)) != -1) {
            target = this.getServer().findObject(objectId);
            objectId = -(objectId + 2);
        }
        if (target == null) {
            this.sendException(packet, (Throwable)((Object)new ObjectNotFoundException(objectName)));
        } else {
            packet.setObjectId(objectId);
            this.sendResult(session, packet, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(Connection c) {
        assert (c != null) : "connection can't be null";
        LinkedList<Connection> linkedList = this.connections;
        synchronized (linkedList) {
            if (this.exception != null) {
                c.dismiss();
                return;
            }
            this.connections.addLast(c);
            this.connections.notifyAll();
        }
    }

    private void sendException(Packet packet, Throwable ex) {
        try {
            Packet exception = Packet.createException(packet.getCorrelationId(), packet.getProxyId(), packet.getSessionId(), ex);
            this.send(exception);
        }
        catch (RMIException e) {
            Log.logWarning((Throwable)((Object)e));
        }
    }

    private void sendResult(Session session, Packet src, Batch result) {
        Packet pk = Packet.createResult(src.getCorrelationId(), src.getProxyId(), session.getId(), result);
        pk.setPiggyBack(session.clearNotifications());
        pk.setObjectId(src.getObjectId());
        boolean tryAgain = false;
        try {
            this.send(pk);
        }
        catch (RMIException e) {
            if (e instanceof SerializationException) {
                if (Log.isDebugging()) {
                    Log.logDebug((Throwable)((Object)e));
                }
                tryAgain = true;
            }
            Log.logWarning((Throwable)((Object)e));
        }
        if (tryAgain) {
            WrappedRuntimeException.wrapAllExceptions(result);
            try {
                this.send(pk);
            }
            catch (SerializationException e) {
                Log.logWarning((Throwable)((Object)e));
                try {
                    this.send(Packet.createException(src.getCorrelationId(), src.getProxyId(), session.getId(), (Throwable)((Object)e)));
                }
                catch (RMIException ex) {
                    Log.logWarning((Throwable)((Object)ex));
                }
            }
            catch (RMIException e) {
                Log.logWarning((Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Packet packet, Session session) {
        Integer sessionId;
        Map<Integer, Integer> map = this.sessions;
        synchronized (map) {
            sessionId = this.sessions.put(packet.getProxyId(), session.getId());
        }
        if (sessionId == null) {
            session.addRef();
        }
    }

    static {
        idLock = new Object();
    }

    private class ClientRequest
    implements Request {
        private Packet packet;
        private Principal principal;
        private Session session;

        ClientRequest(Session session, Principal principal, Packet packet) {
            this.session = session;
            this.principal = principal;
            this.packet = packet;
        }

        public Batch getBatch() {
            ExecutionContextAccessor.getContext().putProperty("fuego.rmi.sessionId", (Object)this.session.getId());
            return (Batch)this.packet.getValue();
        }

        public int getGroup() {
            return 0;
        }

        public Integer getId() {
            return this.packet.getContextId();
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Response getResponse() {
            return new Response(){

                public void put(Batch responses) {
                    ServerCluster.this.sendResult(ClientRequest.this.session, ClientRequest.this.packet, responses);
                }

                public void operationTimeout(long timeout) {
                    ServerCluster.this.sendException(ClientRequest.this.packet, (Throwable)((Object)new ServerBusyException(timeout)));
                }
            };
        }
    }

    private static class ReferenceHandler
    extends ReferenceManager {
        private ReferenceHandler() {
        }

        protected long makeId() {
            long key = super.makeId();
            return key << 1;
        }
    }
}

