/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.RMIRuntimeException;
import fuego.rmi.Session;
import fuego.rmi.StreamFactory;
import fuego.rmi.spi.SerializationException;
import fuego.rmi.util.BufferOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ProtocolException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.component.Batch;
import oracle.bpm.component.ExecutionThreadContext;

public class Packet {
    private Integer contextId;
    private Integer correlationId;
    private byte[] data;
    private int objectId;
    private short opcode;
    private Map<String, List<Object>> piggiback;
    private Integer proxyId;
    private Integer sessionId = Session.NEW;
    private StreamFactory streamFactory;
    private Object value;
    private static final short VERSION = 256;
    static final short OP_BEGIN_CLUSTER = 1;
    static final short OP_JOIN_CLUSTER = 2;
    static final short OP_REGISTER_PROXY = 4;
    static final short OP_PROXY_DISMISSED = 8;
    static final short OP_PROCESS_BATCH = 16;
    static final short OP_EXCEPTION = 32;
    static final short OP_RESULT = 64;
    static final short OP_REGISTER_CHANNEL = 128;
    static final short OP_NOTIFY = 256;
    static final short OP_DISMISS = 512;
    private static final int MASK_CORRELATION_ID = 244;

    private Packet() {
        this.contextId = ExecutionThreadContext.NEW;
    }

    public static Packet createException(Integer correlationId, Integer proxyId, Integer sessionId, Throwable ex) {
        Packet m = new Packet();
        assert (correlationId != null) : "correlation id is not optional";
        assert (proxyId != null) : "proxyId is not optional";
        m.opcode = (short)32;
        m.value = ex;
        m.sessionId = sessionId;
        m.correlationId = correlationId;
        m.proxyId = proxyId;
        return m;
    }

    public static Packet createResult(Integer correlationId, Integer proxyId, Integer sessionId, Object result) {
        Packet m = new Packet();
        assert (correlationId != null) : "correlation id is not optional";
        assert (proxyId != null) : "proxyId is not optional";
        m.opcode = (short)64;
        m.sessionId = sessionId;
        m.value = result;
        m.correlationId = correlationId;
        m.proxyId = proxyId;
        return m;
    }

    public static Packet read(DataInput in, StreamFactory factory) throws IOException {
        short version = in.readShort();
        if (version != 256) {
            throw new ProtocolException("Unexpected version number: 0x" + Integer.toHexString(version & 0xFFFF));
        }
        Packet pk = new Packet();
        pk.streamFactory = factory;
        pk.opcode = in.readShort();
        if ((pk.opcode & 0xF4) != 0) {
            pk.correlationId = in.readInt();
        }
        pk.sessionId = in.readInt();
        pk.contextId = in.readInt();
        pk.proxyId = in.readInt();
        pk.objectId = in.readInt();
        int length = in.readInt();
        pk.data = new byte[length];
        in.readFully(pk.data);
        return pk;
    }

    public Integer getContextId() {
        return this.contextId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setPiggyBack(Map<String, List<Object>> map) {
        this.checkLazyData();
        this.piggiback = map;
    }

    public Integer getProxyId() {
        return this.proxyId;
    }

    public boolean isRegisterChannel() {
        return this.opcode == 128;
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public Object getValue() {
        this.checkLazyData();
        return this.value;
    }

    public boolean isProcessBatch() {
        return this.opcode == 16;
    }

    public String toString() {
        return "MSG[proxyId=" + this.proxyId + (this.correlationId == null ? "" : ", correlationId=" + this.correlationId) + ", sessionId=" + this.sessionId + ", objectId=" + this.objectId + ", opcode=" + this.opcode + ", value=" + (this.data == null ? this.value : "<NOT AVAILABLE>") + "]";
    }

    public void write(BufferOutputStream out, StreamFactory factory) throws IOException {
        out.writeShort((short)256);
        out.writeShort(this.opcode);
        if ((this.opcode & 0xF4) != 0) {
            out.writeInt(this.correlationId);
        }
        out.writeInt(this.sessionId);
        out.writeInt(this.contextId);
        out.writeInt(this.proxyId == null ? -1 : this.proxyId);
        out.writeInt(this.objectId);
        int lengthAddress = out.getSize();
        out.writeInt(0);
        int dataAddress = out.getSize();
        if (factory == null) {
            factory = StreamFactory.DEFAULT;
        }
        ObjectOutputStream oos = factory.createOutputStream(out);
        oos.writeObject(this.value);
        if (this.piggiback == null) {
            oos.writeInt(0);
        } else {
            oos.writeInt(this.piggiback.size());
            for (Map.Entry<String, List<Object>> e : this.piggiback.entrySet()) {
                String channel = e.getKey();
                List<Object> notifications = e.getValue();
                oos.writeUTF(channel);
                oos.writeInt(notifications.size());
                for (Object notification : notifications) {
                    oos.writeObject(notification);
                }
            }
        }
        oos.flush();
        oos.close();
        int length = out.getSize() - dataAddress;
        out.writeIntAt(lengthAddress, length);
    }

    static Packet createBeginCluster() {
        Packet m = new Packet();
        m.opcode = 1;
        return m;
    }

    static Packet createDismiss(Integer proxyId) {
        Packet m = new Packet();
        m.opcode = (short)512;
        m.proxyId = proxyId;
        return m;
    }

    static Packet createJoinCluster(Integer groupId) {
        Packet m = new Packet();
        m.opcode = (short)2;
        m.proxyId = groupId;
        return m;
    }

    static Packet createNotification(Integer proxyId, Object obj) {
        Packet m = new Packet();
        m.opcode = (short)256;
        m.value = obj;
        m.proxyId = proxyId;
        return m;
    }

    static Packet createProcessBatch(Integer correlationId, Integer proxyId, Integer sessionId, int objectId, Integer ctxId, Batch requests) {
        Packet m = new Packet();
        assert (correlationId != null) : "correlation id is not optional";
        assert (proxyId != null) : "proxyId is not optional";
        m.opcode = (short)16;
        m.sessionId = sessionId;
        m.objectId = objectId;
        m.contextId = ctxId;
        m.value = requests;
        m.proxyId = proxyId;
        m.correlationId = correlationId;
        return m;
    }

    static Packet createProxyDismissed(Integer proxyId) {
        Packet m = new Packet();
        m.opcode = (short)8;
        m.proxyId = proxyId;
        return m;
    }

    static Packet createRegisterChannel(Integer proxyId, Integer sessionId, String objectId) {
        Packet m = new Packet();
        assert (proxyId != null) : "proxyId is not optional";
        m.opcode = (short)128;
        m.sessionId = sessionId;
        m.value = objectId;
        m.proxyId = proxyId;
        m.correlationId = proxyId;
        return m;
    }

    static Packet createRegisterProxy(Integer proxyId, Integer correlationId, Integer sessionId, String name) {
        Packet m = new Packet();
        m.opcode = (short)4;
        m.proxyId = proxyId;
        m.correlationId = correlationId;
        m.sessionId = sessionId;
        m.value = name;
        return m;
    }

    boolean isBeginGroup() {
        return this.opcode == 1;
    }

    Integer getCorrelationId() {
        return this.correlationId;
    }

    boolean isDismiss() {
        return this.opcode == 512;
    }

    boolean isException() {
        return this.opcode == 32;
    }

    boolean isJoinGroup() {
        return this.opcode == 2;
    }

    Object getNotification() {
        assert (this.opcode == 256) : "Illegal call if not a notification";
        this.checkLazyData();
        return this.value;
    }

    boolean isNotify() {
        return this.opcode == 256;
    }

    void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    Map<String, List<Object>> getPiggyBack() {
        this.checkLazyData();
        return this.piggiback;
    }

    boolean isProxyDismissed() {
        return this.opcode == 8;
    }

    boolean isRegisterProxy() {
        return this.opcode == 4;
    }

    boolean isResult() {
        return this.opcode == 64;
    }

    void setSessionId(Integer id) {
        this.sessionId = id;
    }

    private void checkLazyData() {
        if (this.data == null) {
            return;
        }
        StreamFactory factory = this.streamFactory;
        if (factory == null) {
            factory = StreamFactory.DEFAULT;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
        ObjectInputStream in = null;
        try {
            in = factory.createInputStream(bais);
            this.value = in.readObject();
            int size = in.readInt();
            if (size > 0) {
                this.piggiback = new TreeMap<String, List<Object>>();
                for (int i = 0; i < size; ++i) {
                    String channel = in.readUTF();
                    int count = in.readInt();
                    LinkedList<Object> notifications = new LinkedList<Object>();
                    for (int j = 0; j < count; ++j) {
                        notifications.add(in.readObject());
                    }
                    this.piggiback.put(channel, notifications);
                }
            } else {
                this.piggiback = null;
            }
            this.data = null;
        }
        catch (RuntimeException e) {
            throw new RMIRuntimeException((Throwable)((Object)new SerializationException(e)));
        }
        catch (IOException e) {
            throw new RMIRuntimeException((Throwable)((Object)new SerializationException(e)));
        }
        catch (ClassNotFoundException e) {
            throw new RMIRuntimeException((Throwable)((Object)new SerializationException(e)));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

