/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.ConnectionLimitException;
import fuego.rmi.Packet;
import fuego.rmi.Server;
import fuego.rmi.ServerCluster;
import fuego.rmi.Session;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.PacketHandler;
import fuego.rmi.spi.TransportException;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.log.Log;

class ConnectionInitializer
implements PacketHandler,
LowResolutionTimerListener {
    private Connection connection;
    private Server server;
    private LowResolutionTimer timer;

    ConnectionInitializer(Server server, Connection connection) {
        this.server = server;
        this.connection = connection;
        this.timer = new LowResolutionTimer(server.getHandShakeTimeout());
        this.timer.add((LowResolutionTimerListener)this);
        this.timer.start();
    }

    @Override
    public void exception(Throwable t) {
        Log.logWarning((Throwable)t);
    }

    @Override
    public void received(Packet packet) {
        Packet result;
        ServerCluster group;
        this.timer.stop();
        if (!packet.isBeginGroup() && !packet.isJoinGroup()) {
            this.connection.dismiss();
        }
        if (packet.isBeginGroup()) {
            group = this.server.createCluster();
        } else if (packet.isJoinGroup()) {
            group = this.server.findCluster(packet.getProxyId());
        } else {
            assert (false);
            return;
        }
        if (group == null) {
            int i = -1;
            result = Packet.createException(i, packet.getProxyId(), Session.NEW, new IllegalArgumentException("No group with Id: " + packet.getProxyId()));
        } else {
            int i1 = -1;
            result = Packet.createResult(i1, group.getId(), Session.NEW, null);
            try {
                this.connection.setPacketHandler(group);
                group.join(this.connection);
            }
            catch (TransportException e) {
                Log.logWarning((Throwable)((Object)e));
                group.release(e);
                this.connection.dismiss();
                return;
            }
            catch (ConnectionLimitException e) {
                Log.logWarning((Throwable)((Object)e));
                int i = -1;
                result = Packet.createException(i, group.getId(), Session.NEW, (Throwable)((Object)e));
                if (packet.isBeginGroup()) {
                    group.release(e);
                }
                group = null;
            }
        }
        try {
            this.connection.send(result);
        }
        catch (TransportException e) {
            Log.logWarning((Throwable)((Object)e));
            if (group != null) {
                group.release(e);
            }
            this.connection.dismiss();
        }
    }

    public void timerFired(LowResolutionTimer timer) {
        timer.stop();
        this.connection.dismiss();
    }
}

