/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.ConnectionInitializer;
import fuego.rmi.RMIException;
import fuego.rmi.Server;
import fuego.rmi.msg.RmiMsg;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.Listener;
import fuego.rmi.spi.TransportException;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.LifecycleLock;
import oracle.bpm.util.Rendezvous;

class ConnectionAcceptor {
    private Rendezvous complete;
    private Listener listener;
    private LifecycleLock lock;
    private String name;
    private Server server;

    ConnectionAcceptor(Server server, Listener listener, String url) {
        this.server = server;
        if (listener == null) {
            throw new NullPointerException("All arguments are required");
        }
        this.listener = listener;
        this.name = "Connection Acceptor[" + url + "]";
        this.lock = new LifecycleLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        this.lock.beginStartup();
        try {
            this.complete = new Rendezvous(2);
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ConnectionAcceptor.this.processConnections();
                    }
                    finally {
                        try {
                            ConnectionAcceptor.this.complete.meet();
                        }
                        catch (InterruptedException e) {
                            Log.logWarning((Throwable)e);
                        }
                    }
                }
            }, this.name);
            t.setPriority(10);
            t.start();
        }
        finally {
            this.lock.endStartup();
        }
    }

    void stop() throws RMIException {
        this.lock.beginShutdown();
        try {
            this.listener.dismiss();
            try {
                this.complete.meet();
            }
            catch (InterruptedException e) {
                Log.logWarning((Throwable)e);
            }
            this.listener = null;
        }
        catch (TransportException e) {
            this.lock.endShutdown();
        }
    }

    private void processConnections() {
        block4: while (true) {
            try {
                while (true) {
                    Connection c;
                    if ((c = this.listener.waitForConnection()) == null) {
                        if (this.lock.isShuttingDown() || !Log.isDebugging()) break block4;
                        Log.logDebug((Msg)RmiMsg.RMI_0101);
                        break block4;
                    }
                    c.setPacketHandler(new ConnectionInitializer(this.server, c));
                }
            }
            catch (TransportException ex) {
                Log.logWarning((Throwable)((Object)ex));
                try {
                    this.stop();
                }
                catch (RMIException e) {
                    Log.logWarning((Throwable)((Object)e));
                }
                continue;
            }
            break;
        }
    }
}

