/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.ConnectionLimitException;
import fuego.rmi.Endpoint;
import fuego.rmi.Packet;
import fuego.rmi.RMIException;
import fuego.rmi.ServerChannel;
import fuego.rmi.Session;
import fuego.rmi.StreamFactory;
import fuego.rmi.TransportFactory;
import fuego.rmi.WrappedRuntimeException;
import fuego.rmi.msg.RmiMsg;
import fuego.rmi.spi.ConnectException;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.PacketHandler;
import fuego.rmi.spi.ReceiveException;
import fuego.rmi.spi.SendException;
import fuego.rmi.spi.SerializationException;
import fuego.rmi.spi.Transport;
import fuego.rmi.spi.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.Procedure;
import oracle.bpm.component.Batch;
import oracle.bpm.io.ReferenceInputStream;
import oracle.bpm.io.ReferenceManager;
import oracle.bpm.io.ReferenceOutputStream;
import oracle.bpm.log.Log;
import oracle.bpm.log.Trace;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Latch;
import oracle.bpm.util.NetURL;
import oracle.bpm.util.ObjectWatch;
import oracle.bpm.util.Sequencer;

class ClientCluster
implements PacketHandler,
StreamFactory,
Endpoint {
    private final Map<Integer, ServerChannel> channels = new HashMap<Integer, ServerChannel>();
    private final LinkedList<Connection> connections;
    private final Object connectionsLock = new Object();
    private Throwable exception;
    private boolean failAquisition;
    private Integer groupId;
    private final Object idLock = new Object();
    private String key;
    private ReferenceManager manager;
    private int nextId = 0;
    private final Map<Long, Latch> pending = new HashMap<Long, Latch>();
    private volatile int refCount = 0;
    private final Object refLock = new Object();
    private Sequencer sequencer;
    private NetURL url;
    private static final Map<String, ClientCluster> clusters = new HashMap<String, ClientCluster>();
    private static final String CLIENT_CONNECTIONS_KEY = "fuego.rmi.clientConnections";

    private ClientCluster(String key, NetURL url) throws RMIException {
        this.key = key;
        this.url = url;
        Transport transport = TransportFactory.find(url.getProtocol());
        this.connections = new LinkedList();
        this.manager = new ReferenceHandler();
        int maxConnections = Integer.getInteger(CLIENT_CONNECTIONS_KEY, 2);
        try {
            for (int i = 0; i < maxConnections; ++i) {
                Connection connection = transport.connect(url);
                this.initialize(connection);
                this.connections.add(connection);
                connection.setPacketHandler(this);
            }
        }
        catch (TransportException e) {
            Iterator it = this.connections.iterator();
            while (it.hasNext()) {
                Connection connection = (Connection)it.next();
                connection.dismiss();
                it.remove();
            }
            throw e;
        }
        catch (ConnectionLimitException e) {
            if (this.connections.isEmpty()) {
                throw e;
            }
            Log.logWarning((Throwable)((Object)e));
        }
        this.sequencer = new Sequencer();
    }

    @Override
    public StreamFactory getStreamFactory() {
        return this;
    }

    @Override
    public void addObjectVisitor(Procedure<Object> visitor) {
        this.manager.addVisitor(visitor);
    }

    @Override
    public ObjectInputStream createInputStream(InputStream in) throws IOException {
        return new ReferenceInputStream(in, this.manager);
    }

    @Override
    public ObjectOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ReferenceOutputStream(out, this.manager);
    }

    @Override
    public void exception(Throwable t) {
        this.removeSelf();
        int i = -1;
        int i1 = -1;
        Packet ex = Packet.createException(i1, i, Session.NEW, (Throwable)((Object)new ReceiveException(t)));
        this.failTransact(t, ex);
        this.failAquisitions();
        this.dismissChannels(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(Packet packet) {
        if (packet.isResult() || packet.isException()) {
            Latch latch;
            Map<Long, Latch> map = this.pending;
            synchronized (map) {
                latch = this.pending.remove(this.makeKey(packet.getProxyId(), packet.getCorrelationId()));
            }
            if (latch != null) {
                latch.put((Object)packet);
            } else {
                Log.logWarning((Msg)RmiMsg.RMI_0102(packet));
            }
        } else if (packet.isNotify() || packet.isDismiss()) {
            ServerChannel channel;
            Map<Integer, ServerChannel> map = this.channels;
            synchronized (map) {
                channel = this.channels.get(packet.getProxyId());
            }
            if (channel != null) {
                final ServerChannel ch = channel;
                final Packet pk = packet;
                this.sequencer.execute(new Runnable(){

                    @Override
                    public void run() {
                        ch.notify(pk);
                    }
                });
            } else {
                Log.logWarning((Msg)RmiMsg.RMI_0103(packet));
            }
        } else {
            Log.logWarning((Msg)RmiMsg.RMI_0104(packet));
        }
    }

    @Override
    public void removeObjectVisitor(Procedure visitor) {
        this.manager.removeVisitor(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClientCluster find(NetURL url) throws RMIException {
        ClientCluster ep;
        String key = url.getProtocol() + ":" + url.getHost() + ":" + url.getPort();
        Map<String, ClientCluster> map = clusters;
        synchronized (map) {
            ep = clusters.get(key);
            if (ep == null) {
                ep = new ClientCluster(key, url);
                clusters.put(key, ep);
            }
            ep.addRef();
        }
        return ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRef() {
        Object object = this.refLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister(Integer proxyId) {
        Map<Integer, ServerChannel> map = this.channels;
        synchronized (map) {
            this.channels.remove(proxyId);
        }
        this.release(proxyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer nextId() {
        Object object = this.idLock;
        synchronized (object) {
            int i = ++this.nextId;
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Integer id, Integer sessionId, ServerChannel channel) throws RMIException {
        Map<Integer, ServerChannel> map = this.channels;
        synchronized (map) {
            this.channels.put(id, channel);
        }
        Packet pk = this.transact(Packet.createRegisterChannel(id, sessionId, channel.getChannelID()));
        if (pk.isException()) {
            throw (RMIException)((Object)pk.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(Integer proxyId) {
        Object trace;
        boolean release;
        block15: {
            release = false;
            try {
                this.send(Packet.createProxyDismissed(proxyId));
            }
            catch (RMIException ignore) {
                trace = Trace.getInstance(ClientCluster.class);
                if (!trace.isEnabled()) break block15;
                trace.log("RMI exception being ignored:", (Throwable)((Object)ignore));
            }
        }
        Object object = clusters;
        synchronized (object) {
            trace = this.refLock;
            synchronized (trace) {
                assert (this.refCount > 0) : "refCount > 0";
                if (--this.refCount == 0) {
                    release = true;
                    clusters.remove(this.key);
                }
            }
        }
        if (release) {
            this.sequencer.dismiss();
            object = this.connectionsLock;
            synchronized (object) {
                for (Connection c : this.connections) {
                    c.dismiss();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Packet transact(Packet p) throws RMIException {
        Latch latch = new Latch();
        Long key = this.makeKey(p.getProxyId(), p.getCorrelationId());
        Map<Long, Latch> map = this.pending;
        synchronized (map) {
            if (this.exception != null) {
                return Packet.createException(p.getCorrelationId(), p.getProxyId(), p.getSessionId(), (Throwable)((Object)new SendException(this.exception)));
            }
            this.pending.put(key, latch);
        }
        try {
            boolean tryAgain = false;
            try {
                this.send(p);
            }
            catch (SerializationException e2) {
                if (p.isProcessBatch()) {
                    tryAgain = true;
                }
                throw e2;
            }
            if (tryAgain) {
                WrappedRuntimeException.wrapAllExceptions((Batch)p.getValue());
                this.send(p);
            }
        }
        catch (RMIException e) {
            Map<Long, Latch> e2 = this.pending;
            synchronized (e2) {
                this.pending.remove(key);
            }
            throw e;
        }
        Packet packet = (Packet)latch.get();
        final Map<String, List<Object>> notifications = packet.getPiggyBack();
        if (notifications != null) {
            Sequencer.Job job = this.sequencer.execute(new Runnable(){

                @Override
                public void run() {
                    ServerChannel.piggyBack(notifications);
                }
            });
            try {
                job.waitFor();
            }
            catch (InterruptedException e) {
                Log.logSevere((Throwable)e);
            }
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection aquireConnection() throws RMIException {
        Object object = this.connectionsLock;
        synchronized (object) {
            assert (this.connections != null) : "connection list shouldn't be null";
            this.checkAquisition();
            while (this.connections.isEmpty()) {
                try {
                    this.connectionsLock.wait();
                    this.checkAquisition();
                }
                catch (InterruptedException e) {
                    Log.logSevere((Throwable)e);
                }
            }
            return this.connections.removeFirst();
        }
    }

    private void checkAquisition() throws SendException {
        if (this.failAquisition) {
            assert (this.exception != null) : "exception cannot be null";
            throw new SendException(this.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dismissChannels(Packet ex) {
        HashMap<Integer, ServerChannel> ch;
        Map<Integer, ServerChannel> map = this.channels;
        synchronized (map) {
            ch = new HashMap<Integer, ServerChannel>(this.channels);
            this.channels.clear();
        }
        Iterator it = ch.values().iterator();
        while (it.hasNext()) {
            ServerChannel channel = (ServerChannel)it.next();
            channel.notify(ex);
            channel.dismiss();
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAquisitions() {
        Object object = this.connectionsLock;
        synchronized (object) {
            this.failAquisition = true;
            this.connectionsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failTransact(Throwable t, Packet ex) {
        Map<Long, Latch> map = this.pending;
        synchronized (map) {
            this.exception = t;
            Iterator<Latch> it = this.pending.values().iterator();
            while (it.hasNext()) {
                Latch latch = it.next();
                latch.put((Object)ex);
                it.remove();
            }
        }
    }

    private void initialize(Connection connection) throws RMIException {
        final Latch result = new Latch();
        connection.setStreamFactory(this);
        connection.setPacketHandler(new PacketHandler(){

            @Override
            public void received(Packet packet) {
                result.put((Object)packet);
            }

            @Override
            public void exception(Throwable t) {
                result.put((Object)t);
            }
        });
        Packet op = this.groupId == null ? Packet.createBeginCluster() : Packet.createJoinCluster(this.groupId);
        connection.send(op);
        Object value = result.get();
        if (value instanceof Throwable) {
            throw new ConnectException(this.url.toString(), (Throwable)value);
        }
        Packet pk = (Packet)value;
        if (pk.isResult()) {
            this.groupId = pk.getProxyId();
        } else {
            if (pk.isException()) {
                Object exception = pk.getValue();
                if (exception instanceof ConnectionLimitException) {
                    throw (ConnectionLimitException)((Object)exception);
                }
                throw new ConnectException(this.url.toString(), (Throwable)exception);
            }
            assert (false) : "Unexpected opcode";
        }
    }

    private Long makeKey(Integer proxyId, Integer correlationId) {
        long key = proxyId.longValue() << 32;
        return key |= (long)correlationId.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(Connection c) {
        assert (c != null) : "connection can't be null";
        if (this.refCount == 0) {
            c.dismiss();
            return;
        }
        Object object = this.connectionsLock;
        synchronized (object) {
            this.connections.addLast(c);
            this.connectionsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelf() {
        Map<String, ClientCluster> map = clusters;
        synchronized (map) {
            clusters.remove(this.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Packet p) throws RMIException {
        Connection connection = this.aquireConnection();
        try {
            connection.send(p);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    static {
        ObjectWatch.register((String)"Fuego RMI", (String)"clientClusters", (String)"Client-side clusters of connections to a given server", clusters);
    }

    private static class ReferenceHandler
    extends ReferenceManager {
        private ReferenceHandler() {
        }

        protected long makeId() {
            long key = super.makeId();
            return key << 1 | 1L;
        }
    }
}

