/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmltype;

public final class XmlConstants {
    public static final String WSDL_PROPERTY_KEY = "wsdl_";
    public static final String SCHEMA_PROPERTY_KEY = "schema_";
    public static final String EXTERNAL_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String EXTERNAL_NO_NAMESPACE_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    private XmlConstants() {
    }

    public static String buildWsdlKey(String namespace, String wsdlLocationKey) {
        return XmlConstants.buildKey(WSDL_PROPERTY_KEY, namespace, wsdlLocationKey);
    }

    public static String buildSchemaKey(String namespace) {
        return XmlConstants.buildKey(SCHEMA_PROPERTY_KEY, namespace, null);
    }

    public static String buildSchemaKey(String namespace, String schemaLocationKey) {
        return XmlConstants.buildKey(SCHEMA_PROPERTY_KEY, namespace, schemaLocationKey);
    }

    private static String buildKey(String keyPrefix, String namespace, String schemaLocationKey) {
        if (namespace == null) {
            namespace = "";
        }
        StringBuilder key = new StringBuilder().append(keyPrefix).append(namespace);
        if (schemaLocationKey != null) {
            key.append('#').append(schemaLocationKey);
        }
        return key.toString();
    }
}

