/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmltype;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmltype.EntityResolver;
import oracle.bpm.xmltype.ImportType;
import oracle.bpm.xmltype.XmlConstants;

public class InternalImportResolver
implements EntityResolver {
    private ComponentCatalog catalog;
    private ObjectTypeDescription module;

    public InternalImportResolver() {
    }

    public InternalImportResolver(ComponentCatalog catalog) {
        this.catalog = catalog;
    }

    public InternalImportResolver(ComponentCatalog catalog, ObjectTypeDescription module) {
        this(catalog);
        this.module = module;
    }

    @Override
    public InputStream resolveEntity(String location, String namespace, ImportType importType) throws ParserException {
        boolean isCatalogRef;
        ByteArrayInputStream reader = null;
        boolean bl = isCatalogRef = location.startsWith("albpmModule_") || location.startsWith("albpmImport_");
        if (isCatalogRef) {
            try {
                String[] parts;
                int index;
                String schemaLocationKey = null;
                String moduleName = location;
                if (location.startsWith("albpmModule_")) {
                    index = "albpmModule_".length();
                    parts = location.substring(index).split("#");
                    moduleName = parts[0];
                    schemaLocationKey = parts[1];
                } else if (location.startsWith("albpmImport_")) {
                    index = "albpmImport_".length();
                    parts = location.substring(index).split("#");
                    moduleName = parts[0];
                }
                ObjectTypeDescription schemaModule = this.findSchemaModule(moduleName);
                String key = importType == ImportType.IMPORT_TYPE_WSDL11 ? XmlConstants.buildWsdlKey(namespace, schemaLocationKey) : XmlConstants.buildSchemaKey(namespace, schemaLocationKey);
                String schema = schemaModule.getProperty(key);
                reader = new ByteArrayInputStream(schema.getBytes());
            }
            catch (Exception e) {
                throw new ParserException(e);
            }
        }
        return reader;
    }

    protected ObjectTypeDescription findSchemaModule(String moduleName) throws Exception {
        ObjectTypeDescription schemaModule = this.module;
        if (schemaModule == null) {
            assert (this.catalog != null) : "Catalog and Module cant not be null at the same time";
            schemaModule = (ObjectTypeDescription)this.catalog.find(moduleName).get();
        }
        return schemaModule;
    }
}

