/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;

public class XmlRootElementFactory {
    private Map<String, TypeDescription> elementContentMap = null;

    public XmlRootElementFactory(ObjectTypeDescription moduleTypeDescription) {
        this.initMapping(moduleTypeDescription);
    }

    public TypeDescription getContentTypeOf(String localName, String namespace) {
        TypeDescription typeDescription = null;
        if (localName != null) {
            String key = namespace + ":" + localName;
            typeDescription = this.elementContentMap.get(key);
        }
        return typeDescription;
    }

    private void initMapping(ObjectTypeDescription moduleTypeDescription) {
        if (moduleTypeDescription != null) {
            this.elementContentMap = new HashMap<String, TypeDescription>();
            String elements = moduleTypeDescription.getProperty("elementsMapping");
            if (elements != null && elements.length() > 0) {
                elements = elements.substring(1, elements.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(elements, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String token = (String)stringTokenizer.nextElement();
                    int separator = token.indexOf("=");
                    String key = token.substring(0, separator).trim();
                    String value = token.substring(separator + 1, token.length()).trim();
                    TypeRef typeRef = moduleTypeDescription.findInnerType(value);
                    TypeDescription typeDescription = null;
                    if (typeRef != null) {
                        typeDescription = typeRef.get();
                    } else {
                        typeRef = TypeFactory.forName(value);
                        if (typeRef != null) {
                            typeDescription = typeRef.get();
                        }
                    }
                    this.elementContentMap.put(key, typeDescription);
                }
            }
        }
    }
}

