/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.SimpleType;
import oracle.bpm.xmlschema.TypeException;

class Union
extends SchemaElement {
    Union() {
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        TypeDescription promotion = null;
        ArrayList<TypeDescription> members = new ArrayList<TypeDescription>();
        String memberTypes = this.getMemberTypes();
        if (memberTypes != null) {
            StringTokenizer ms = new StringTokenizer(memberTypes);
            while (ms.hasMoreTokens()) {
                String text = ms.nextToken();
                members.add(this.findType(text, TypeFactory.getString()));
            }
        }
        for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
            if (!(element instanceof SimpleType)) continue;
            members.add(element.buildType(current));
        }
        for (TypeDescription member : members) {
            if (promotion == null) {
                promotion = member;
                continue;
            }
            if (member == null) continue;
            if (member.isNumber() && promotion.isNumber()) {
                promotion = promotion.promote(member);
                continue;
            }
            if (member.isPredefined() && promotion.isPredefined()) {
                promotion = TypeFactory.getString();
                continue;
            }
            promotion = promotion.promote(member);
        }
        return SimpleType.ensureIsSimple(promotion);
    }

    String getMemberTypes() {
        return this.getAttribute("memberTypes");
    }
}

