/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.xmlparser.Element;
import oracle.bpm.xmlparser.ElementFactory;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlparser.Parser;
import oracle.bpm.xmlparser.Text;
import oracle.bpm.xmlschema.All;
import oracle.bpm.xmlschema.Annotation;
import oracle.bpm.xmlschema.AnyAttribute;
import oracle.bpm.xmlschema.AnyElement;
import oracle.bpm.xmlschema.AppInfo;
import oracle.bpm.xmlschema.Attribute;
import oracle.bpm.xmlschema.AttributeGroup;
import oracle.bpm.xmlschema.Choice;
import oracle.bpm.xmlschema.ComplexContent;
import oracle.bpm.xmlschema.ComplexType;
import oracle.bpm.xmlschema.Context;
import oracle.bpm.xmlschema.Documentation;
import oracle.bpm.xmlschema.ElementDef;
import oracle.bpm.xmlschema.ElementType;
import oracle.bpm.xmlschema.Enumeration;
import oracle.bpm.xmlschema.Extension;
import oracle.bpm.xmlschema.Facet;
import oracle.bpm.xmlschema.Field;
import oracle.bpm.xmlschema.FractionDigits;
import oracle.bpm.xmlschema.Group;
import oracle.bpm.xmlschema.Import;
import oracle.bpm.xmlschema.Include;
import oracle.bpm.xmlschema.Key;
import oracle.bpm.xmlschema.KeyRef;
import oracle.bpm.xmlschema.ListDef;
import oracle.bpm.xmlschema.Notation;
import oracle.bpm.xmlschema.Redefine;
import oracle.bpm.xmlschema.Restriction;
import oracle.bpm.xmlschema.Schema;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.Selector;
import oracle.bpm.xmlschema.Sequence;
import oracle.bpm.xmlschema.SimpleContent;
import oracle.bpm.xmlschema.SimpleType;
import oracle.bpm.xmlschema.TotalDigits;
import oracle.bpm.xmlschema.Union;
import oracle.bpm.xmlschema.Unique;
import org.xml.sax.Locator;

public class SchemaElementFactory
implements ElementFactory {
    private Context context;
    private Locator locator;
    private Parser parser;

    @Override
    public void setContext(NamespaceContext ctx) {
        this.context = (Context)ctx;
    }

    @Override
    public void setParser(Parser parser) {
        this.parser = parser;
    }

    @Override
    public Element create(String namespace, String name, Map<QName, String> attrs) {
        SchemaElement element;
        int type = ElementType.findByName(name);
        switch (type) {
            case 0: {
                element = new All();
                break;
            }
            case 1: {
                element = new Annotation();
                break;
            }
            case 2: {
                element = new AnyElement();
                break;
            }
            case 3: {
                element = new AnyAttribute();
                break;
            }
            case 4: {
                element = new AppInfo();
                break;
            }
            case 5: {
                element = new Attribute();
                break;
            }
            case 6: {
                element = new AttributeGroup();
                break;
            }
            case 7: {
                element = new Choice();
                break;
            }
            case 8: {
                element = new ComplexContent();
                break;
            }
            case 9: {
                element = new ComplexType();
                break;
            }
            case 10: {
                element = new Documentation();
                break;
            }
            case 11: {
                element = new ElementDef();
                break;
            }
            case 12: {
                element = new Enumeration();
                break;
            }
            case 13: {
                element = new Extension();
                break;
            }
            case 14: {
                element = new Field();
                break;
            }
            case 15: {
                element = new FractionDigits();
                break;
            }
            case 38: {
                element = new TotalDigits();
                break;
            }
            case 16: {
                element = new Group();
                break;
            }
            case 17: {
                element = new Import();
                break;
            }
            case 18: {
                element = new Include();
                break;
            }
            case 19: {
                element = new Key();
                break;
            }
            case 20: {
                element = new KeyRef();
                break;
            }
            case 21: {
                element = new Facet(1);
                break;
            }
            case 22: {
                element = new ListDef();
                break;
            }
            case 23: {
                element = new Facet(8);
                break;
            }
            case 24: {
                element = new Facet(7);
                break;
            }
            case 25: {
                element = new Facet(3);
                break;
            }
            case 26: {
                element = new Facet(10);
                break;
            }
            case 27: {
                element = new Facet(9);
                break;
            }
            case 28: {
                element = new Facet(2);
                break;
            }
            case 29: {
                element = new Notation();
                break;
            }
            case 30: {
                element = new Facet(4);
                break;
            }
            case 31: {
                element = new Redefine();
                break;
            }
            case 32: {
                element = new Restriction();
                break;
            }
            case 33: {
                element = new Schema();
                break;
            }
            case 34: {
                element = new Selector();
                break;
            }
            case 35: {
                element = new Sequence();
                break;
            }
            case 36: {
                element = new SimpleContent();
                break;
            }
            case 37: {
                element = new SimpleType();
                break;
            }
            case 39: {
                element = new Union();
                break;
            }
            case 40: {
                element = new Unique();
                break;
            }
            default: {
                this.parser.warning("unknown tag '" + name + "' from '" + namespace + "'");
                element = new SchemaElement();
            }
        }
        if (this.locator == null && this.parser != null) {
            this.locator = this.parser.getLocator();
        }
        element.setTagName(name);
        element.setNamespace(namespace);
        element.setAttributes(attrs);
        element.setXMLParser(this.parser);
        element.setNSContext(this.context);
        if (this.locator != null) {
            element.setLine(this.locator.getLineNumber());
            element.setColumn(this.locator.getColumnNumber());
        }
        return element;
    }

    @Override
    public Element createText(String text) {
        return new Text(text);
    }
}

