/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmlschema.Context;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.SchemaParser;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.EntityResolver;
import oracle.bpm.xmltype.ImportType;

public class Include
extends SchemaElement {
    public String getSchemaLocation() {
        return this.getAttribute("schemaLocation");
    }

    public void setSchemaLocation(String location) {
        this.setAttribute("schemaLocation", location);
    }

    @Override
    protected void declare() {
        String location = this.getSchemaLocation();
        SchemaParser parser = (SchemaParser)this.getXMLParser();
        EntityResolver resolver = parser.getXsdImportResolver();
        if (resolver != null && !location.endsWith(".xsd")) {
            try {
                String namespace = this.getContext().getTarget().getUri();
                InputStream reader = resolver.resolveEntity(location, namespace, ImportType.IMPORT_TYPE_XSD10);
                URL ctx = this.getSchema().getLocation();
                URL url = new URL(ctx, location);
                Context context = this.getContext();
                parser.importSchema(context, url, reader);
                return;
            }
            catch (Exception e) {
                this.reportError(e);
            }
        }
        if (location != null) {
            try {
                URL context = this.getSchema().getLocation();
                URL url = new URL(context, location);
                parser.includeSchema(this.getContext(), url);
            }
            catch (TypeException e) {
                this.reportError(e);
            }
            catch (ParserException e) {
                this.reportError(e);
            }
            catch (MalformedURLException e) {
                this.reportError(e);
            }
        }
    }
}

