/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.util.Identifier;
import oracle.bpm.xmlschema.All;
import oracle.bpm.xmlschema.Context;
import oracle.bpm.xmlschema.ElementDef;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.XMLIntrospector;

class ComponentDef
extends SchemaElement {
    ComponentDef() {
    }

    ComponentDef(SchemaElement element) {
        super(element);
    }

    public void addAttribute(AttributeTypeDescription attribute) {
        String typeName;
        SchemaElement all = this.getFirst();
        if (all == null) {
            all = new All(this);
            this.setFirstElement(all);
        }
        String name = attribute.getName();
        ElementDef element = new ElementDef(all, name);
        TypeDescription type = attribute.getType();
        if (type.isArray()) {
            type = type.getElementType();
            element.setMaxOccurs("unbounded");
        }
        if (!attribute.isRequired()) {
            element.setMinOccurs("0");
        }
        Context context = this.getContext();
        if (type.isObject() || type.isEnum()) {
            ExtendedNamespace target = context.getTarget();
            typeName = target.lookupTypeName(type);
            if (typeName != null) {
                typeName = context.findPrefixByUri(target.getUri()) + ":" + typeName;
            }
        } else {
            ExtendedNamespace sfs = (ExtendedNamespace)context.findNamespaceByUri("http://www.w3.org/2001/XMLSchema");
            switch (type.getKind()) {
                case 6: {
                    typeName = "dateTime";
                    break;
                }
                case 5: {
                    typeName = "string";
                    break;
                }
                case 3: {
                    typeName = "decimal";
                    break;
                }
                default: {
                    typeName = sfs.lookupTypeName(type);
                }
            }
        }
        if (typeName == null) {
            typeName = "anyType";
        }
        element.setAttribute("type", typeName);
        all.addChild(element);
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        String name = this.getName();
        boolean anonymous = false;
        boolean backwardCompatibitly = false;
        if (name == null && current != null && current.isAttribute()) {
            String signature;
            AttributeTypeDescription attr = current.asAttribute();
            int index = (signature = attr.getReadSignature()).lastIndexOf(59);
            name = signature.substring(1, index != -1 ? index : signature.length());
            backwardCompatibitly = true;
            anonymous = true;
        } else if (name == null && current != null && (current.isObject() || current.isEnum())) {
            name = current.getName();
        }
        String namespace = this.getTarget().getUri();
        boolean hasNamespace = namespace != null;
        boolean elementsAreQualified = hasNamespace && this.getSchema().isElementQualified();
        boolean attributesAreQualified = hasNamespace && this.getSchema().isAttributeQualified();
        namespace = hasNamespace ? namespace : "";
        ObjectTypeDescription object = XMLIntrospector.create(name, namespace, elementsAreQualified, attributesAreQualified);
        object.setProperty("namespace", this.getTarget().getUri());
        object.setProperty("xmlObjectVersion", "2.0");
        if (backwardCompatibitly) {
            object.setName(Identifier.classname(Identifier.attribute(name)));
        }
        if (anonymous) {
            this.getTarget().declareAnonymous(object);
        }
        this.addAnnotations(object);
        return object;
    }

    @Override
    protected void declare() throws TypeException {
        String name = this.getName();
        if (name != null) {
            this.getTarget().declareType(name, this);
        }
    }

    boolean isAbstract() {
        return "true".equals(this.getAttribute("abstract"));
    }

    String getName() {
        return this.getAttribute("name");
    }

    @Override
    void createXsd() {
        if (this.type != null) {
            int count = this.type.getMemberCount();
            for (int i = 0; i < count; ++i) {
                MethodTypeDescription member = this.type.asObject().getMember(i);
                if (!member.isAttribute()) continue;
                this.addAttribute(member.asAttribute());
            }
        }
        super.createXsd();
    }
}

