/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ValidationException;
import oracle.bpm.type.impl.TypeDescriptionImpl;

class AttrGroupTypeDescription
extends TypeDescriptionImpl {
    private boolean anyAttribute;
    private AttributeTypeDescription[] attributes;
    private static final AttributeTypeDescription[] TYPES = new AttributeTypeDescription[0];

    AttrGroupTypeDescription() {
        this(TYPES);
    }

    AttrGroupTypeDescription(List attributes) {
        this(attributes.toArray(TYPES));
    }

    AttrGroupTypeDescription(AttributeTypeDescription[] attributes) {
        super(0, -1, -1, false);
        this.attributes = attributes;
    }

    @Override
    public String toString() {
        return "AttributeGroup(" + Arrays.asList(this.attributes) + " anyAttr = " + this.anyAttribute + ")";
    }

    void setAnyAttribute(boolean anyAttr) {
        this.anyAttribute = anyAttr;
    }

    AttributeTypeDescription[] getAttributes() {
        return this.attributes;
    }

    void addAttribute(AttributeTypeDescription attr) {
        int length = this.attributes.length;
        for (int i = 0; i < length; ++i) {
            AttributeTypeDescription attribute = this.attributes[i];
            if (!attribute.getName().equals(attr.getName())) continue;
            throw new IllegalStateException("Duplicated attribute: " + attr);
        }
        AttributeTypeDescription[] attrs = new AttributeTypeDescription[length + 1];
        System.arraycopy(this.attributes, 0, attrs, 0, length);
        attrs[length] = attr;
        this.attributes = attrs;
    }

    void addTo(ObjectTypeDescription objType) throws ValidationException {
        if (this.attributes != null) {
            for (AttributeTypeDescription attribute : this.attributes) {
                attribute = attribute.clone();
                objType.addMember(attribute);
            }
        }
    }

    boolean hasAnyAttribute() {
        return this.anyAttribute;
    }

    boolean hasAttributes() {
        return this.attributes.length > 0 || this.anyAttribute;
    }
}

