/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.xmlruntime.SerializationContext;
import oracle.bpm.xmlruntime.XMLObject;
import oracle.bpm.xmltype.XMLIntrospector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMLObjectSerializationUtils {
    public static void closeTag(String tagName, boolean qualifyElement, String currentNamespace, SerializationContext context) {
        String prefix;
        IndentedPrintWriter out = context.getOutput();
        out.print("</");
        if (qualifyElement && (prefix = (String)context.getNSMap().get(currentNamespace)) != null) {
            out.print(prefix + ":");
        }
        out.print(tagName);
        out.println(">");
    }

    public static void dumpNamespaceDefinition(SerializationContext context) {
        Set<String> namespaceDeclaration = context.getNamespaceDeclaration();
        XMLObjectSerializationUtils.dumpNamespaceDefinition(namespaceDeclaration, context.getOutput());
    }

    public static void dumpNamespaceDefinition(Set<String> namespaceDeclaration, IndentedPrintWriter out) {
        for (String declaration : namespaceDeclaration) {
            out.print(declaration);
        }
    }

    public static void addEncodingAttributes(XMLObject xmlObject, String namespace, List<XMLObject> sortedChildren, SerializationContext context, @Nullable ObjectTypeDescription objectTypeDescription) {
        String xsiType = xmlObject.getXsiTypeValue();
        IndentedPrintWriter out = context.getOutput();
        if (namespace != null && xsiType != null) {
            boolean isXsiTypeAlreadyImplemented = XMLObjectSerializationUtils.isXsiTypeAlreadyImplemented(xmlObject, objectTypeDescription);
            if (!isXsiTypeAlreadyImplemented) {
                out.print(' ');
                out.print("xsi:type=");
                out.print('\"');
                out.print("typens:");
                out.print(Str.toXMLString(xsiType));
                out.print('\"');
            }
            String elementNamespace = xmlObject.getElementNamespace();
            String elementXsiType = xmlObject.getElementXsiType();
            if (elementNamespace != null && elementXsiType != null) {
                out.print(" soapenc:arrayType=");
                out.print('\"');
                out.print("elementns:" + elementXsiType);
                int size = sortedChildren != null ? sortedChildren.size() : 0;
                out.print("[" + size + "]");
                out.print('\"');
                out.print(" xmlns:elementns=");
                out.print('\"');
                out.print(Str.toXMLString(elementNamespace));
                out.print('\"');
                out.print(" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"");
            }
            if (!isXsiTypeAlreadyImplemented) {
                out.print(" xmlns:typens=");
                out.print('\"');
                out.print(Str.toXMLString(xmlObject.getNamespace()));
                out.print('\"');
                out.print(" xmlns:xsi=");
                out.print('\"');
                out.print("http://www.w3.org/2001/XMLSchema-instance");
                out.print('\"');
            }
        }
    }

    public static List<AttributeTypeDescription> findMembersByProperty(ObjectTypeDescription objectTypeDescrition, String property, String value) {
        ArrayList<AttributeTypeDescription> result = new ArrayList<AttributeTypeDescription>();
        List<AttributeTypeDescription> attributes = XMLObjectSerializationUtils.getAllAttributes(objectTypeDescrition);
        for (AttributeTypeDescription attribute : attributes) {
            if (!Any.equals(attribute.getProperty(property), value)) continue;
            result.add(attribute);
        }
        return result;
    }

    public static List<AttributeTypeDescription> getAllAttributes(ObjectTypeDescription objectTypeDescription) {
        MethodTypeDescription[] members = objectTypeDescription.getMembers(18, 0L, 0L, TypeFinder.Scope.ALL);
        ArrayList<AttributeTypeDescription> attributes = new ArrayList<AttributeTypeDescription>();
        for (MethodTypeDescription member : members) {
            if (XMLIntrospector.XMLOBJECT.equals(member.getParent())) continue;
            attributes.add(member.asAttribute());
        }
        return attributes;
    }

    private static boolean isXsiTypeAlreadyImplemented(@NotNull XMLObject xmlObject, @Nullable ObjectTypeDescription typeDescription) {
        if (xmlObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/xmlruntime/XMLObjectSerializationUtils.isXsiTypeAlreadyImplemented must not be null");
        }
        boolean isAlreadyXsiTypeImplemented = false;
        if (typeDescription != null) {
            String isImplementedTypeStr = typeDescription.getProperty("implementsAbstractType");
            boolean isImplementedType = Boolean.valueOf(isImplementedTypeStr);
            boolean isXsiTypeDeclared = xmlObject.getXsiType() != null;
            isAlreadyXsiTypeImplemented = isXsiTypeDeclared || isImplementedType;
        }
        return isAlreadyXsiTypeImplemented;
    }
}

