/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlparser;

import java.io.IOException;
import java.nio.charset.Charset;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.Str;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.NamespaceContext;

public class Text
extends DefaultElement {
    private String content;

    public Text(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public String toString() {
        return this.content;
    }

    @Override
    public void generateXml(XmlWriter xml) throws IOException {
        String content = this.getContent();
        if (content != null) {
            xml.printChars(content.trim(), false, true, false);
        }
    }

    @Override
    protected void dump(IndentedPrintWriter out, boolean root, boolean fuegoProcessingInstruction, NamespaceContext currentCtx, String encoding, DefaultElement.DumpParameters parameters) {
        String content = this.getContent();
        if (content != null) {
            out.print(Str.toXMLString(content.trim(), Charset.forName(encoding).newEncoder()));
        }
    }
}

