/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlgen;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.xmlgen.BaseGenerator;
import oracle.bpm.xmlgen.XmlConfiguration;
import oracle.bpm.xmlgen.XmlFactoryGenerator;

public class XmlElementTypeGenerator
extends BaseGenerator {
    protected XmlElementTypeGenerator(XmlConfiguration config) {
        super(config);
    }

    void generate(Map<String, String> tags) throws IOException {
        IndentedPrintWriter out = this.openClass("ElementType");
        out.println("package " + this.getJavaPackage() + ";");
        out.println();
        out.println("public class " + this.getPrefix() + "ElementType {");
        out.indent();
        out.println();
        out.println("static int findByName(String name) {");
        out.println("    return java.util.Arrays.binarySearch(names, name);");
        out.println("}");
        out.println();
        out.println("static String findByType(int type) {");
        out.println("    return type > 0 && type < names.length ? names[type] : null;");
        out.println("}");
        out.println();
        Object[] tagNames = tags.keySet().toArray(new String[tags.size()]);
        Arrays.sort(tagNames);
        for (int i = 0; i < tagNames.length; ++i) {
            out.println("static final int " + XmlFactoryGenerator.tagConstant((String)tagNames[i]) + " = " + i + ";");
        }
        out.println();
        out.println("private static String[] names;");
        out.println();
        if (tagNames.length > 0) {
            out.println("static {");
            out.indent();
            out.println("names = new String[" + XmlFactoryGenerator.tagConstant((String)tagNames[tagNames.length - 1]) + " + 1];");
            for (Object tagName : tagNames) {
                out.println("names[" + XmlFactoryGenerator.tagConstant((String)tagName) + "] = \"" + (String)tagName + "\";");
            }
            out.dedent();
            out.println("}");
        }
        out.dedent();
        out.println("}");
        out.close();
    }
}

