/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlgen;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.JavaClassGenerator;
import oracle.bpm.util.Identifier;
import oracle.bpm.xmlgen.XmlConfiguration;
import oracle.bpm.xmlruntime.XMLSignatureParser;
import oracle.bpm.xmltype.XMLIntrospector;

class XmlClassGenerator
extends JavaClassGenerator {
    private final XmlConfiguration config;
    private Set<String> elementNames;
    private static List<String> RESERVED_NAMES = Arrays.asList("Class", "Attributes", "Position");

    XmlClassGenerator(XmlConfiguration config) {
        this.config = config;
    }

    public void setElementNames(Set<String> elementNames) {
        this.elementNames = elementNames;
    }

    @Override
    protected void generateImports(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.println("import oracle.bpm.xmlparser.ParserException;");
        out.println("import oracle.bpm.xmlparser.DefaultElement;");
        out.println("import java.io.File;");
        out.println("import java.net.URL;");
        String requires = this.config.getRequires();
        if (requires != null) {
            String[] requireList;
            for (String pkg : requireList = requires.split(",\\s+")) {
                out.println("import " + pkg + ".*;");
            }
        }
    }

    @Override
    protected void generateClassName(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.print(this.getClassName(type));
    }

    @Override
    protected void generateInheritanceDeclaration(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.print("    extends ");
        boolean printed = false;
        for (SuperType superType : type.getSuperTypes()) {
            TypeDescription typeSpec = superType.getType();
            String componentType = typeSpec.getComponentType();
            assert (componentType != null) : "Should have component type: " + typeSpec;
            if (!componentType.equals(ComponentType.XML.getText()) || typeSpec.getName().equals("XMLObject")) continue;
            this.generateType(out, typeSpec);
            out.println();
            printed = true;
            break;
        }
        if (!printed) {
            out.println(this.config.getPrefix() + "BaseElement");
        }
    }

    @Override
    protected void generateClassFields(IndentedPrintWriter out, ObjectTypeDescription type) {
        this.generateConstructor(out, type);
    }

    @Override
    protected void generateGetterName(IndentedPrintWriter out, MethodTypeDescription member) {
        String name = Identifier.capitalize(member.getName());
        if (this.isProtectedName(name)) {
            name = this.protectName(name);
        }
        out.print("get");
        out.print(name);
    }

    @Override
    protected void generateSetterName(IndentedPrintWriter out, MethodTypeDescription member) {
        String name = Identifier.capitalize(member.getName());
        if (this.isProtectedName(name)) {
            name = this.protectName(name);
        }
        out.print("set");
        out.print(name);
    }

    @Override
    protected void generateGetterBody(IndentedPrintWriter out, MethodTypeDescription member) {
        String signatureStr = member.getSignature();
        XMLSignatureParser signature = XMLSignatureParser.buildSignature(signatureStr, null);
        String name = signature.getName();
        String method = "";
        TypeDescription resultType = member.getResultType();
        int kind = resultType.getKind();
        switch (signature.getSignatureType()) {
            case 65: 
            case 67: {
                method = "get" + this.getTypePrefix(resultType) + "Attribute";
                break;
            }
            case 69: {
                switch (kind) {
                    case 11: 
                    case 17: {
                        method = "getElement";
                        break;
                    }
                    case 12: {
                        method = "getAllElementsByClass";
                    }
                }
                break;
            }
            case 86: {
                if (kind == 17) {
                    method = "getElement";
                    break;
                }
                method = "get" + this.getTypePrefix(resultType) + "ElementValue";
                break;
            }
            case 78: {
                if (resultType.isArray() && resultType.getElementType().isPredefined()) {
                    method = "getAllElementValues";
                    break;
                }
                method = "getAllElementsByClass";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown signature: " + signatureStr);
            }
        }
        out.print("return ");
        out.print(method);
        out.print("(");
        if (kind == 11 || kind == 17) {
            out.print("\"" + name + "\", ");
            this.generateType(out, resultType);
            out.print(".class");
        } else if (kind == 12 && resultType.getElementType().isPredefined()) {
            out.print("\"" + name + "\"");
        } else if (kind == 12 && resultType.getElementType().getKind() == 11) {
            this.generateType(out, resultType.getElementType());
            out.print(".class");
        } else {
            out.print("\"" + name + "\"");
        }
        out.print(")");
        out.println(";");
    }

    @Override
    protected void generateSetterBody(IndentedPrintWriter out, MethodTypeDescription member) {
        AttributeTypeDescription attribute = member.asAttribute();
        String signatureStr = attribute.getWriteSignature();
        XMLSignatureParser signature = XMLSignatureParser.buildSignature(signatureStr, null);
        int signatureType = signature.getSignatureType();
        String name = signature.getName();
        switch (signatureType) {
            case 64: 
            case 69: {
                out.print("setElement");
                break;
            }
            case 86: {
                out.print("setElementValue");
                break;
            }
            case 78: {
                if (attribute.getType().isArray() && attribute.getType().getElementType().isPredefined()) {
                    out.print("setAllElementValues");
                    break;
                }
                out.print("setAllElements");
                break;
            }
            default: {
                out.print("setAttribute");
            }
        }
        out.println("(\"" + name + "\", value);");
    }

    @Override
    protected void generateClassMethods(IndentedPrintWriter out, ObjectTypeDescription type) {
        if (this.elementNames != null && !this.elementNames.isEmpty()) {
            String className = this.config.getPrefix() + type.getName();
            out.println("public static " + className + " parse(URL url)");
            out.println("    throws ParserException");
            out.println("{");
            out.println("    return new " + this.config.getPrefix() + "ElementParser().parse" + type.getName() + "(url);");
            out.println("}");
            out.println();
            out.println("public static " + className + " parse(File file)");
            out.println("    throws ParserException");
            out.println("{");
            out.println("    return new " + this.config.getPrefix() + "ElementParser().parse" + type.getName() + "(file);");
            out.println("}");
        }
    }

    protected void generateConstructor(IndentedPrintWriter out, ObjectTypeDescription type) {
        String getClassName = this.getClassName(type);
        String tagName = type.getNativeName();
        String namespace = type.getProperty("namespace");
        if (this.elementNames != null && !this.elementNames.isEmpty()) {
            tagName = this.elementNames.iterator().next();
        }
        out.println("public " + getClassName + "() {");
        out.println("    setTagName(\"" + tagName + "\");");
        out.println("    setNamespace(\"" + namespace + "\");");
        out.println("}");
    }

    @Override
    protected void generateType(IndentedPrintWriter out, TypeDescription type) {
        if (type.equals(XMLIntrospector.XMLOBJECT)) {
            out.print("DefaultElement");
        } else if ("xml".equals(type.getComponentType()) || type.isEnum()) {
            out.print("/* " + type.getText() + "*/");
            out.print(this.config.getPrefix() + type.getName());
        } else if (type.isArray()) {
            this.generateType(out, type.getElementType());
            out.print("[]");
        } else {
            super.generateType(out, type.primitiveEquivalent(false));
        }
    }

    private boolean isProtectedName(String name) {
        return RESERVED_NAMES.contains(name);
    }

    private String protectName(String name) {
        return name + "Value";
    }

    private String getClassName(ObjectTypeDescription type) {
        return this.config.getPrefix() + (this.config.isGenerateBaseClasses() != false ? "Base" : "") + type.getName();
    }

    private String getTypePrefix(TypeDescription type) {
        String result;
        block0 : switch (type.getKind()) {
            case 6: {
                result = "Time";
                break;
            }
            case 2: {
                switch (type.getLength()) {
                    case 64: {
                        result = "Long";
                        break block0;
                    }
                    case 32: {
                        result = "Int";
                        break block0;
                    }
                    case 16: {
                        result = "Short";
                        break block0;
                    }
                }
                result = "Int";
                break;
            }
            case 1: {
                result = "Boolean";
                break;
            }
            case 4: {
                result = "Double";
                break;
            }
            case 3: {
                result = "Decimal";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }
}

