/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.resources;

import java.io.File;
import java.io.FileFilter;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FileUtils;

public enum WebContentType {
    GIF,
    PNG,
    JPG,
    CSS,
    HTML,
    HTM,
    JSP(ProjectModelMsg.JSP_FILES),
    JSF(ProjectModelMsg.JSF_FILES),
    JSPF(ProjectModelMsg.JSPF_FILES),
    WSDL,
    XSD,
    XHTML(ProjectModelMsg.XHTML_FILES),
    UNKNOWN{

        private boolean acceptFile(File file) {
            return false;
        }
    }
    ,
    FOLDER{

        @Override
        public String getFileExtension() {
            return "";
        }

        @Override
        private boolean acceptFile(File file, boolean includeDirectories) {
            return file != null && file.isDirectory();
        }
    };

    private Msg msg;
    private String fileExtension;

    private WebContentType() {
    }

    private WebContentType(Msg msg) {
        this.msg = msg;
    }

    public String getFileExtension() {
        return "." + (this.fileExtension == null ? this.name().toLowerCase() : this.fileExtension);
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public static WebContentType valueOfFileExtension(String fileExtension) {
        if (Str.isEmpty(fileExtension)) {
            return FOLDER;
        }
        WebContentType contentType = null;
        try {
            contentType = WebContentType.valueOf(fileExtension.replace(".", "").toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            contentType = UNKNOWN;
        }
        contentType.setFileExtension(fileExtension.replace(".", ""));
        return contentType;
    }

    private boolean acceptFile(File file, boolean includeDirectories) {
        boolean result = false;
        if (file != null) {
            String extension = FileUtils.getExtension(file);
            result = file.isDirectory() && includeDirectories || file.isFile() && extension != null && extension.equalsIgnoreCase(this.getFileExtension());
        }
        return result;
    }

    public FileFilter getFileFilter() {
        return this.getFileFilter(false);
    }

    public FileFilter getFileFilter(final boolean includeDirectories) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return WebContentType.this.acceptFile(file, includeDirectories);
            }
        };
    }

    public Msg getMsg() {
        return this.msg;
    }
}

