/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes.activities;

import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.resources.Msg;

public class CustomImageFeature
extends FeatureSet {
    private String encodedLocalImage;
    private BooleanFeature invertPaletteFeature;
    private BooleanFeature useLocalImageFeature = BooleanFeature.create("use_Local_Image", null, null, false);
    private static final String CUSTOM_IMAGE = "customImage";

    private CustomImageFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
        this.invertPaletteFeature = BooleanFeature.create("invert_palette_selected_image", null, null, false);
        this.addFeature(this.useLocalImageFeature);
        this.addFeature(this.invertPaletteFeature);
    }

    public static CustomImageFeature create() {
        return new CustomImageFeature(CUSTOM_IMAGE, null, null);
    }

    public BooleanFeature getInvertPaletteFeature() {
        return this.invertPaletteFeature;
    }

    @Override
    public int getSortHint() {
        return 1;
    }

    public BooleanFeature getUseLocalImageFeature() {
        return this.useLocalImageFeature;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    public void setEncodedLocalImage(String encodedLocalImage) {
        this.encodedLocalImage = encodedLocalImage;
    }

    public String getEncodedLocalImage() {
        return this.encodedLocalImage;
    }

    @Override
    public boolean isPublic() {
        return false;
    }
}

