/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import java.util.Locale;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Labeled;
import oracle.bpm.resources.Msg;

public enum TransitionDueConditionType implements I18nProvider,
Labeled
{
    SCHEDULE_BASED(ProjectModelMsg.SCHEDULE_BASED){

        @Override
        public boolean isScheduleBased() {
            return true;
        }
    }
    ,
    INTERVAL_EXPRESSION(ProjectModelMsg.INTERVAL_EXPRESSION){

        @Override
        public boolean isIntervalExpression() {
            return true;
        }
    }
    ,
    INTERVAL_CONSTANT(ProjectModelMsg.INTERVAL_CONSTANT){

        @Override
        public boolean isIntervalConstant() {
            return true;
        }
    };

    private transient Msg msg;

    private TransitionDueConditionType(Msg msg) {
        this.msg = msg;
    }

    public static TransitionDueConditionType valueOf(int n) {
        return TransitionDueConditionType.values()[n];
    }

    public int intValue() {
        return this.ordinal();
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public boolean isScheduleBased() {
        return false;
    }

    public boolean isIntervalExpression() {
        return false;
    }

    @Override
    public Msg getLabel() {
        return this.getMsg();
    }

    public boolean isIntervalConstant() {
        return false;
    }
}

