/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import java.util.Locale;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Labeled;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public enum HumanTaskType implements I18nProvider,
Labeled
{
    SIMPLE(ProjectModelMsg.SIMPLE),
    FYI(ProjectModelMsg.FYI),
    MANAGEMENT(ProjectModelMsg.MANAGEMENT),
    GROUP(ProjectModelMsg.GROUP_VOTE),
    COMPLEX(ProjectModelMsg.COMPLEX),
    INITIATOR(ProjectModelMsg.INITIATOR);

    @NotNull
    private final transient Msg msg;
    public static final HumanTaskType DEFAULT;

    private HumanTaskType(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    @Override
    public Msg getLabel() {
        return this.getMsg();
    }

    @NotNull
    private Msg getMsg() {
        return this.msg;
    }

    public boolean isSimple() {
        return this.equals(SIMPLE);
    }

    public boolean isFyi() {
        return this.equals(FYI);
    }

    public boolean isManagement() {
        return this.equals(MANAGEMENT);
    }

    public boolean isGroup() {
        return this.equals(GROUP);
    }

    public boolean isComplex() {
        return this.equals(COMPLEX);
    }

    public boolean isInitiator() {
        return this.equals(INITIATOR);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    static {
        DEFAULT = SIMPLE;
    }
}

