/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.RoutingData;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StraightRouting;
import org.jetbrains.annotations.NotNull;

public class CurvedRouting
extends RoutingData {
    private CurvedRouting(@NotNull Point ctrl) {
        super(RoutingMode.CURVED, ctrl);
    }

    public static CurvedRouting create(@NotNull Point ctrl) {
        if (SequenceFlow.NULL_CONTROL_POINT.equals(ctrl)) {
            throw new IllegalArgumentException("Attempting to create a Curved Routing Data object with an invalid control point");
        }
        return new CurvedRouting(ctrl);
    }

    @Override
    public RoutingData relocate(@NotNull Point ctrl) {
        RoutingData result = SequenceFlow.NULL_CONTROL_POINT.equals(ctrl) ? StraightRouting.create() : CurvedRouting.create(ctrl);
        return result;
    }
}

