/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.impl.keys;

import oracle.bpm.project.model.ProjectObjectType;

public abstract class ProjectObjectKey
implements Comparable {
    public final String id;

    protected ProjectObjectKey(String id) {
        assert (id != null) : "Id cannot be null";
        this.id = id;
    }

    public abstract ProjectObjectType getType();

    public String getId() {
        return this.id;
    }

    public int compareTo(Object o) {
        ProjectObjectKey projectObjectKey = (ProjectObjectKey)o;
        int typeCompare = this.compareTypes(projectObjectKey);
        return typeCompare != 0 ? typeCompare : this.id.compareTo(projectObjectKey.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectObjectKey)) {
            return false;
        }
        ProjectObjectKey projectObjectKey = (ProjectObjectKey)o;
        return !(this.id != null ? !this.id.equals(projectObjectKey.id) : projectObjectKey.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    protected int compareTypes(Object o) {
        ProjectObjectKey projectObjectKey = (ProjectObjectKey)o;
        int typeCompare = this.getType().compareTo(projectObjectKey.getType());
        return typeCompare;
    }
}

