/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.impl;

import java.util.HashMap;
import oracle.bpm.lang.Int;
import oracle.bpm.project.model.processes.TransitionDueConditionType;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public class ComponentProperty {
    private Class<? extends Enum> enumClass;
    private final boolean hidden;
    private boolean isBoolean;
    private boolean isNumeric;
    private boolean isProcessLink;
    private final String key;
    private final Msg msg;
    private static final HashMap<String, ComponentProperty> keys = new HashMap();

    protected ComponentProperty(String key, Msg msg) {
        this(key, msg, false);
    }

    protected ComponentProperty(String key, Msg msg, boolean hidden) {
        assert (key != null);
        this.key = key;
        this.msg = msg;
        this.hidden = hidden;
        keys.put(key, this);
    }

    public static ComponentProperty getProperty(String key) {
        return keys.get(key);
    }

    public static ComponentProperty createBooleanProperty(String key, Msg msg) {
        ComponentProperty result = new ComponentProperty(key, msg, false);
        result.isBoolean = true;
        return result;
    }

    public static ComponentProperty createHiddenProperty(String key) {
        return new ComponentProperty(key, null, true);
    }

    public static ComponentProperty createNumericProperty(String key, Msg msg) {
        ComponentProperty result = new ComponentProperty(key, msg, false);
        result.isNumeric = true;
        return result;
    }

    public static ComponentProperty createProperty(String key) {
        return new ComponentProperty(key, null, false);
    }

    public static ComponentProperty createProperty(String key, Msg msg) {
        return new ComponentProperty(key, msg, false);
    }

    public static ComponentProperty createEnumProperty(String key, Msg msg, Class<? extends Enum> enumClass) {
        ComponentProperty result = new ComponentProperty(key, msg, false);
        result.enumClass = enumClass;
        return result;
    }

    public static ComponentProperty createEnumProperty(String key, Class<TransitionDueConditionType> enumClass) {
        ComponentProperty result = new ComponentProperty(key, null);
        result.enumClass = enumClass;
        return result;
    }

    public static ComponentProperty createProcessLinkProperty(String key, Msg msg) {
        ComponentProperty result = new ComponentProperty(key, msg, false);
        result.isProcessLink = true;
        return result;
    }

    public String getKey() {
        return this.key;
    }

    public Msg getMsg() {
        assert (this.msg != null) : "The activity property " + this.key + " is hidden (has no message)";
        return this.msg;
    }

    public boolean isProcessLink() {
        return this.isProcessLink;
    }

    public boolean isHidden(String value) {
        return this.hidden || this.isNumeric && Integer.valueOf(value).equals(Int.ZERO);
    }

    public String getDisplayValue(String value) {
        Enum e;
        if (this.isBoolean || this.enumClass == null || (e = Enum.valueOf(this.enumClass, value)) == null || e instanceof I18nProvider) {
            // empty if block
        }
        return this.msg == null ? value : this.msg.getString();
    }

    public boolean equals(String k) {
        return k != null && this.key.equals(k);
    }
}

