/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.EnumFeature;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.InputCorrelationItemsFeature;
import oracle.bpm.project.model.features.InputDataAssociationFeature;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.features.LoggableFeature;
import oracle.bpm.project.model.features.OutputArgumentsFeature;
import oracle.bpm.project.model.features.OutputCorrelationItemsFeature;
import oracle.bpm.project.model.features.OutputDataAssociationFeature;
import oracle.bpm.project.model.features.ParticipantFeature;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.AttributeExpressionFeature;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.ReinitiatePolicy;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.LoopCharacteristicsFeature;
import org.jetbrains.annotations.NotNull;

public class UserTaskFeature
extends ParticipantFeature {
    private AppContextExpressionFeature appContextExpressionFeature;
    private StringFeature appContextFeature;
    private HumanTaskTypeFeature humanTaskTypeFeature;
    private IdContextExpressionFeature idContextExpressionFeature;
    private StringFeature idContextFeature;
    private IdKeyExpressionFeature idKeyExpressionFeature;
    private StringFeature idKeyFeature;
    private InitiatorExpressionFeature initiatorExpressionFeature;
    private StringFeature initiatorFeature;
    private IsReInitiateFeature isReInitiateFeature;
    private ManualCreationFeature manualCreationFeature;
    private OwnerExpressionFeature ownerExpressionFeature;
    private StringFeature ownerFeature;
    private PriorityExpressionFeature priorityExpressionFeature;
    private IntFeature priorityFeature;
    private ReinitiateSourceFeature reinitiateSourceFeature;
    private ReinitiatorPolicyFeature reinitiatorPolicyFeature;
    private SubjectExpressionFeature subjectExpressionFeature;
    private StringFeature subjectFeature;
    private UserTask userTask;

    private UserTaskFeature(UserTask userTask) {
        super("userTask", userTask);
        this.userTask = userTask;
        this.subjectFeature = new SubjectFeature();
        this.addFeature(this.subjectFeature);
        this.initiatorFeature = new InitiatorFeature();
        this.addFeature(this.initiatorFeature);
        this.appContextFeature = new ApplicationContextFeature();
        this.addFeature(this.appContextFeature);
        this.idContextFeature = new IdContextFeature();
        this.addFeature(this.idContextFeature);
        this.idKeyFeature = new IdKeyFeature();
        this.addFeature(this.idKeyFeature);
        this.ownerFeature = new OwnerFeature();
        this.addFeature(this.ownerFeature);
        this.priorityFeature = new PriorityFeature();
        this.addFeature(this.priorityFeature);
        this.isReInitiateFeature = new IsReInitiateFeature();
        this.addFeature(this.isReInitiateFeature);
        this.reinitiatorPolicyFeature = new ReinitiatorPolicyFeature();
        this.addFeature(this.reinitiatorPolicyFeature);
        this.manualCreationFeature = new ManualCreationFeature();
        this.addFeature(this.manualCreationFeature);
        this.humanTaskTypeFeature = HumanTaskTypeFeature.create();
        this.addFeature(this.humanTaskTypeFeature);
        this.appContextExpressionFeature = new AppContextExpressionFeature();
        this.addFeature(this.appContextExpressionFeature);
        this.idContextExpressionFeature = new IdContextExpressionFeature();
        this.addFeature(this.idContextExpressionFeature);
        this.idKeyExpressionFeature = new IdKeyExpressionFeature();
        this.addFeature(this.idKeyExpressionFeature);
        this.initiatorExpressionFeature = new InitiatorExpressionFeature();
        this.addFeature(this.initiatorExpressionFeature);
        this.ownerExpressionFeature = new OwnerExpressionFeature();
        this.addFeature(this.ownerExpressionFeature);
        this.subjectExpressionFeature = new SubjectExpressionFeature();
        this.addFeature(this.subjectExpressionFeature);
        this.reinitiateSourceFeature = new ReinitiateSourceFeature();
        this.addFeature(this.reinitiateSourceFeature);
        this.priorityExpressionFeature = new PriorityExpressionFeature();
        this.addFeature(this.priorityExpressionFeature);
        this.addFeature(InputDataAssociationFeature.create(userTask));
        this.addFeature(OutputDataAssociationFeature.create(userTask));
        this.addFeature(LoopCharacteristicsFeature.create(userTask));
        this.addFeature(InputArgumentsFeature.create(userTask));
        this.addFeature(OutputArgumentsFeature.create(userTask));
        this.addFeature(LoggableFeature.create(userTask));
        this.addFeature(InputCorrelationItemsFeature.create(userTask));
        this.addFeature(OutputCorrelationItemsFeature.create(userTask));
    }

    public static UserTaskFeature create(UserTask userTask) {
        return new UserTaskFeature(userTask);
    }

    public HumanTask getHumanTask() {
        CatalogObject catalogObject = this.getParticipant();
        return catalogObject == null ? null : catalogObject.asChild(HumanTask.class);
    }

    public CatalogMember getInvokeMethod() {
        CatalogMember result = null;
        HumanTask humanTask = this.getHumanTask();
        if (humanTask != null) {
            result = humanTask.findMember("invoke");
        }
        return result;
    }

    public void setHumanTask(HumanTask humanTask) {
        super.setParticipant(humanTask);
        this.setManualStart(humanTask != null && humanTask.getHumanTaskType() == HumanTaskType.INITIATOR);
        HumanTaskType type = humanTask == null ? HumanTaskType.DEFAULT : humanTask.getHumanTaskType();
        this.setHumanTaskType(type);
    }

    public void setSubject(Expression subject) {
        this.subjectExpressionFeature.setValue(subject);
    }

    public Expression getSubject() {
        Expression result = null;
        if (this.subjectExpressionFeature.getValue() != null) {
            result = this.subjectExpressionFeature.getValue();
        } else if (!Str.isEmpty(this.subjectFeature.getValue())) {
            result = this.createTextExpression(this.subjectFeature.getValue());
        }
        return result;
    }

    public Expression getPriority() {
        Expression result = null;
        if (this.priorityExpressionFeature.getValue() != null) {
            result = this.priorityExpressionFeature.getValue();
        } else if (this.priorityFeature.getValue() != null && this.priorityFeature.getValue() > 0) {
            result = this.createNumericExpression(this.priorityFeature.getValue());
        }
        return result;
    }

    public void setPriority(Expression priority) {
        this.priorityExpressionFeature.setValue(priority);
    }

    public HumanTaskType getHumanTaskType() {
        HumanTask humanTask = this.getHumanTask();
        return humanTask != null ? humanTask.getHumanTaskType() : (HumanTaskType)this.humanTaskTypeFeature.getValue();
    }

    public void setHumanTaskType(HumanTaskType humanTaskType) {
        this.humanTaskTypeFeature.setValue(humanTaskType);
    }

    public void setInitiator(Expression initiator) {
        this.initiatorExpressionFeature.setValue(initiator);
    }

    public Expression getInitiator() {
        Expression result = null;
        if (this.initiatorExpressionFeature.getValue() != null) {
            result = this.initiatorExpressionFeature.getValue();
        } else if (!Str.isEmpty(this.initiatorFeature.getValue())) {
            result = this.createTextExpression(this.initiatorFeature.getValue());
        }
        return result;
    }

    public void setOwner(Expression owner) {
        this.ownerExpressionFeature.setValue(owner);
    }

    public Expression getOwner() {
        Expression result = null;
        if (this.ownerExpressionFeature.getValue() != null) {
            result = this.ownerExpressionFeature.getValue();
        } else if (!Str.isEmpty(this.ownerFeature.getValue())) {
            result = this.createTextExpression(this.ownerFeature.getValue());
        }
        return result;
    }

    public void setIdentificationKey(Expression idKey) {
        this.idKeyExpressionFeature.setValue(idKey);
    }

    public Expression getIdentificationKey() {
        Expression result = null;
        if (this.idKeyExpressionFeature.getValue() != null) {
            result = this.idKeyExpressionFeature.getValue();
        } else if (!Str.isEmpty(this.idKeyFeature.getValue())) {
            result = this.createTextExpression(this.idKeyFeature.getValue());
        }
        return result;
    }

    public void setIdentificationContext(Expression idContext) {
        this.idContextExpressionFeature.setValue(idContext);
    }

    public Expression getIdentificationContext() {
        Expression result = null;
        if (this.idContextExpressionFeature.getValue() != null) {
            result = this.idContextExpressionFeature.getValue();
        } else if (!Str.isEmpty(this.idContextFeature.getValue())) {
            result = this.createTextExpression(this.idContextFeature.getValue());
        }
        return result;
    }

    public void setApplicationContext(Expression appContext) {
        this.appContextExpressionFeature.setValue(appContext);
    }

    public Expression getApplicationContext() {
        Expression result = null;
        if (this.appContextExpressionFeature.getValue() != null) {
            result = this.appContextExpressionFeature.getValue();
        } else if (!Str.isEmpty(this.appContextFeature.getValue())) {
            result = this.createTextExpression(this.appContextFeature.getValue());
        }
        return result;
    }

    public void setReInitiate(boolean value) {
        this.isReInitiateFeature.setValue(value);
    }

    public boolean isManualStart() {
        HumanTask humanTask = this.getHumanTask();
        return humanTask == null ? false : HumanTaskType.INITIATOR.equals(humanTask.getHumanTaskType());
    }

    public void setManualStart(boolean value) {
        this.manualCreationFeature.setValue(value);
    }

    public boolean isReInitiateFeature() {
        return this.isReInitiateFeature.getValue();
    }

    @Override
    public boolean mustBeSaved() {
        return true;
    }

    public ReinitiatePolicy getReinitiatePolicy() {
        return (ReinitiatePolicy)((Object)this.reinitiatorPolicyFeature.getValue());
    }

    public void setReinitiatePolicy(ReinitiatePolicy policy) {
        this.reinitiatorPolicyFeature.setValue(policy);
    }

    public UserTask getReinitiateSource() {
        UserTask result = null;
        String sourceId = this.reinitiateSourceFeature.getValue();
        if (!Str.isEmpty(sourceId)) {
            result = this.userTask.getProcess().findDescendant(UserTask.class, sourceId);
        }
        return result;
    }

    public void setReinitiateSource(UserTask source) {
        String id = source != null ? source.getId() : null;
        this.reinitiateSourceFeature.setValue(id);
    }

    private Expression createTextExpression(@NotNull String text) {
        XPathExpression result = new XPathExpression('\'' + text + '\'');
        result.setMode(ExpressionMode.TEXT);
        return result;
    }

    private Expression createNumericExpression(@NotNull Integer number) {
        String expression = String.valueOf(number);
        XPathExpression result = new XPathExpression(expression);
        result.setMode(ExpressionMode.NUMBER);
        return result;
    }

    private static final class SubjectExpressionFeature
    extends AttributeExpressionFeature {
        private SubjectExpressionFeature() {
            super("subjectExpressionFeature", null, null);
        }
    }

    private static final class PriorityExpressionFeature
    extends AttributeExpressionFeature {
        private PriorityExpressionFeature() {
            super("priorityExpressionFeature", null, null);
        }
    }

    private static final class OwnerExpressionFeature
    extends AttributeExpressionFeature {
        private OwnerExpressionFeature() {
            super("ownerExpressionFeature", null, null);
        }
    }

    private static final class InitiatorExpressionFeature
    extends AttributeExpressionFeature {
        private InitiatorExpressionFeature() {
            super("initiatorExpressionFeature", null, null);
        }
    }

    private static final class IdKeyExpressionFeature
    extends AttributeExpressionFeature {
        private IdKeyExpressionFeature() {
            super("idKeyExpressionFeature", null, null);
        }
    }

    private static final class IdContextExpressionFeature
    extends AttributeExpressionFeature {
        private IdContextExpressionFeature() {
            super("idContextExpressionFeature", null, null);
        }
    }

    private static final class AppContextExpressionFeature
    extends AttributeExpressionFeature {
        private AppContextExpressionFeature() {
            super("appContextExpressionFeature", null, null);
        }
    }

    public static class SubjectFeature
    extends StringFeature {
        private SubjectFeature() {
            super("subject", ProjectModelMsg.SUBJECT, ProjectModelMsg.SUBJECT_DSC, "");
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }

    public static class ReinitiatorPolicyFeature
    extends EnumFeature<ReinitiatePolicy> {
        private ReinitiatorPolicyFeature() {
            super(ReinitiatePolicy.class, "reinitiatorPolicy", null, null, ReinitiatePolicy.REUSE_PAYLOAD);
        }
    }

    public static class ReinitiateSourceFeature
    extends StringFeature {
        private ReinitiateSourceFeature() {
            super("reinitiateSource", ProjectModelMsg.REINITIATE_SOURCE, ProjectModelMsg.REINITIATE_SOURCE_DSC, "");
        }
    }

    public static class PriorityFeature
    extends IntFeature {
        private PriorityFeature() {
            super("priority", ProjectModelMsg.BY_PRIORITY, ProjectModelMsg.PRIORITY_DSC, 0);
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }

    public static class OwnerFeature
    extends StringFeature {
        OwnerFeature() {
            super("owner", ProjectModelMsg.OWNER, ProjectModelMsg.OWNER_DSC, "");
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }

    public static class ManualCreationFeature
    extends BooleanFeature {
        private ManualCreationFeature() {
            super("manualCreation", ProjectModelMsg.MANUAL_CREATION, ProjectModelMsg.MANUAL_CREATION_DSC, false);
        }
    }

    public static class IsReInitiateFeature
    extends BooleanFeature {
        private IsReInitiateFeature() {
            super("reinitiate", ProjectModelMsg.RE_INITIATE, ProjectModelMsg.RE_INITIATE_DSC, false);
        }
    }

    public static class InitiatorFeature
    extends StringFeature {
        private InitiatorFeature() {
            super("initiator", ProjectModelMsg.INITIATOR, ProjectModelMsg.INITIATOR_DSC, "");
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }

    public static class IdKeyFeature
    extends StringFeature {
        private IdKeyFeature() {
            super("idKey", ProjectModelMsg.ID_KEY, ProjectModelMsg.ID_KEY_DSC, "");
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }

    public static class IdContextFeature
    extends StringFeature {
        private IdContextFeature() {
            super("idContext", ProjectModelMsg.ID_CONTEXT, ProjectModelMsg.ID_CONTEXT_DSC, "");
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }

    public static class HumanTaskTypeFeature
    extends EnumFeature<HumanTaskType> {
        private HumanTaskTypeFeature() {
            super(HumanTaskType.class, "humanTaskType", null, null, HumanTaskType.DEFAULT);
        }

        public static HumanTaskTypeFeature create() {
            return new HumanTaskTypeFeature();
        }
    }

    public static class ApplicationContextFeature
    extends StringFeature {
        private ApplicationContextFeature() {
            super("appContext", ProjectModelMsg.APP_CONTEXT, ProjectModelMsg.APP_CONTEXT_DSC, "");
        }

        @Override
        public boolean mustBeSaved() {
            return false;
        }
    }
}

