/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.bpm.lang.Any;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.resources.Msg;

public class StringFeature
extends PersistentFeature<String> {
    private String defaultValue;
    private boolean hasValidValues;
    private Collection<String> validValues;
    private String value;
    private String prevValue;
    public static final StringFeature DEFAULT = new StringFeature("default", null, null, null);

    protected StringFeature(String featureName, Msg label, Msg description, String value) {
        super(featureName, label, description);
        this.defaultValue = value;
        this.setValue(value);
    }

    public static StringFeature create(String featureName, String value) {
        return StringFeature.create(featureName, null, null, value);
    }

    public static StringFeature create(String featureName, Msg label) {
        return StringFeature.create(featureName, label, label, null);
    }

    public static StringFeature create(String featureName, Msg label, Msg description, String value) {
        return new StringFeature(featureName, label, description, value);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setHasValidValues(boolean hasValidValues) {
        this.hasValidValues = hasValidValues;
    }

    @Override
    public void fill(Map<String, Object> propertiesFor) {
        Object value = propertiesFor.get(this.getName());
        if (value != null) {
            this.setObjectValue(value);
        } else {
            this.setValue(this.getDefaultValue());
        }
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public Collection<String> getValidValues() {
        this.ensureValidValues();
        return this.validValues;
    }

    public boolean hasValidValues() {
        return this.hasValidValues;
    }

    public void clearValidValues() {
        this.validValues = null;
    }

    public void addValidValues(Collection<String> validValues) {
        this.ensureValidValues();
        validValues.addAll(validValues);
    }

    public void addValidValue(String validValue) {
        this.ensureValidValues();
        this.validValues.add(validValue);
    }

    public Feature getDefault() {
        return DEFAULT;
    }

    @Override
    public void setValue(String value) {
        boolean fire = false;
        if (!Any.equals(this.value, value)) {
            this.prevValue = this.value;
            fire = true;
        }
        this.value = value;
        if (fire) {
            this.fireChanged();
        }
    }

    @Override
    public String getPrevValue() {
        return this.prevValue;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    private void ensureValidValues() {
        if (this.validValues == null) {
            this.validValues = new ArrayList<String>();
        }
    }
}

